/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"utils.h"
#include	"memory_debug.h"

void
swap_delim_str(char * dst, char * src)
{
    do {
        switch ( *src ) {

        case '/':
            src++;
            *dst++ = '\\';
            break;
        case '\\':
            src++;
            *dst++ = '/';
            break;
        default:
            *dst++ = *src++;
        }
    } while ( *(src-1) );
}


char *
change_delim_str(char * buf)
{
int len = strlen(buf);
char * ptr;
char * ret, * dst;
	
	ptr = buf;
	ret = dst = d_alloc(len+1);

	if ( buf[0] == '/' ) {
		ptr++;
	}

	swap_delim_str(dst,ptr);
	return ret;
}


char*
normalize_delim_str(char * buf)
{
char * ptr;
char * ret, * dst;
	
	ret = dst = d_alloc(strlen(buf)+2);

	for ( ptr = buf ; *ptr && *ptr != '\\' ; ptr++ ) {
		if ( *ptr == ':' ) {
			*dst++ = '/';
		}
	}
	
	swap_delim_str(dst,buf);
	return ret;
}

