//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {


#include "CLEMWindow.h"
#include "v.h"
#include "event_list.h"

Bool Draging = false;

RGBColor RGB_black = {0, 0, 0},  RGB_white = {0xffff, 0xffff, 0xffff};

extern class COSMOS  * theApp;


Window openDefaultWindow(int x, int y, int w, int h, VWINDOW *vwin, Boolean(*closeHandler)())
{
	Rect rect;
	Window theWindow = dynamic_cast<Window>
		(CLEMWindow::CreateWindow(DEF_WINDOW_ID, (LCommander*)theApp));
	theWindow->vwin = vwin;
	theWindow->SetCloseHandler(closeHandler);
	theWindow->MoveWindowTo(x,y);
	theWindow->ResizeWindowTo(w,h);
	theWindow->Show();
	theWindow->CalcPortFrameRect(rect);
	theWindow->ClearContent();
	return theWindow;
}

// ---------------------------------------------------------------------------
//		 CLEMWindow Control
// ---------------------------------------------------------------------------

CLEMWindow::CLEMWindow(LStream *inStream) : LWindow(inStream)
{
	mCloseHandler = nil;
}

CLEMWindow::~CLEMWindow()
{
}

void
CLEMWindow::AttemptClose()
{
	if ( mCloseHandler == 0 || (*mCloseHandler)() )
		LWindow::AttemptClose();
}


void CLEMWindow::ResizeFrameBy(SInt16 inWidthDelta, SInt16 inHeightDelta, Boolean inRefresh)
{
	LWindow::ResizeFrameBy(inWidthDelta, inHeightDelta, inRefresh);
	Refresh();
}

void CLEMWindow::BeginDraw()
{
	FocusDraw();
}

void CLEMWindow::EndDraw(Rect * rect)
{
	ValidPortRect(rect);
}

void CLEMWindow::EndDraw(RgnHandle rgn)
{
	ValidPortRgn(rgn);
}


void CLEMWindow::DrawSelf(void)
{
	Rect	rect;
	CalcLocalFrameRect(rect);
	
	RGBBackColor(&RGB_black);
	EraseRgn(mUpdateRgn);
	
	EVENT * newEvent = new_event();
	newEvent->type = VE_REDRAW;
	newEvent->x = rect.left;
	newEvent->y = rect.top;
	newEvent->w = rect.right - rect.left;
	newEvent->h = rect.bottom - rect.top;
	add_event(newEvent, this);
	
	LWindow::DrawSelf();
}

void CLEMWindow::ClickSelf(const SMouseDownEvent &inMouseDown)
{
	EVENT * newEvent = new_event();
	newEvent->type = VE_BUTTON;
	newEvent->subtype = VES_BUTTON_PRESS;
	newEvent->x = inMouseDown.wherePort.h;
	newEvent->y = inMouseDown.wherePort.v;
	newEvent->t = inMouseDown.macEvent.when;
	lastPoint.h = newEvent->x;
	lastPoint.v = newEvent->y;
	Draging = true;
	add_event(newEvent, this);
	LWindow::ClickSelf(inMouseDown);
}

void CLEMWindow::EventMouseUp(const EventRecord& inMacEvent)
{
	if ( Draging ) {
		Point pt = inMacEvent.where;
		GlobalToPortPoint(pt);
		EVENT * newEvent = new_event();
		newEvent->type = VE_BUTTON;
		newEvent->subtype = VES_BUTTON_RELEASE;
		newEvent->x = pt.h;
		newEvent->y = pt.v;
		newEvent->t = inMacEvent.when;
		lastPoint.h = newEvent->x;
		lastPoint.v = newEvent->y;
		Draging = false;
		add_event(newEvent, this);	
	}	
	LWindow::EventMouseUp(inMacEvent);
}

void CLEMWindow::GetCLEMWindowAttributes(VWINDOW_ATTRIBUTES * attr)
{
	Rect rect;
	CalcPortFrameRect(rect);
	attr->x = rect.top;
	attr->y = rect.left;
	attr->w = rect.right - rect.left;
	attr->h = rect.bottom - rect.top;
}

void CLEMWindow::ClearContent()
{
Rect rect;
	FocusDraw();
	CalcLocalFrameRect(rect);
	RGBBackColor(&RGB_black);
	EraseRect(&rect);
}

} // extern "C"