#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: GenBankO.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@sfc.keio.ac.jp> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::IO::GenBankO;

use strict;
use G::Messenger;

#::::::::::::::::::::::::::::::
#     Let the code begin...
#::::::::::::::::::::::::::::::

sub output {
    my $gb = shift;
    my $file = shift;

    make_gb($gb, $file);
}

sub make_gb {
    my $gb = shift;
    my $file = shift;
    my $output = shift;
    my ($type, $dummy, $i, $p, $q, $z, $lng);
    
    if ($output eq "attach"){
        open(OUT, '>>' . $file) || die($!);
    }else {
        open(OUT, '>' . $file) || die("hoge", $!);
    }

    if($gb->{LOCUS}->{circular} eq "1"){
	$type = "circular";
    }else{
        $type = "linear";
    }

    my @locus = ("LOCUS", $gb->{LOCUS}->{id}, "$gb->{LOCUS}->{length}bp", 
		 $gb->{LOCUS}->{nucleotide}, $type, $gb->{LOCUS}->{type}, 
		 $gb->{LOCUS}->{date});

    printf OUT "%-11.11s %-10.10s %-12.12s %-5.5s %-9.9s %-9.9s%-10.10s\n",@locus;
    printf OUT "%s%sFEATURES %11s Location/Qualifiers\n", $gb->{HEADER}, $gb->{COMMENT};

    foreach my $feat ($gb->feature()){
	if($gb->{$feat}->{"direction"} eq "direct"){
            if($gb->{$feat}->{join}){

		my $tmpJoinLine = $gb->{$feat}->{join};

		my @tmpjoin = ();
		foreach my $joinsegment (split(/,/, $tmpJoinLine)){
		    if($joinsegment =~ /c/){
			$joinsegment =~ s/c//g;
			push(@tmpjoin, 'complement(' . $joinsegment . ')');
		    }else{
			push(@tmpjoin, $joinsegment);
		    }
		}
		
		$tmpJoinLine = join(',', @tmpjoin);

		my $join = "join"."(". $tmpJoinLine .")";
		my $position = rindex($join,',',58);
		for($z = 0; $z <= length($join); $z += 58){
                    my $join_cut = substr($join,$z,58);

                    if($z == 0){
			printf OUT "%-4.4s %-15.15s %-58.58s\n","$dummy","$gb->{$feat}->{type}","$join_cut";
                    }else{
                        printf OUT "%-20.20s %-58.58s\n","$dummy","$join_cut";
                    }
		}
            }else{
                my @partial = split(/ /,$gb->{$feat}->{"partial"});
                if($partial[1] == 1){
                    printf OUT "%-4.4s %-15.15s %-58.58s\n",
			    "$dummy","$gb->{$feat}->{type}",
			    "$gb->{$feat}->{start}..>$gb->{$feat}->{end}";
                }elsif($partial[0] == 1){
                    printf OUT "%-4.4s %-15.15s %-58.58s\n",
			    "$dummy","$gb->{$feat}->{type}",
			    "<$gb->{$feat}->{start}..$gb->{$feat}->{end}";
                }else{
                    printf OUT "%-4.4s %-15.15s %-58.58s\n","$dummy",
			    "$gb->{$feat}->{type}",
			    "$gb->{$feat}->{start}..$gb->{$feat}->{end}";
		}
            }
	}elsif($gb->{$feat}->{"direction"} ne "direct"){
            if($gb->{$feat}->{join}){
		my $join = $gb->{$feat}->{"direction"}."("."join"."(".$gb->{$feat}->{join}.")".")";
		
                for($z = 0; $z < length($join); $z += 58){
                    my $join_cut = substr($join,$z,58);
                    if($z == 0){
                        printf OUT "%-4.4s %-15.15s %-58.58s\n",
			       "$dummy","$gb->{$feat}->{type}","$join_cut";
                    }else{
                        printf OUT "%-20.20s %-58.58s\n","$dummy","$join_cut";
		    }
		}
            }else{
                printf OUT "%-4.4s %-15.15s %-58.58s\n",
			"$dummy","$gb->{$feat}->{type}",
			"$gb->{$feat}->{direction}($gb->{$feat}->{start}..$gb->{$feat}->{end})";
            }
	}

        foreach my $key (sort keys(%{$gb->{$feat}})){
            next if($key eq "on" || $key eq "partial" || $key eq "start" || $key eq "end" 
	       || $key eq "feature" || $key eq "type" || $key eq "direction" 
	       || $key eq "join" || $key eq "cds");

	    if($gb->{$feat}->{$key} =~ /\t/){
		foreach my $multiplekey (split(/\t/, $gb->{$feat}->{$key})){
		    my $str = "/" . $key . "=" . "\"" . $multiplekey . "\"";
		    printf OUT "%-20.20s %-58.58s\n","$dummy",$str;
		}
	    }else{
		my $str = "/".$key."="."\"".$gb->{$feat}->{$key}."\"";
		$lng = length($str);
		if($lng >= 58 ){
		    if($str =~ /\s/){
			my $tmpline = "";
			foreach my $word (split(/ /, $str)){
			    if(length($tmpline) + length($word) < 58){
				$tmpline .= $word . ' ';
			    }else{
				printf OUT "%-20.20s %-58.58s\n",$dummy,$tmpline;
				$tmpline = $word . ' ';
			    }
			}
			printf OUT "%-20.20s %-58.58s\n",$dummy,$tmpline;
		    }else{
			for($i = 0;$i < $lng;$i += 58){
			    my $pr = substr($str,$i,58);
			    printf OUT "%-20.20s %-58.58s\n",$dummy,$pr;
			}
		    }
		}else{
		    printf OUT "%-20.20s %-58.58s\n","$dummy",$str;
		}
	    }
	}
    }

    print OUT "BASE COUNT $gb->{BASE_COUNT}\n";
    print OUT "ORIGIN\n";
    for($p = 0;$p<=length($gb->{SEQ});$p += 60){
	my $seq_prt = "";
        my $seq = substr($gb->{SEQ},$p,60);
	for($q = 0;$q<=60;$q += 10){
            my $seq_splt = substr($seq,$q,10);
            $seq_prt .= $seq_splt." ";
        }
        printf OUT "%9.9s %-66.66s\n",$p+1,"$seq_prt";
    }
    print OUT "//\n";

    close(OUT);

    return 1;
}



1;
