#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2008 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Primitive.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::DB::SDB;

use strict;
use base qw(Exporter);
use autouse 'Storable'=>qw(nstore retrieve);

use File::Basename;
use G::Messenger;

our @EXPORT = qw(
		 sdb_save
		 sdb_load
		 sdb_exists
		 _sdb_path
		 _set_sdb_path
		 pass_send
		 pass_get
);


#::::::::::::::::::::::::::::::
#          Perldoc
#::::::::::::::::::::::::::::::

=head1 NAME

G::DB::SDB - Persistent/Instant Data Storage for G-language v.2

=head1 SYNOPSIS

    use G::DB::SDB;

=head1 DESCRIPTION

    sdb related methods store and retrieve persistent data.
    pass related methods provide instant cache.

=head1 AUTHOR

  Kazuharu Arakawa, gaou@sfc.keio.ac.jp

=cut

#::::::::::::::::::::::::::::::
#          Variables
#::::::::::::::::::::::::::::::

my $path = $ENV{HOME} . '/.glang/';
my %data;

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub sdb_save{
    my $val = shift;
    my $name = shift || 'tmp';
    my $path = _sdb_path();

    nstore($val, $path . $name);

    return 1;
}

sub sdb_load{
    my $name = shift;
    my $path = _sdb_path();

    if (-e $path . $name){
	return retrieve($path . $name);
    }else{
	msg_error("SDB: cannot open $path . $name");
	return;
    }
}

sub sdb_exists{
    my $name = shift;
    my $path = _sdb_path();

    if(-e "$path/$name"){
	return 1;
    }else{
	return 0;
    }
}

sub _set_sdb_path{
    $path = shift;
    $path .= '/' unless(substr($path, -1, 1) eq '/');
}

sub _sdb_path{
    mkdir($path, 0777);

    return $path;
}


sub pass_send {
    my $name = shift;
    my $val = shift;

    $data{$name} = $val;
}

sub pass_get{
    my $name = shift;

    return $data{$name};
}

1;


