#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Primitive.pm,v 1.1 2002/07/30 17:44:27 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::DB::Handler;

use strict;


#::::::::::::::::::::::::::::::
#        Variables
#::::::::::::::::::::::::::::::

my $dbh;
my $table = "scratch";
my $primarykey;

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

sub rows{
    die "Can't locate object method \"rows\"" unless($dbh);

    my $self = shift;;

    return keys %$self;
}

sub columns{
    die "Can't locate object method \"columns\"" unless($dbh);

    my $self = shift;

    my $sql = ("SELECT * FROM $table LIMIT 1");
    my $sth = $dbh->prepare($sql) || die $dbh->errstr;
    $sth->execute || die $sth->errstr;
    my $ref = $sth->fetchrow_hashref();

    return keys %$ref;
}

sub set_primarykey{
    my $self = shift;
    $primarykey = shift;
}

sub set_table{
    my $self = shift;
    $table = shift;
}

sub set_dbi{
    my $self = shift;
    $dbh = shift;
}

sub dbi {
    die "Can't locate object method \"dbi\"" unless($dbh);

    return $dbh;
}


sub tables{
    die "Can't locate object method \"tables\"" unless($dbh);

    my $self = shift;
    my %tables;

    foreach my $table ($dbh->tables(undef, 'public', undef, undef, {noprefix => 1})){
	$table =~ s/^\"(.*)\"$/$1/g;
	$tables{$table} ++;
    }

    return keys %tables;
}



sub search {
    my $this = shift;

    my @args = @_;
    my $i = 0;
    my $where;

    while(defined $args[$i]){
	if(length($where)){
	    $where .= ' AND ';
	}else{
	    $where = ' WHERE ';
	}

        if (substr($args[$i], 0, 1) eq '-' && substr($args[$i], 1, 1) !~ /[0-9]/){
	    $where .= substr($args[$i],1) . ' = "' . $args[$i + 1] . '"';
            $i += 2;
        }else{
	    $where .= $args[$i];
            $i ++;
        }
    }

    print "select $primarykey from $table $where";
    my $ids = $dbh->selectcol_arrayref("select $primarykey from $table $where");

    return @$ids;
}



1;
