import gl4gcj.*;
import glut4gcj.*;

public class VertexPointerCube extends GLUT
	implements DisplayFunc, KeyboardFunc, TimerFunc, IdleFunc
{
	static final int SHOW_FPS_INTERVAL = 1000; // msec
	static final float SIZE = 0.5F;
	static final float[] VERTEX_ARRAY = new float[]{ 
		-SIZE, -SIZE,  SIZE, 
		-SIZE,  SIZE,  SIZE, 
		 SIZE,  SIZE,  SIZE, 
		 SIZE, -SIZE,  SIZE, 
		-SIZE, -SIZE, -SIZE, 
		-SIZE,  SIZE, -SIZE, 
		 SIZE,  SIZE, -SIZE, 
		 SIZE, -SIZE, -SIZE, 
	};

	static final float[] COLOR_ARRAY = new float[]{ 
		1.0F, 0.0F, 0.0F,
		0.0F, 1.0F, 1.0F,
		0.0F, 0.0F, 1.0F,
		1.0F, 1.0F, 0.0F,
		0.2F, 0.2F, 0.2F,
		0.0F, 1.0F, 0.0F,
		1.0F, 0.0F, 1.0F,
		0.8F, 0.8F, 0.8F,
	};

	static final byte[] INDICES = new byte[]{ 
		0, 3, 2, 1,
		2, 3, 7, 6,
		0, 4, 7, 3,
		1, 2, 6, 5,
		4, 5, 6, 7,
		0, 1, 5, 4,
	};

	private int angle = 0;
	private int frames = 0;

	public VertexPointerCube()
	{
		glVertexPointer(3, VERTEX_ARRAY);
		glColorPointer(3, COLOR_ARRAY);

		glEnableClientState(GL_VERTEX_ARRAY);
		glEnableClientState(GL_COLOR_ARRAY);

		glClearColor(0.0, 0.0, 0.0, 0.0); 

		glMatrixMode(GL_MODELVIEW);
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);
		glLoadIdentity();

		glRotated(this.angle, 1.0, 1.0, 1.0);
		glDrawElements(GL_QUADS, INDICES);

		glutSwapBuffers();
	}

	void rotate()
	{
		this.angle = (this.angle + 1) % 360;
	}

	public void idle()
	{
		frames++;
		rotate();
		glutPostRedisplay();
	}

	public void timer(int value)
	{
		System.out.println("FPS : " + (frames * 1000.0 / SHOW_FPS_INTERVAL));
		frames = 0;
		glutTimerFunc(SHOW_FPS_INTERVAL, this, value);
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q' || key == '')
		{
			System.exit(0);
		}
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
			glutCreateWindow("Vertex Pointer Test");

			glEnable(GL_CULL_FACE);
			glCullFace(GL_BACK);

			VertexPointerCube test = new VertexPointerCube();

			glutDisplayFunc(test);
			glutKeyboardFunc(test);
			glutIdleFunc(test);
			glutTimerFunc(SHOW_FPS_INTERVAL, test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
