import gl4gcj.*;
import glu4gcj.*;
import glut4gcj.*;

public class QuadricTest extends GLUT implements
	DisplayFunc, KeyboardFunc, SpecialFunc, MotionFunc, MouseFunc, GLUConstants
{
	private Quadric quadlic;
	private double scale = 1.0;
	private double yAngle = 0.0;
	private double xAngle = 0.0;

	public QuadricTest()
	{
		this.quadlic = new Quadric();
		this.quadlic.setDrawStyle(GLU_LINE);
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);
		glMatrixMode(GL_MODELVIEW);

		glLoadIdentity();
		glTranslated(-0.5, -0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		quadlic.cylinder(0.5, 0.1, 0.5, 20, 20);

		glLoadIdentity();
		glTranslated( 0.5, -0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		quadlic.sphere(0.5, 20, 20);

		glLoadIdentity();
		glTranslated(-0.5,  0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		quadlic.disk(0.1, 0.5, 20, 20);

		glLoadIdentity();
		glTranslated( 0.5,  0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		quadlic.partialDisk(0.1, 0.5, 20, 20, 90.0, 90.0);

		glutSwapBuffers();
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q' || key == '') System.exit(0);
	}

	public void special(int key, int x, int y)
	{
		if (key == GLUT_KEY_PAGE_UP)
		{
			scale = scale * 11.0 / 10.0;
		}
		else if (key == GLUT_KEY_PAGE_DOWN)
		{
			scale = scale * 10.0 / 11.0;
		}
		else if (key == GLUT_KEY_UP)
		{
			xAngle = (xAngle + 5.0 ) % 360;
		}
		else if (key == GLUT_KEY_DOWN)
		{
			xAngle = (xAngle - 5.0 ) % 360;
		}
		else if (key == GLUT_KEY_RIGHT)
		{
			yAngle = (yAngle + 5.0 ) % 360;
		}
		else if (key == GLUT_KEY_LEFT)
		{
			yAngle = (yAngle - 5.0 ) % 360;
		}
		glutPostRedisplay();
	}

	private int mouse_x, mouse_y;

	public void mouse(int button, int state, int x, int y)
	{
		if (state == GLUT_DOWN)
		{
			this.mouse_x = x;
			this.mouse_y = y;
		}
	}

	public void motion(int x, int y)
	{
		int diff_x = this.mouse_x - x;
		yAngle = (yAngle + x - this.mouse_x) % 360;
		xAngle = (xAngle + y - this.mouse_y) % 360;
		this.mouse_x = x;
		this.mouse_y = y;
		glutPostRedisplay();
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
			glutInitWindowSize(400, 400);
			glutCreateWindow("Quadric");

			QuadricTest test = new QuadricTest();
			glutDisplayFunc(test);
			glutMouseFunc(test);
			glutMotionFunc(test);
			glutKeyboardFunc(test);
			glutSpecialFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
