/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#include "glu4gcj/Quadric.h"
#include "glu4gcj/GLUException.h"

#include <gcj/cni.h>
#include <GL/glu.h>

using namespace glu4gcj;
using gnu::gcj::RawData;
using glu4gcj::GLUException;

// functions
static
inline
GLUException*
createDeletedQuadricException()
{
	return new GLUException(JvNewStringLatin1("This Quadric was already deleted."));
}


// instance methods

void
Quadric::setDrawStyle (jint draw)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluQuadricDrawStyle(nativeQuadric, draw);
}

void
Quadric::setNormals (jint normal)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluQuadricNormals(nativeQuadric, normal);
}

void
Quadric::setOrientation (jint orientation)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluQuadricOrientation(nativeQuadric, orientation);
}

void
Quadric::setTexture (jboolean texture)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluQuadricTexture(nativeQuadric, texture);
}

void
Quadric::cylinder (jdouble base, jdouble top, jdouble height, jint slices, jint stacks)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluCylinder(nativeQuadric, base, top, height, slices, stacks);
}

void
Quadric::disk (jdouble inner, jdouble outer, jint slices, jint loops)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluDisk(nativeQuadric, inner, outer, slices, loops);
}

void
Quadric::partialDisk (jdouble inner, jdouble outer, jint slices, jint loops, jdouble starts, jdouble sweeps)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluPartialDisk(nativeQuadric, inner, outer, slices, loops, starts, sweeps);
}

void
Quadric::sphere (jdouble radius, jint slices, jint stacks)
{
	if (this->implementation == NULL) throw createDeletedQuadricException();
	GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
	::gluSphere(nativeQuadric, radius, slices, stacks);
}

void
Quadric::deleteQuadric ()
{
	if (this->implementation != NULL)
	{
		GLUquadric* nativeQuadric = (GLUquadric*)this->implementation;
		::gluDeleteQuadric(nativeQuadric);
		this->implementation = NULL; 
	}
}

void
Quadric::initImplementation ()
{
	GLUquadric* nativeQuadric = ::gluNewQuadric();
	this->implementation = (RawData*)nativeQuadric;
}
