/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package glu4gcj;
import gnu.gcj.RawData;

public class Quadric
{
	// constructors
	public Quadric()
	{
		this.initImplementation();
	}

	// instance methods
	public native void setDrawStyle (int draw);
	public native void setNormals (int normal);
	public native void setOrientation (int orientation);
	public native void setTexture (boolean texture);

	public native void cylinder ( double base, double top, double height, int slices, int stacks);
	public native void disk (double inner, double outer, int slices, int loops);
	public native void partialDisk (double inner, double outer, int slices, int loops, double start, double sweep);
	public native void sphere (double radius, int slices, int stacks);

	public native void deleteQuadric ();

	protected void finalize()
	{
		this.deleteQuadric();
	}

	private native void initImplementation();

	// instance variables
	private RawData implementation;
}

