/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#include "glu4gcj/GLU.h"
#include <java/lang/String.h>
#include <java/lang/IllegalArgumentException.h>

#include <gcj/cni.h>
#include <GL/glu.h>

using namespace glu4gcj;
using java::lang::String;
using java::lang::IllegalArgumentException;

// functions

// instance methods

jint
GLU::gluBuild1DMipmapLevels(jint target, jint internalFormat, jint width, jint format, jint type, jint level, jint base, jint max, jfloatArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jfloat* dataElements = elements(data);
	return ::gluBuild1DMipmapLevels(target, internalFormat, width, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild1DMipmapLevels(jint target, jint internalFormat, jint width, jint format, jint type, jint level, jint base, jint max, jbyteArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jbyte* dataElements = elements(data);
	return ::gluBuild1DMipmapLevels(target, internalFormat, width, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild1DMipmapLevels(jint target, jint internalFormat, jint width, jint format, jint type, jint level, jint base, jint max, jshortArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jshort* dataElements = elements(data);
	return ::gluBuild1DMipmapLevels(target, internalFormat, width, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild1DMipmapLevels(jint target, jint internalFormat, jint width, jint format, jint type, jint level, jint base, jint max, jintArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jint* dataElements = elements(data);
	return ::gluBuild1DMipmapLevels(target, internalFormat, width, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild1DMipmaps (jint target, jint internalFormat, jint width, jint format, jint type, jfloatArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jfloat* dataElements = elements(data);
	return ::gluBuild1DMipmaps(target, internalFormat, width, format, type, dataElements);
}

jint
GLU::gluBuild1DMipmaps (jint target, jint internalFormat, jint width, jint format, jint type, jbyteArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jbyte* dataElements = elements(data);
	return ::gluBuild1DMipmaps(target, internalFormat, width, format, type, dataElements);
}

jint
GLU::gluBuild1DMipmaps (jint target, jint internalFormat, jint width, jint format, jint type, jshortArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jshort* dataElements = elements(data);
	return ::gluBuild1DMipmaps(target, internalFormat, width, format, type, dataElements);
}

jint
GLU::gluBuild1DMipmaps (jint target, jint internalFormat, jint width, jint format, jint type, jintArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jint* dataElements = elements(data);
	return ::gluBuild1DMipmaps(target, internalFormat, width, format, type, dataElements);
}

jint
GLU::gluBuild2DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jint level, jint base, jint max, jfloatArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jfloat* dataElements = elements(data);
	return ::gluBuild2DMipmapLevels(target, internalFormat, width, height, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild2DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jint level, jint base, jint max, jbyteArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jbyte* dataElements = elements(data);
	return ::gluBuild2DMipmapLevels(target, internalFormat, width, height, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild2DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jint level, jint base, jint max, jshortArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jshort* dataElements = elements(data);
	return ::gluBuild2DMipmapLevels(target, internalFormat, width, height, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild2DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jint level, jint base, jint max, jintArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jint* dataElements = elements(data);
	return ::gluBuild2DMipmapLevels(target, internalFormat, width, height, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild2DMipmaps (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jfloatArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jfloat* dataElements = elements(data);
	return ::gluBuild2DMipmaps(target, internalFormat, width, height, format, type, dataElements);
}

jint
GLU::gluBuild2DMipmaps (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jbyteArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jbyte* dataElements = elements(data);
	return ::gluBuild2DMipmaps(target, internalFormat, width, height, format, type, dataElements);
}

jint
GLU::gluBuild2DMipmaps (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jshortArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jshort* dataElements = elements(data);
	return ::gluBuild2DMipmaps(target, internalFormat, width, height, format, type, dataElements);
}

jint
GLU::gluBuild2DMipmaps (jint target, jint internalFormat, jint width, jint height, jint format, jint type, jintArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jint* dataElements = elements(data);
	return ::gluBuild2DMipmaps(target, internalFormat, width, height, format, type, dataElements);
}

jint
GLU::gluBuild3DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jint level, jint base, jint max, jfloatArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jfloat* dataElements = elements(data);
	return ::gluBuild3DMipmapLevels(target, internalFormat, width, height, depth, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild3DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jint level, jint base, jint max, jbyteArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jbyte* dataElements = elements(data);
	return ::gluBuild3DMipmapLevels(target, internalFormat, width, height, depth, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild3DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jint level, jint base, jint max, jshortArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jshort* dataElements = elements(data);
	return ::gluBuild3DMipmapLevels(target, internalFormat, width, height, depth, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild3DMipmapLevels (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jint level, jint base, jint max, jintArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jint* dataElements = elements(data);
	return ::gluBuild3DMipmapLevels(target, internalFormat, width, height, depth, format, type, level, base, max, dataElements);
}

jint
GLU::gluBuild3DMipmaps (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jfloatArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jfloat* dataElements = elements(data);
	return ::gluBuild3DMipmaps(target, internalFormat, width, height, depth, format, type, dataElements);
}

jint
GLU::gluBuild3DMipmaps (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jbyteArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jbyte* dataElements = elements(data);
	return ::gluBuild3DMipmaps(target, internalFormat, width, height, depth, format, type, dataElements);
}

jint
GLU::gluBuild3DMipmaps (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jshortArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jshort* dataElements = elements(data);
	return ::gluBuild3DMipmaps(target, internalFormat, width, height, depth, format, type, dataElements);
}

jint
GLU::gluBuild3DMipmaps (jint target, jint internalFormat, jint width, jint height, jint depth, jint format, jint type, jintArray data)
{
	JvInitClass(&GLU::class$);
	if (data == NULL) throw new IllegalArgumentException();
	jint* dataElements = elements(data);
	return ::gluBuild3DMipmaps(target, internalFormat, width, height, depth, format, type, dataElements);
}

String*
GLU::gluErrorString (jint number)
{
	JvInitClass(&GLU::class$);
	String* string = NULL;

	const GLubyte* nativeString = ::gluErrorString(number);
	if (nativeString != NULL)
	{
		string = JvNewStringLatin1((const char*)nativeString);
	}

	return string;
}

String*
GLU::gluGetString (jint number)
{
	JvInitClass(&GLU::class$);
	String* string = NULL;

	const GLubyte* nativeString = ::gluGetString(number);
	if (nativeString != NULL)
	{
		string = JvNewStringLatin1((const char*)nativeString);
	}

	return string;
}

void
GLU::gluLookAt (jdouble eyeX, jdouble eyeY, jdouble eyeZ,
	jdouble centerX, jdouble centerY, jdouble centerZ,
	jdouble upX, jdouble upY, jdouble upZ)
{
	JvInitClass(&GLU::class$);
	::gluLookAt (eyeX, eyeY, eyeZ,
		centerX, centerY, centerZ, upX, upY, upZ);
}

void
GLU::gluOrtho2D (jdouble left, jdouble right,
	jdouble bottom, jdouble top)
{
	JvInitClass(&GLU::class$);
	::gluOrtho2D (left, right, bottom, top);
}

void
GLU::gluPerspective (jdouble fovy, jdouble aspect,
	jdouble zNear, jdouble zFar)
{
	JvInitClass(&GLU::class$);
	::gluPerspective (fovy, aspect, zNear, zFar);
}

void
GLU::gluPickMatrix (jdouble x, jdouble y, jdouble delX, jdouble delY, jintArray viewport)
{
	JvInitClass(&GLU::class$);
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	jint* viewportElement = elements(viewport);
	::gluPickMatrix(x, y, delX, delY, (GLint*)viewportElement);
}

jint
GLU::gluProject (jdouble objX, jdouble objY, jdouble objZ, jdoubleArray modelMatrix, jdoubleArray projectionMatrix, jintArray viewport, jdoubleArray winX, jdoubleArray winY, jdoubleArray winZ)
{
	JvInitClass(&GLU::class$);
	if (modelMatrix == NULL || JvGetArrayLength(modelMatrix) < 16) throw new IllegalArgumentException();
	if (projectionMatrix == NULL || JvGetArrayLength(projectionMatrix) < 16) throw new IllegalArgumentException();
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	if (winX == NULL || JvGetArrayLength(winX) < 1) throw new IllegalArgumentException();
	if (winY == NULL || JvGetArrayLength(winY) < 1) throw new IllegalArgumentException();
	if (winZ == NULL || JvGetArrayLength(winZ) < 1) throw new IllegalArgumentException();
	const GLdouble* modelMatrixElement = (const GLdouble*)elements(modelMatrix);
	const GLdouble* projectionMatrixElement = (const GLdouble*)elements(projectionMatrix);
	const GLint* viewportElement = (const GLint*)elements(viewport);
	GLdouble* winXElement = (GLdouble*)elements(winX);
	GLdouble* winYElement = (GLdouble*)elements(winY);
	GLdouble* winZElement = (GLdouble*)elements(winZ);
	return ::gluProject (objX, objY, objZ, modelMatrixElement, projectionMatrixElement, viewportElement, winXElement, winYElement, winZElement);
}

jint
GLU::gluProject (jdouble objX, jdouble objY, jdouble objZ, jdoubleArray modelMatrix, jdoubleArray projectionMatrix, jintArray viewport, jdoubleArray winCoord)
{
	JvInitClass(&GLU::class$);
	if (modelMatrix == NULL || JvGetArrayLength(modelMatrix) < 16) throw new IllegalArgumentException();
	if (projectionMatrix == NULL || JvGetArrayLength(projectionMatrix) < 16) throw new IllegalArgumentException();
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	if (winCoord == NULL || JvGetArrayLength(winCoord) < 3) throw new IllegalArgumentException();
	const GLdouble* modelMatrixElement = (const GLdouble*)elements(modelMatrix);
	const GLdouble* projectionMatrixElement = (const GLdouble*)elements(projectionMatrix);
	const GLint* viewportElement = (const GLint*)elements(viewport);
	GLdouble* winCoordElement = (GLdouble*)elements(winCoord);
	return ::gluProject (objX, objY, objZ, modelMatrixElement, projectionMatrixElement, viewportElement, winCoordElement, winCoordElement+1, winCoordElement+2);
}

jint
GLU::gluUnProject (jdouble winX, jdouble winY, jdouble winZ, jdoubleArray modelMatrix, jdoubleArray projectionMatrix, jintArray viewport, jdoubleArray objX, jdoubleArray objY, jdoubleArray objZ)
{
	JvInitClass(&GLU::class$);
	if (modelMatrix == NULL || JvGetArrayLength(modelMatrix) < 16) throw new IllegalArgumentException();
	if (projectionMatrix == NULL || JvGetArrayLength(projectionMatrix) < 16) throw new IllegalArgumentException();
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	if (objX == NULL || JvGetArrayLength(objX) < 1) throw new IllegalArgumentException();
	if (objY == NULL || JvGetArrayLength(objY) < 1) throw new IllegalArgumentException();
	if (objZ == NULL || JvGetArrayLength(objZ) < 1) throw new IllegalArgumentException();
	const GLdouble* modelMatrixElement = (const GLdouble*)elements(modelMatrix);
	const GLdouble* projectionMatrixElement = (const GLdouble*)elements(projectionMatrix);
	const GLint* viewportElement = (const GLint*)elements(viewport);
	GLdouble* objXElement = (GLdouble*)elements(objX);
	GLdouble* objYElement = (GLdouble*)elements(objY);
	GLdouble* objZElement = (GLdouble*)elements(objZ);
	return ::gluUnProject (winX, winY, winZ, modelMatrixElement, projectionMatrixElement, viewportElement, objXElement, objYElement, objZElement);
}

jint
GLU::gluUnProject (jdouble winX, jdouble winY, jdouble winZ, jdoubleArray modelMatrix, jdoubleArray projectionMatrix, jintArray viewport, jdoubleArray objCoord)
{
	JvInitClass(&GLU::class$);
	if (modelMatrix == NULL || JvGetArrayLength(modelMatrix) < 16) throw new IllegalArgumentException();
	if (projectionMatrix == NULL || JvGetArrayLength(projectionMatrix) < 16) throw new IllegalArgumentException();
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	if (objCoord == NULL || JvGetArrayLength(objCoord) < 3) throw new IllegalArgumentException();
	const GLdouble* modelMatrixElement = (const GLdouble*)elements(modelMatrix);
	const GLdouble* projectionMatrixElement = (const GLdouble*)elements(projectionMatrix);
	const GLint* viewportElement = (const GLint*)elements(viewport);
	GLdouble* objCoordElement = (GLdouble*)elements(objCoord);
	return ::gluUnProject (winX, winY, winZ, modelMatrixElement, projectionMatrixElement, viewportElement, objCoordElement, objCoordElement+1, objCoordElement+2);
}

jint
GLU::gluUnProject4 (jdouble winX, jdouble winY, jdouble winZ, jdouble clipW, jdoubleArray modelMatrix, jdoubleArray projectionMatrix, jintArray viewport, jdouble near, jdouble far, jdoubleArray objX, jdoubleArray objY, jdoubleArray objZ, jdoubleArray objW)
{
	JvInitClass(&GLU::class$);
	if (modelMatrix == NULL || JvGetArrayLength(modelMatrix) < 16) throw new IllegalArgumentException();
	if (projectionMatrix == NULL || JvGetArrayLength(projectionMatrix) < 16) throw new IllegalArgumentException();
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	if (objX == NULL || JvGetArrayLength(objX) < 1) throw new IllegalArgumentException();
	if (objY == NULL || JvGetArrayLength(objY) < 1) throw new IllegalArgumentException();
	if (objZ == NULL || JvGetArrayLength(objZ) < 1) throw new IllegalArgumentException();
	if (objW == NULL || JvGetArrayLength(objW) < 1) throw new IllegalArgumentException();
	const GLdouble* modelMatrixElement = (const GLdouble*)elements(modelMatrix);
	const GLdouble* projectionMatrixElement = (const GLdouble*)elements(projectionMatrix);
	const GLint* viewportElement = (const GLint*)elements(viewport);
	GLdouble* objXElement = (GLdouble*)elements(objX);
	GLdouble* objYElement = (GLdouble*)elements(objY);
	GLdouble* objZElement = (GLdouble*)elements(objZ);
	GLdouble* objWElement = (GLdouble*)elements(objW);
	return ::gluUnProject4 (winX, winY, winZ, clipW, modelMatrixElement, projectionMatrixElement, viewportElement, near, far, objXElement, objYElement, objZElement, objWElement);
}

jint
GLU::gluUnProject4 (jdouble winX, jdouble winY, jdouble winZ, jdouble clipW, jdoubleArray modelMatrix, jdoubleArray projectionMatrix, jintArray viewport, jdouble near, jdouble far, jdoubleArray objCoord)
{
	JvInitClass(&GLU::class$);
	if (modelMatrix == NULL || JvGetArrayLength(modelMatrix) < 16) throw new IllegalArgumentException();
	if (projectionMatrix == NULL || JvGetArrayLength(projectionMatrix) < 16) throw new IllegalArgumentException();
	if (viewport == NULL || JvGetArrayLength(viewport) < 4) throw new IllegalArgumentException();
	if (objCoord == NULL || JvGetArrayLength(objCoord) < 4) throw new IllegalArgumentException();
	const GLdouble* modelMatrixElement = (const GLdouble*)elements(modelMatrix);
	const GLdouble* projectionMatrixElement = (const GLdouble*)elements(projectionMatrix);
	const GLint* viewportElement = (const GLint*)elements(viewport);
	GLdouble* objCoordElement = (GLdouble*)elements(objCoord);
	return ::gluUnProject4 (winX, winY, winZ, clipW, modelMatrixElement, projectionMatrixElement, viewportElement, near, far, objCoordElement, objCoordElement+1, objCoordElement+2, objCoordElement+3);
}


jint
GLU::gluScaleImage(jint format, jint wIn, jint hIn, jint typeIn, jfloatArray dataIn, jint wOut, jint hOut, jint typeOut, jfloatArray dataOut)
{
	JvInitClass(&GLU::class$);
	if (dataIn == NULL || dataOut == NULL) throw new IllegalArgumentException();
	jfloat* dataInElements = elements(dataIn);
	jfloat* dataOutEelments = elements(dataOut);
	return ::gluScaleImage(format, wIn, hIn, typeIn, dataInElements, wOut, hOut, typeOut, dataOutEelments);
}


jint
GLU::gluScaleImage(jint format, jint wIn, jint hIn, jint typeIn, jbyteArray dataIn, jint wOut, jint hOut, jint typeOut, jbyteArray dataOut)
{
	JvInitClass(&GLU::class$);
	if (dataIn == NULL || dataOut == NULL) throw new IllegalArgumentException();
	jbyte* dataInElements = elements(dataIn);
	jbyte* dataOutEelments = elements(dataOut);
	return ::gluScaleImage(format, wIn, hIn, typeIn, dataInElements, wOut, hOut, typeOut, dataOutEelments);
}


jint
GLU::gluScaleImage(jint format, jint wIn, jint hIn, jint typeIn, jshortArray dataIn, jint wOut, jint hOut, jint typeOut, jshortArray dataOut)
{
	JvInitClass(&GLU::class$);
	if (dataIn == NULL || dataOut == NULL) throw new IllegalArgumentException();
	jshort* dataInElements = elements(dataIn);
	jshort* dataOutEelments = elements(dataOut);
	return ::gluScaleImage(format, wIn, hIn, typeIn, dataInElements, wOut, hOut, typeOut, dataOutEelments);
}


jint
GLU::gluScaleImage(jint format, jint wIn, jint hIn, jint typeIn, jintArray dataIn, jint wOut, jint hOut, jint typeOut, jintArray dataOut)
{
	JvInitClass(&GLU::class$);
	if (dataIn == NULL || dataOut == NULL) throw new IllegalArgumentException();
	jint* dataInElements = elements(dataIn);
	jint* dataOutEelments = elements(dataOut);
	return ::gluScaleImage(format, wIn, hIn, typeIn, dataInElements, wOut, hOut, typeOut, dataOutEelments);
}

