/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package glu4gcj;

public interface GLUConstants
{
	/*************************************************************

	// Extensions 
	int GLU_EXT_object_space_tess          1
	int GLU_EXT_nurbs_tessellator          1

	// Boolean 
	int GLU_FALSE                          0
	int GLU_TRUE                           1

	// Version 
	int GLU_VERSION_1_1                    1
	int GLU_VERSION_1_2                    1
	int GLU_VERSION_1_3                    1

	// StringName 
	int GLU_VERSION                        100800
	int GLU_EXTENSIONS                     100801

	// ErrorCode 
	int GLU_INVALID_ENUM                   100900
	int GLU_INVALID_VALUE                  100901
	int GLU_OUT_OF_MEMORY                  100902
	int GLU_INVALID_OPERATION              100904

	// NurbsDisplay 
	//      GLU_FILL 
	int GLU_OUTLINE_POLYGON                100240
	int GLU_OUTLINE_PATCH                  100241
	************************************************************/

	// NurbsCallback 
	int GLU_NURBS_ERROR                    = 100103;
	int GLU_ERROR                          = 100103;
	int GLU_NURBS_BEGIN                    = 100164;
	int GLU_NURBS_BEGIN_EXT                = 100164;
	int GLU_NURBS_VERTEX                   = 100165;
	int GLU_NURBS_VERTEX_EXT               = 100165;
	int GLU_NURBS_NORMAL                   = 100166;
	int GLU_NURBS_NORMAL_EXT               = 100166;
	int GLU_NURBS_COLOR                    = 100167;
	int GLU_NURBS_COLOR_EXT                = 100167;
	int GLU_NURBS_TEXTURE_COORD            = 100168;
	int GLU_NURBS_TEX_COORD_EXT            = 100168;
	int GLU_NURBS_END                      = 100169;
	int GLU_NURBS_END_EXT                  = 100169;
	int GLU_NURBS_BEGIN_DATA               = 100170;
	int GLU_NURBS_BEGIN_DATA_EXT           = 100170;
	int GLU_NURBS_VERTEX_DATA              = 100171;
	int GLU_NURBS_VERTEX_DATA_EXT          = 100171;
	int GLU_NURBS_NORMAL_DATA              = 100172;
	int GLU_NURBS_NORMAL_DATA_EXT          = 100172;
	int GLU_NURBS_COLOR_DATA               = 100173;
	int GLU_NURBS_COLOR_DATA_EXT           = 100173;
	int GLU_NURBS_TEXTURE_COORD_DATA       = 100174;
	int GLU_NURBS_TEX_COORD_DATA_EXT       = 100174;
	int GLU_NURBS_END_DATA                 = 100175;
	int GLU_NURBS_END_DATA_EXT             = 100175;

	// NurbsError 
	int GLU_NURBS_ERROR1                   = 100251;
	int GLU_NURBS_ERROR2                   = 100252;
	int GLU_NURBS_ERROR3                   = 100253;
	int GLU_NURBS_ERROR4                   = 100254;
	int GLU_NURBS_ERROR5                   = 100255;
	int GLU_NURBS_ERROR6                   = 100256;
	int GLU_NURBS_ERROR7                   = 100257;
	int GLU_NURBS_ERROR8                   = 100258;
	int GLU_NURBS_ERROR9                   = 100259;
	int GLU_NURBS_ERROR10                  = 100260;
	int GLU_NURBS_ERROR11                  = 100261;
	int GLU_NURBS_ERROR12                  = 100262;
	int GLU_NURBS_ERROR13                  = 100263;
	int GLU_NURBS_ERROR14                  = 100264;
	int GLU_NURBS_ERROR15                  = 100265;
	int GLU_NURBS_ERROR16                  = 100266;
	int GLU_NURBS_ERROR17                  = 100267;
	int GLU_NURBS_ERROR18                  = 100268;
	int GLU_NURBS_ERROR19                  = 100269;
	int GLU_NURBS_ERROR20                  = 100270;
	int GLU_NURBS_ERROR21                  = 100271;
	int GLU_NURBS_ERROR22                  = 100272;
	int GLU_NURBS_ERROR23                  = 100273;
	int GLU_NURBS_ERROR24                  = 100274;
	int GLU_NURBS_ERROR25                  = 100275;
	int GLU_NURBS_ERROR26                  = 100276;
	int GLU_NURBS_ERROR27                  = 100277;
	int GLU_NURBS_ERROR28                  = 100278;
	int GLU_NURBS_ERROR29                  = 100279;
	int GLU_NURBS_ERROR30                  = 100280;
	int GLU_NURBS_ERROR31                  = 100281;
	int GLU_NURBS_ERROR32                  = 100282;
	int GLU_NURBS_ERROR33                  = 100283;
	int GLU_NURBS_ERROR34                  = 100284;
	int GLU_NURBS_ERROR35                  = 100285;
	int GLU_NURBS_ERROR36                  = 100286;
	int GLU_NURBS_ERROR37                  = 100287;

	// NurbsProperty 
	int GLU_AUTO_LOAD_MATRIX               = 100200;
	int GLU_CULLING                        = 100201;
	int GLU_SAMPLING_TOLERANCE             = 100203;
	int GLU_DISPLAY_MODE                   = 100204;
	int GLU_PARAMETRIC_TOLERANCE           = 100202;
	int GLU_SAMPLING_METHOD                = 100205;
	int GLU_U_STEP                         = 100206;
	int GLU_V_STEP                         = 100207;
	int GLU_NURBS_MODE                     = 100160;
	int GLU_NURBS_MODE_EXT                 = 100160;
	int GLU_NURBS_TESSELLATOR              = 100161;
	int GLU_NURBS_TESSELLATOR_EXT          = 100161;
	int GLU_NURBS_RENDERER                 = 100162;
	int GLU_NURBS_RENDERER_EXT             = 100162;

	// NurbsSampling 
	int GLU_OBJECT_PARAMETRIC_ERROR        = 100208;
	int GLU_OBJECT_PARAMETRIC_ERROR_EXT    = 100208;
	int GLU_OBJECT_PATH_LENGTH             = 100209;
	int GLU_OBJECT_PATH_LENGTH_EXT         = 100209;
	int GLU_PATH_LENGTH                    = 100215;
	int GLU_PARAMETRIC_ERROR               = 100216;
	int GLU_DOMAIN_DISTANCE                = 100217;

	// NurbsTrim 
	int GLU_MAP1_TRIM_2                    = 100210;
	int GLU_MAP1_TRIM_3                    = 100211;

	// QuadricDrawStyle 
	int GLU_POINT                          = 100010;
	int GLU_LINE                           = 100011;
	int GLU_FILL                           = 100012;
	int GLU_SILHOUETTE                     = 100013;

	// QuadricCallback 
	//      GLU_ERROR 

	// QuadricNormal 
	int GLU_SMOOTH                         = 100000;
	int GLU_FLAT                           = 100001;
	int GLU_NONE                           = 100002;

	// QuadricOrientation 
	int GLU_OUTSIDE                        = 100020;
	int GLU_INSIDE                         = 100021;

	// TessCallback 
	int GLU_TESS_BEGIN                     = 100100;
	int GLU_BEGIN                          = 100100;
	int GLU_TESS_VERTEX                    = 100101;
	int GLU_VERTEX                         = 100101;
	int GLU_TESS_END                       = 100102;
	int GLU_END                            = 100102;
	int GLU_TESS_ERROR                     = 100103;
	int GLU_TESS_EDGE_FLAG                 = 100104;
	int GLU_EDGE_FLAG                      = 100104;
	int GLU_TESS_COMBINE                   = 100105;
	int GLU_TESS_BEGIN_DATA                = 100106;
	int GLU_TESS_VERTEX_DATA               = 100107;
	int GLU_TESS_END_DATA                  = 100108;
	int GLU_TESS_ERROR_DATA                = 100109;
	int GLU_TESS_EDGE_FLAG_DATA            = 100110;
	int GLU_TESS_COMBINE_DATA              = 100111;

	// TessContour 
	int GLU_CW                             = 100120;
	int GLU_CCW                            = 100121;
	int GLU_INTERIOR                       = 100122;
	int GLU_EXTERIOR                       = 100123;
	int GLU_UNKNOWN                        = 100124;

	// TessProperty 
	int GLU_TESS_WINDING_RULE              = 100140;
	int GLU_TESS_BOUNDARY_ONLY             = 100141;
	int GLU_TESS_TOLERANCE                 = 100142;

	// TessError 
	int GLU_TESS_ERROR1                    = 100151;
	int GLU_TESS_ERROR2                    = 100152;
	int GLU_TESS_ERROR3                    = 100153;
	int GLU_TESS_ERROR4                    = 100154;
	int GLU_TESS_ERROR5                    = 100155;
	int GLU_TESS_ERROR6                    = 100156;
	int GLU_TESS_ERROR7                    = 100157;
	int GLU_TESS_ERROR8                    = 100158;
	int GLU_TESS_MISSING_BEGIN_POLYGON     = 100151;
	int GLU_TESS_MISSING_BEGIN_CONTOUR     = 100152;
	int GLU_TESS_MISSING_END_POLYGON       = 100153;
	int GLU_TESS_MISSING_END_CONTOUR       = 100154;
	int GLU_TESS_COORD_TOO_LARGE           = 100155;
	int GLU_TESS_NEED_COMBINE_CALLBACK     = 100156;

	// TessWinding 
	int GLU_TESS_WINDING_ODD               = 100130;
	int GLU_TESS_WINDING_NONZERO           = 100131;
	int GLU_TESS_WINDING_POSITIVE          = 100132;
	int GLU_TESS_WINDING_NEGATIVE          = 100133;
	int GLU_TESS_WINDING_ABS_GEQ_TWO       = 100134;

	/************************************************************
	int GLU_TESS_MAX_COORD 1.0e150
	************************************************************/
}
