/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/
package glu4gcj;

public class GLU
{
	public static native int gluBuild1DMipmapLevels (int target, int internalFormat, int width, int format, int type, int level, int base, int max, float[] data);
	public static native int gluBuild1DMipmapLevels (int target, int internalFormat, int width, int format, int type, int level, int base, int max, byte[] data);
	public static native int gluBuild1DMipmapLevels (int target, int internalFormat, int width, int format, int type, int level, int base, int max, short[] data);
	public static native int gluBuild1DMipmapLevels (int target, int internalFormat, int width, int format, int type, int level, int base, int max, int[] data);

	public static native int gluBuild1DMipmaps (int target, int internalFormat, int width, int format, int type, float[] data);
	public static native int gluBuild1DMipmaps (int target, int internalFormat, int width, int format, int type, byte[] data);
	public static native int gluBuild1DMipmaps (int target, int internalFormat, int width, int format, int type, short[] data);
	public static native int gluBuild1DMipmaps (int target, int internalFormat, int width, int format, int type, int[] data);

	public static native int gluBuild2DMipmapLevels (int target, int internalFormat, int width, int height, int format, int type, int level, int base, int max, float[] data);
	public static native int gluBuild2DMipmapLevels (int target, int internalFormat, int width, int height, int format, int type, int level, int base, int max, byte[] data);
	public static native int gluBuild2DMipmapLevels (int target, int internalFormat, int width, int height, int format, int type, int level, int base, int max, short[] data);
	public static native int gluBuild2DMipmapLevels (int target, int internalFormat, int width, int height, int format, int type, int level, int base, int max, int[] data);

	public static native int gluBuild2DMipmaps (int target, int internalFormat, int width, int height, int format, int type, float[] data);
	public static native int gluBuild2DMipmaps (int target, int internalFormat, int width, int height, int format, int type, byte[] data);
	public static native int gluBuild2DMipmaps (int target, int internalFormat, int width, int height, int format, int type, short[] data);
	public static native int gluBuild2DMipmaps (int target, int internalFormat, int width, int height, int format, int type, int[] data);

	public static native int gluBuild3DMipmapLevels (int target, int internalFormat, int width, int height, int depth, int format, int type, int level, int base, int max, float[] data);
	public static native int gluBuild3DMipmapLevels (int target, int internalFormat, int width, int height, int depth, int format, int type, int level, int base, int max, byte[] data);
	public static native int gluBuild3DMipmapLevels (int target, int internalFormat, int width, int height, int depth, int format, int type, int level, int base, int max, short[] data);
	public static native int gluBuild3DMipmapLevels (int target, int internalFormat, int width, int height, int depth, int format, int type, int level, int base, int max, int[] data);

	public static native int gluBuild3DMipmaps (int target, int internalFormat, int width, int height, int depth, int format, int type, float[] data);
	public static native int gluBuild3DMipmaps (int target, int internalFormat, int width, int height, int depth, int format, int type, byte[] data);
	public static native int gluBuild3DMipmaps (int target, int internalFormat, int width, int height, int depth, int format, int type, short[] data);
	public static native int gluBuild3DMipmaps (int target, int internalFormat, int width, int height, int depth, int format, int type, int[] data);

	//public static native GLboolean gluCheckExtension (const GLubyte *extName, const GLubyte *extString);

	public static native String gluErrorString (int error);
	public static native String gluGetString (int name);
	public static native void gluLookAt (double eyeX, double eyeY, double eyeZ, double centerX, double centerY, double centerZ, double upX, double upY, double upZ);
	public static native void gluOrtho2D (double left, double right, double bottom, double top);
	public static native void gluPerspective (double fovy, double aspect, double zNear, double zFar);

	public static native void gluPickMatrix (double x, double y, double delX, double delY, int[] viewport);

	public static native int gluProject (double objX, double objY, double objZ, double[] modelMatrix, double[] projectionMatrix, int[] viewport, double[] winX, double[] winY, double[] winZ);
	public static native int gluProject (double objX, double objY, double objZ, double[] modelMatrix, double[] projectionMatrix, int[] viewport, double[] winCorrd);

	public static native int gluUnProject (double winX, double winY, double winZ, double[] modelMatrix, double[] projectionMatrix, int[] viewport, double[] objX, double[] objY, double[] objZ);
	public static native int gluUnProject (double winX, double winY, double winZ, double[] modelMatrix, double[] projectionMatrix, int[] viewport, double[] objCoord);

	public static native int gluUnProject4 (double winX, double winY, double winZ, double clipW, double[] modelMatrix, double[] projectionMatrix, int[] viewport, double near, double far, double[] objX, double[] objY, double[] objZ, double[] objW);
	public static native int gluUnProject4 (double winX, double winY, double winZ, double clipW, double[] modelMatrix, double[] projectionMatrix, int[] viewport, double near, double far, double[] objCoord);

	public static native int gluScaleImage (int format, int wIn, int hIn, int typeIn, float[] dataIn, int wOut, int hOut, int typeOut, float[] dataOut);
	public static native int gluScaleImage (int format, int wIn, int hIn, int typeIn, byte[] dataIn, int wOut, int hOut, int typeOut, byte[] dataOut);
	public static native int gluScaleImage (int format, int wIn, int hIn, int typeIn, short[] dataIn, int wOut, int hOut, int typeOut, short[] dataOut);
	public static native int gluScaleImage (int format, int wIn, int hIn, int typeIn, int[] dataIn, int wOut, int hOut, int typeOut, int[] dataOut);

	// Quadric
	public static Quadric gluNewQuadric ()
	{
		return new Quadric();
	}

	public static void gluQuadricDrawStyle (Quadric quad, int draw)
	{
		quad.setDrawStyle(draw);
	}

	public static void gluQuadricNormals (Quadric quad, int normal)
	{
		quad.setNormals(normal);
	}

	public static void gluQuadricOrientation (Quadric quad, int orientation)
	{
		quad.setOrientation(orientation);
	}

	public static void gluQuadricTexture (Quadric quad, boolean texture)
	{
		quad.setTexture(texture);
	}

	public static void gluCylinder (Quadric quad, double base, double top, double height, int slices, int stacks)
	{
		quad.cylinder(base, top, height, slices, stacks);
	}

	public static void gluDeleteQuadric (Quadric quad)
	{
		quad.deleteQuadric();
	}

	public static void gluDisk (Quadric quad, double inner, double outer, int slices, int loops)
	{
		quad.disk(inner, outer, slices, loops);
	}

	public static void gluPartialDisk (Quadric quad, double inner, double outer, int slices, int loops, double start, double sweep)
	{
		quad.partialDisk(inner, outer, slices, loops, start, sweep);
	}

	public static void gluSphere (Quadric quad, double radius, int slices, int stacks)
	{
		quad.sphere(radius, slices, stacks);
	}

	// Tesselator
	public static Tesselator gluNewTess ()
	{
		return new Tesselator();
	}

	public static void gluDeleteTess (Tesselator tess)
	{
		tess.deleteTess();
	}

	public static void gluTessCallback (Tesselator tess, TesselatorListener callback)
	{
		tess.setCallback(callback);
	}

	public static void gluBeginPolygon (Tesselator tess)
	{
		tess.beginPolygon();
	}

	public static void gluEndPolygon (Tesselator tess)
	{
		tess.endPolygon();
	}

	public static void gluTessBeginPolygon (Tesselator tess)
	{
		tess.beginPolygon();
	}

	public static void gluTessBeginPolygon (Tesselator tess, Object polygonObject)
	{
		tess.beginPolygon(polygonObject);
	}

	public static void gluTessEndPolygon (Tesselator tess)
	{
		tess.endPolygon();
	}

	public static void gluNextContour (Tesselator tess, int type)
	{
		tess.nextContour(type);
	}

	public static void gluTessBeginContour (Tesselator tess)
	{
		tess.beginContour();
	}

	public static void gluTessEndContour (Tesselator tess)
	{
		tess.endContour();
	}

	public static void gluTessNormal (Tesselator tess, double valueX, double valueY, double valueZ)
	{
		tess.normal(valueX, valueY, valueZ);
	}

	public static void gluTessVertex (Tesselator tess, double[] location, Object vertexObject)
	{
		tess.vertex(location, vertexObject);
	}

	public static void gluTessProperty (Tesselator tess, int which, double data)
	{
		tess.setProperty(which, data);
	}

	public static double gluGetTessProperty (Tesselator tess, int which)
	{
		return tess.getProperty(which);
	}

	// Nurbs
	public static Nurbs gluNewNurbsRenderer ()
	{
		return new Nurbs();
	}
	public static void gluDeleteNurbsRenderer (Nurbs nurbs)
	{
		nurbs.deleteNurbsRenderer();
	}

	public static void gluBeginCurve (Nurbs nurbs)
	{
		nurbs.beginCurve();
	}

	public static void gluPwlCurve(Nurbs nurbs, int count, float[] data, int stride, int type)
	{
		nurbs.pwlCurve(count, data, stride, type);
	}

	public static void gluNurbsCurve (Nurbs nurbs, int knotCount, float[] knotsArray, int stride, float[] controlArray, int order, int type)
	{
		nurbs.nurbsCurve (knotCount, knotsArray, stride, controlArray, order, type);
	}

	public static void gluEndCurve (Nurbs nurbs)
	{
		nurbs.endCurve();
	}

	public static void gluBeginSurface (Nurbs nurbs)
	{
		nurbs.beginSurface();
	}

	public static void gluNurbsSurface (Nurbs nurbs,int sKnotCount, float[] sKnots, int tKnotCount, float[] tKnots, int sStride, int tStride, float[] control, int sOrder, int tOrder, int type)
	{
		nurbs.nurbsSurface(sKnotCount, sKnots, tKnotCount, tKnots, sStride, tStride, control, sOrder, tOrder, type);
	}

	public static void gluEndSurface (Nurbs nurbs)
	{
		nurbs.endSurface();
	}

	public static void gluBeginTrim (Nurbs nurbs)
	{
		nurbs.beginTrim();
	}

	public static void gluEndTrim (Nurbs nurbs)
	{
		nurbs.endTrim();
	}

	public static float gluGetNurbsProperty (Nurbs nurbs, int property)
	{
		return nurbs.getNurbsProperty(property);
	}

	public static void gluNurbsProperty (Nurbs nurbs, int property, float value)
	{
		nurbs.setNurbsProperty(property, value);
	}

	public static void gluLoadSamplingMatrices(Nurbs nurbs, float[] modelviewMatrix, float[] projectionMatrix, int[] viewport)
	{
		nurbs.loadSamplingMatrices(modelviewMatrix, projectionMatrix, viewport);
	}

	public static void gluNurbsCallback (Nurbs nurbs, NurbsListener listener)
	{
		nurbs.setCallback(listener);
	}

	public static void gluNurbsCallbackData (Nurbs nurbs, Object callbackData)
	{
		nurbs.setCallbackData(callbackData);
	}
}

