
import gl4gcj.*;
import glut4gcj.*;
import java.util.Random;

class LineArt extends GL
{
	private double x1, y1, x2, y2;
	private double dx1, dy1, dx2, dy2;
	private Line[] lines = null;
	private int index = 0;

	public LineArt(int number)
	{
		lines = new Line[number];
		Random random = new Random();
		x1 = random.nextDouble();
		y1 = random.nextDouble();
		x2 = random.nextDouble();
		y2 = random.nextDouble();

		dx1 =  (random.nextDouble() + 0.5) / 50.0;
		dy1 =  (random.nextDouble() + 0.5) / 50.0;
		dx2 = -(random.nextDouble() + 0.5) / 50.0;
		dy2 = -(random.nextDouble() + 0.5) / 50.0;

		for (int i = lines.length-1;i >= 0;i--) lines[i] = new Line();
	}

	public void update()
	{
		x1 += dx1;
		if ((x1 < 0.0) || (x1 > 1.0)) dx1 = -dx1;
		y1 += dy1;
		if ((y1 < 0.0) || (y1 > 1.0)) dy1 = -dy1;

		x2 += dx2;
		if ((x2 < 0.0) || (x2 > 1.0)) dx2 = -dx2;
		y2 += dy2;
		if ((y2 < 0.0) || (y2 > 1.0)) dy2 = -dy2;

		lines[index].setPoint1(x1, y1);
		lines[index].setPoint2(x2, y2);
		lines[index].setColor1(x1, y1, x2);
		lines[index].setColor2(x2, y2, x1);
		index++;
		if (index >= lines.length) index = 0;
	}

	public void draw()
	{
		for (int i = lines.length-1;i >= 0;i--) lines[i].draw();
	}
	
	class Line
	{
		private double x1, y1;
		private double x2, y2;
		private double r1, g1, b1;
		private double r2, g2, b2;

		public Line()
		{
			this.setColor1(1.0, 1.0, 1.0);
			this.setColor2(1.0, 1.0, 1.0);
			this.setPoint1(0.0, 0.0);
			this.setPoint2(0.0, 0.0);
		}

		public void setColor1(double r, double g, double b)
		{
			this.r1 = r;
			this.g1 = g;
			this.b1 = b;
		}

		public void setColor2(double r, double g, double b)
		{
			this.r2 = r;
			this.g2 = g;
			this.b2 = b;
		}

		public void setPoint1(double x1, double y1)
		{
			this.x1 = x1;
			this.y1 = y1;
		}

		public void setPoint2(double x2, double y2)
		{
			this.x2 = x2;
			this.y2 = y2;
		}

		public void draw()
		{
			glBegin(GL_LINES);
			glColor3d(r1, g1, b1);
			glVertex2d(x1, y1);
			glColor3d(r2, g2, b2);
			glVertex2d(x2, y2);
			glEnd();
		}
	}
}

public class TimerTest extends GLUT
	implements DisplayFunc, ReshapeFunc, KeyboardFunc, TimerFunc
{
	private static final int MAX_LINES = 40;
	private static final int TIMER_INTERVAL = 30; 

	private LineArt lineArt = new LineArt(MAX_LINES);

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);
		lineArt.draw();
		glutSwapBuffers();
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q' || key == '') System.exit(0);
	}

	public void timer(int value)
	{
		lineArt.update();
		glutPostRedisplay();
		glutTimerFunc(TIMER_INTERVAL, this);
	}

	public void reshape(int width, int height)
	{
		glViewport(0, 0, width, height);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(0.0, 1.0, 0.0, 1.0, -1.0, 1.0);
	}

	public static void main(String[] args)
	{
		glutInit(args);
		glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
		glutInitWindowSize(500, 500);
		glutCreateWindow("Timer Test");

		TimerTest test = new TimerTest();
		glutDisplayFunc(test);
		glutKeyboardFunc(test);
		glutReshapeFunc(test);
		glutTimerFunc(TIMER_INTERVAL, test);

		glClearColor(0, 0, 0, 0);

		glutMainLoop();
	}
}

