import gl4gcj.*;
import glut4gcj.*;
import java.util.Random;

class Sprite extends GL
{
	private static final int MAX_SPEED = 1;
	private static final int SIZE = 32;
	private static final Random random = new Random();

	private int movableW, movableH;

	private int x, y, hw, hh, dx = 0, dy = 0;
	private int texture;

	Sprite(int texture, int screenW, int screenH)
	{
		this.texture = texture;

		// init size
		this.hw = SIZE/2;
		this.hh = SIZE/2;
		this.movableW = screenW - SIZE;
		this.movableH = screenH - SIZE;

		// init location
		this.x = random.nextInt(movableW);
		this.y = random.nextInt(movableH);

		// init speed
		while(dx == 0 && dy == 0)
		{
			dx = random.nextInt(MAX_SPEED * 2 + 1) - MAX_SPEED;
			dy = random.nextInt(MAX_SPEED * 2 + 1) - MAX_SPEED;
		}
	}

	public final void move()
	{
		x += dx;
		if((x < 0) || (x >= movableW))
		{
			dx = -dx;
			x += dx;
		}

		y += dy;
		if((y < 0) || (y >= movableH))
		{
			dy = -dy;
			y += dy;
		}

	}

	public final void draw()
	{
		glLoadIdentity();
		glTranslated(x + hw, y + hh, 0);

		glBindTexture(GL_TEXTURE_2D, this.texture);
		glBegin(GL_POLYGON);
		glTexCoord2i(0,  0);
		glVertex2i(-hw, -hh);
		glTexCoord2i(1,  0);
		glVertex2i( hw, -hh);
		glTexCoord2i(1,  1);
		glVertex2i( hw,  hh);
		glTexCoord2i(0,  1);
		glVertex2i(-hw,  hh);
		glEnd();
	}
}

public class TestSpriteGL extends GLUT 
	implements DisplayFunc, IdleFunc, KeyboardFunc, ReshapeFunc, TimerFunc
{
	private static final int DEFAULT_NUMBER_OF_SPRITE = 100;
	private static final int INTERVAL_TIME = 1000;
	private static final int SCREEN_WIDTH = 640;
	private static final int SCREEN_HEIGHT = 480;

	private Sprite[] sprites;
	private int frames = 0;
	private StringBuffer buffer = new StringBuffer();

	public TestSpriteGL(int numberOfSprite)
	{
		glClearColor(0.0, 0.0, 0.0, 0.0);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		glEnable(GL_TEXTURE_2D);
		int texture = glGenTexture();
		glBindTexture(GL_TEXTURE_2D, texture);
		glTexImage2D(GL_TEXTURE_2D, 0,
			Icon.FORMAT, Icon.WIDTH, Icon.HEIGHT, 0,
			Icon.FORMAT, Icon.TYPE, Icon.PIXELS);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

		glMatrixMode(GL_MODELVIEW);

		this.sprites = new Sprite[numberOfSprite];
		for (int i = this.sprites.length-1;i >= 0;i--)
			this.sprites[i] = new Sprite(texture, SCREEN_WIDTH, SCREEN_HEIGHT);
	}

	public void reshape(int width, int height)
	{
		glViewport(0, 0, width, height);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(0.0, SCREEN_WIDTH, 0.0, SCREEN_HEIGHT, -1.0, 1.0);
		glMatrixMode(GL_MODELVIEW);
	}

	void drawSprites()
	{
		for (int i = sprites.length-1;i >= 0 ;i--)
		{
			this.sprites[i].draw();
		}
	}

	void drawMessage()
	{
		glPushAttrib(GL_ENABLE_BIT);
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
			glLoadIdentity();
			glRasterPos2i(0, 0);
			glBitmap(0, 0, 0, 0, 10, 10, null);
			glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24, buffer);
		glPopAttrib();
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		drawSprites();
		drawMessage();

		glutSwapBuffers();
	}

	public void idle()
	{
		for (int i = sprites.length-1;i >= 0 ;i--)
		{
			this.sprites[i].move();
		}
		this.frames++;
		glutPostRedisplay();
	}

	public void timer(int value)
	{
		double fps = (this.frames * 1000.0)/ INTERVAL_TIME;
		this.frames = 0;

		this.buffer.delete(0, this.buffer.length());
		this.buffer.append(fps);
		this.buffer.append("(fps)");
		/*
		this.buffer.append(" Mem : ");
		this.buffer.append(Runtime.getRuntime().freeMemory());
		this.buffer.append("/");
		this.buffer.append(Runtime.getRuntime().totalMemory());
		*/
		
		glutTimerFunc(INTERVAL_TIME, this);
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q')
		{
			System.exit(0);
		}
		else if (key == 'g' || key == 'G')
		{
			System.out.println("GC");
			System.gc();
		}
	}

	public static void main(String[] args)
	{
		try
		{
			args = glutInit(args);
			glutInitWindowSize(SCREEN_WIDTH, SCREEN_HEIGHT);
			glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
			glutCreateWindow("TestSpriteGL");

			int numberOfSprite = DEFAULT_NUMBER_OF_SPRITE;
			if (args.length > 0)
			{
				try
				{
					numberOfSprite = Integer.parseInt(args[0]);
				}
				catch (NumberFormatException e) { }
			}

			TestSpriteGL testSprite = new TestSpriteGL(numberOfSprite);
			glutDisplayFunc(testSprite);
			glutReshapeFunc(testSprite);
			glutKeyboardFunc(testSprite);
			glutIdleFunc(testSprite);
			glutTimerFunc(INTERVAL_TIME, testSprite);

			System.gc();
			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
