import gl4gcj.*;
import glu4gcj.*;
import glut4gcj.*;

public class NurbsTest extends GLUT implements
	DisplayFunc, ReshapeFunc, GLUConstants
{
	static final float[] CONTROL = new float[4*4*3];
	static final float[] KNOTS = new float[]{
		0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f,
	};

	static final float[] MAT_DIFFUSE = new float[]{
		0.7f, 0.7f, 0.7f, 1.0f, };
	static final float[] MAT_SPECULAR = new float[]{
		1.0f, 1.0f, 1.0f, 1.0f, };
	static final float[] MAT_SHININESS = new float[]{
		100.0f };

	static final float[] LIGHT_AMBIENT = new float[]{
		0.8f, 0.8f, 0.8f, 1.0f, };
	static final float[] LIGHT_DIFFUSE = new float[]{
		1.0f, 1.0f, 1.0f, 1.0f, };
	static final float[] LIGHT_POSITION = new float[]{
		0.0f, 1.0f,-2.0f, 0.0f };

	static
	{
		for (int u = 0;u < 4;u++)
		{
			for (int v = 0; v < 4;v++)
			{
				CONTROL[u*12+v*3] = 2.0f * u - 1.5f;
				CONTROL[u*12+v*3+1] = 2.0f * v - 1.5f;
				if ((u == 1 || u == 2) && (v == 1 || v == 2))
					CONTROL[u*12+v*3+2] = 3.0f;
				else
					CONTROL[u*12+v*3+2] = 3.0f;
			}
		}
	}

	public NurbsTest()
	{
		glClearColor(0.0, 0.0, 0.0, 1.0);
		glClearDepth(1.0);
		glShadeModel(GL_SMOOTH);

		glLightfv(GL_LIGHT0, GL_AMBIENT, LIGHT_AMBIENT);
		glLightfv(GL_LIGHT0, GL_DIFFUSE, LIGHT_DIFFUSE);
		glLightfv(GL_LIGHT0, GL_POSITION, LIGHT_POSITION);
		glEnable(GL_LIGHT0);

		glMaterialfv(GL_FRONT, GL_DIFFUSE, MAT_DIFFUSE);
		glMaterialfv(GL_FRONT, GL_SPECULAR, MAT_SPECULAR);
		glMaterialfv(GL_FRONT, GL_SHININESS, MAT_SHININESS);

		glDepthFunc(GL_LESS);
		glEnable(GL_DEPTH_TEST);
		glEnable(GL_AUTO_NORMAL);
		glEnable(GL_NORMALIZE);
		glEnable(GL_LIGHTING);
		this.initDisplayList();
	}

	public void initDisplayList()
	{
		this.displayList = glGenLists(1);

		Nurbs nurbs = new Nurbs();
		nurbs.setNurbsProperty(GLU_SAMPLING_TOLERANCE, 25.0f);
		nurbs.setNurbsProperty(GLU_DISPLAY_MODE, GLU_FILL);

		glNewList(this.displayList, GL_COMPILE);
			nurbs.beginSurface();
				nurbs.nurbsSurface(8, KNOTS, 8, KNOTS,
					4*3, 3, CONTROL, 4, 4, GL_MAP2_VERTEX_3);
			nurbs.endSurface();
//			glutSolidTeapot(1.0);
		glEndList();

		nurbs.deleteNurbsRenderer();
		nurbs = null;
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslated(0.0, 0.0, -15.0);
		glCallList(this.displayList);

		glutSwapBuffers();
	}

	public void reshape(int w, int h)
	{
		glViewport(0, 0, w, h);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		GLU.gluPerspective(45.0, (double)w/h, 0.1, 20.0);
		glMatrixMode(GL_MODELVIEW);
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
			glutInitWindowSize(400, 400);
			glutCreateWindow("NurbsTest");

			NurbsTest test = new NurbsTest();
			glutDisplayFunc(test);
			glutReshapeFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	private int displayList;
}
