/************************************************************
class GLUnurbs;
typedef struct GLUnurbs GLUnurbs;
typedef struct GLUnurbs GLUnurbsObj;

//extern GLUnurbs* gluNewNurbsRenderer (void);
//extern void gluDeleteNurbsRenderer (GLUnurbs* nurb);

//extern void gluBeginCurve (GLUnurbs* nurb);
//extern void gluPwlCurve (GLUnurbs* nurb, GLint count, GLfloat* data, GLint stride, GLenum type);
//extern void gluNurbsCurve (GLUnurbs* nurb, GLint knotCount, GLfloat *knots, GLint stride, GLfloat *control, GLint order, GLenum type);
//extern void gluEndCurve (GLUnurbs* nurb);

//extern void gluBeginSurface (GLUnurbs* nurb);
//extern void gluNurbsSurface (GLUnurbs* nurb, GLint sKnotCount, GLfloat* sKnots, GLint tKnotCount, GLfloat* tKnots, GLint sStride, GLint tStride, GLfloat* control, GLint sOrder, GLint tOrder, GLenum type);
//extern void gluEndSurface (GLUnurbs* nurb);

//extern void gluBeginTrim (GLUnurbs* nurb);
//extern void gluEndTrim (GLUnurbs* nurb);

//extern void gluGetNurbsProperty (GLUnurbs* nurb, GLenum property, GLfloat* data);
//extern void gluNurbsProperty (GLUnurbs* nurb, GLenum property, GLfloat value);

extern void gluLoadSamplingMatrices (GLUnurbs* nurb, const GLfloat *model, const GLfloat *perspective, const GLint *view);
//extern void gluNurbsCallback (GLUnurbs* nurb, GLenum which, _GLUfuncptr CallBackFunc);
//extern void gluNurbsCallbackData (GLUnurbs* nurb, GLvoid* userData);
//extern void gluNurbsCallbackDataEXT (GLUnurbs* nurb, GLvoid* userData);
************************************************************/

package glu4gcj;
import gnu.gcj.RawData;

public class Nurbs
{
	// constructors
	public Nurbs()
	{
		this.initImplementation();
	}

	// instance methods

	public native void beginCurve();
	public native void endCurve();
	public native void pwlCurve(int count, float[] data, int stride, int type);
	public native void nurbsCurve(int knotCount, float[] knotsArray, int stride, float[] controlArray, int order, int type);

	public native void beginSurface();
	public native void endSurface();
	public native void nurbsSurface(int sKnotCount, float[] sKnots, int tKnotCount, float[] tKnots, int sStride, int tStride, float[] control, int sOrder, int tOrder, int type);

	public native void beginTrim();
	public native void endTrim();

	public native float getNurbsProperty(int property);
	public native void setNurbsProperty(int property, float value);

	public native void loadSamplingMatrices(float[] modelviewMatrix, float[] projectionMatrix, int[] viewport);

	public NurbsListener getCallback () { return this.callback; }
	public native void setCallback (NurbsListener callback);

	public Object getCallbackData() { return callbackData; }
	public void setCallbackData(Object callbackData) { this.callbackData = callbackData; }

	public native void deleteNurbsRenderer();

	protected void finalize()
	{
		this.deleteNurbsRenderer();
	}
	
	private native void initImplementation ();

	// instance variables
	private RawData implementation;
	private NurbsListener callback;
	private Object callbackData;
}
