import gl4gcj.*;
import glu4gcj.*;
import glut4gcj.*;

class Vertex
{
	public double[] location = new double[3];
	public double[] color = new double[3];
	public Vertex()
	{
		this.location = new double[3];
		this.color = new double[3];
	}
	public Vertex(double[] location, double[] color)
	{
		this.location = location;
		this.color = color;
	}
}

public class TesselatorTest extends GLUT implements
	DisplayFunc, KeyboardFunc, SpecialFunc, MotionFunc, MouseFunc,
	GLUConstants
{
	/* exterior */
	static final Vertex v1 = new Vertex( new double[]{ -0.6, -0.6, 0.0}, new double[]{ 0.0,  0.0, 1.0});
	static final Vertex v2 = new Vertex( new double[]{ +0.6, -0.6, 0.0}, new double[]{ 0.0,  0.0, 1.0});
	static final Vertex v3 = new Vertex( new double[]{ +0.6, +0.6, 0.0}, new double[]{ 0.0,  1.0, 0.0});
	static final Vertex v4 = new Vertex( new double[]{ -0.6, +0.6, 0.0}, new double[]{ 1.0,  0.0, 0.0});

	/* interior */
	static final Vertex v5 = new Vertex( new double[]{ -0.4, -0.2, 0.0}, new double[]{ 0.2,  0.0, 1.0});
	static final Vertex v6 = new Vertex( new double[]{  0.4, -0.2, 0.0}, new double[]{ 0.0,  0.2, 1.0});
	static final Vertex v7 = new Vertex( new double[]{  0.0,  0.8, 0.0}, new double[]{ 0.0,  0.0, 1.0});

	private int displayList;
	private double scale = 0.5;
	private double yAngle = 0.0;
	private double xAngle = 0.0;

	public TesselatorTest()
	{
		this.initDisplayList();
	}

	public void initDisplayList()
	{
		this.displayList = glGenLists(1);

		Tesselator tess = new Tesselator();
		tess.setCallback(new TesselatorAdapter(){
			public void tessBegin(int type, Object polygonObject)
			{
				System.out.println("callback tessBegin(" + type + ")");
				glBegin(type);
			}

			public void tessEnd(Object polygonObject)
			{
				System.out.println("callback tessEnd()");
				glEnd();
			}

			public void tessVertex(Object vertexObject, Object polygonObject)
			{
				Vertex vertex = (Vertex)vertexObject;
				double[] location = vertex.location;
				double[] color = vertex.color;
				System.out.println("callback tessVertex() : location = (" + location[0] + "," + location[1] + "," + location[2] + ")" );
				glColor3dv(color);
				glVertex3dv(location);
			}

			public Object tessCombine(double[] location, Object[] data, float[] weights, Object polygonObject)
			{
				Vertex vertex = new Vertex();
				vertex.location = location;
				System.out.println("callback tessCombine() : location = (" + location[0] + "," + location[1] + "," + location[2] + ")" );
				vertex.color[0] = weights[0] * ((Vertex)data[0]).color[0] +
					weights[1] * ((Vertex)data[1]).color[0] +
					weights[2] * ((Vertex)data[2]).color[0] +
					weights[3] * ((Vertex)data[3]).color[0];
				vertex.color[1] = weights[0] * ((Vertex)data[0]).color[1] +
					weights[1] * ((Vertex)data[1]).color[1] +
					weights[2] * ((Vertex)data[2]).color[1] +
					weights[3] * ((Vertex)data[3]).color[1];
				vertex.color[2] = weights[0] * ((Vertex)data[0]).color[2] +
					weights[1] * ((Vertex)data[1]).color[2] +
					weights[2] * ((Vertex)data[2]).color[2] +
					weights[3] * ((Vertex)data[3]).color[2];
				return vertex;
			}
		});

		glPolygonMode(GL_FRONT_AND_BACK,  GL_FILL);
		glNewList(this.displayList, GL_COMPILE);
			tess.beginPolygon();
				tess.beginContour();
					tess.vertex(v1.location, v1);
					tess.vertex(v2.location, v2);
					tess.vertex(v3.location, v3);
					tess.vertex(v4.location, v4);
				tess.endContour();
				tess.nextContour(GLU_INTERIOR);
				tess.beginContour();
					tess.vertex(v5.location, v5);
					tess.vertex(v6.location, v6);
					tess.vertex(v7.location, v7);
				tess.endContour();
			tess.endPolygon();
		glEndList();

		tess.deleteTess();
		tess = null;
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		glMatrixMode(GL_MODELVIEW);

		glLoadIdentity();
		glTranslated(-0.5, -0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		glCallList(this.displayList);

		glLoadIdentity();
		glTranslated( 0.5, -0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		glCallList(this.displayList);

		glLoadIdentity();
		glTranslated( 0.5,  0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		glCallList(this.displayList);

		glLoadIdentity();
		glTranslated(-0.5,  0.5, 0.0);
		glRotated(xAngle, 1.0, 0.0, 0.0);
		glRotated(yAngle, 0.0, 1.0, 0.0);
		glScaled(scale, scale, scale);
		glCallList(this.displayList);

		glutSwapBuffers();
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q' || key == '') System.exit(0);
	}

	public void special(int key, int x, int y)
	{
		if (key == GLUT_KEY_PAGE_UP)
		{
			scale = scale * 11.0 / 10.0;
		}
		else if (key == GLUT_KEY_PAGE_DOWN)
		{
			scale = scale * 10.0 / 11.0;
		}
		else if (key == GLUT_KEY_UP)
		{
			xAngle = (xAngle + 5.0 ) % 360;
		}
		else if (key == GLUT_KEY_DOWN)
		{
			xAngle = (xAngle - 5.0 ) % 360;
		}
		else if (key == GLUT_KEY_RIGHT)
		{
			yAngle = (yAngle + 5.0 ) % 360;
		}
		else if (key == GLUT_KEY_LEFT)
		{
			yAngle = (yAngle - 5.0 ) % 360;
		}
		glutPostRedisplay();
	}

	private int mouse_x, mouse_y;

	public void mouse(int button, int state, int x, int y)
	{
		if (state == GLUT_DOWN)
		{
			this.mouse_x = x;
			this.mouse_y = y;
		}
	}

	public void motion(int x, int y)
	{
		int diff_x = this.mouse_x - x;
		yAngle = (yAngle + x - this.mouse_x) % 360;
		xAngle = (xAngle + y - this.mouse_y) % 360;
		this.mouse_x = x;
		this.mouse_y = y;
		glutPostRedisplay();
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
			glutInitWindowSize(400, 400);
			glutCreateWindow("TesselatorTest");

			TesselatorTest test = new TesselatorTest();
			glutDisplayFunc(test);
			glutMouseFunc(test);
			glutMotionFunc(test);
			glutKeyboardFunc(test);
			glutSpecialFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
