import glut4gcj.*;

public class StrokeString extends GLUT 
	implements DisplayFunc, ReshapeFunc
{
	static final double SIZE = 400.0;

	private void drawAxis()
	{
		glPushAttrib(GL_CURRENT_BIT);

		glColor3d(0.5, 0.5, 0.5);

		glBegin(GL_LINES);
		glVertex2d(-SIZE, 0.0);
		glVertex2d( SIZE, 0.0);
		glVertex2d(0.0, -SIZE);
		glVertex2d(0.0,  SIZE);
		glEnd();

		glPopAttrib();
	}

	private void drawText()
	{
		glPushAttrib(GL_ENABLE_BIT|GL_LINE_BIT);
		glColor3d(0.0, 1.0, 1.0);

		glEnable(GL_LINE_SMOOTH);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		glLineWidth(2.0f);

		glPushMatrix();
		glLoadIdentity();

		glTranslated(0.0, 0.0, 0.0);
		glutStrokeCharacter(GLUT_STROKE_ROMAN, "Hello");
//		glutStrokeCharacter(GLUT_STROKE_MONO_ROMAN, "Hello");

		glPopMatrix();
		glPopAttrib();
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);
		drawAxis();
		drawText();
		glFlush();
	}

	public void reshape(int w, int h)
	{
		glViewport(0, 0, w, h);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(-SIZE, SIZE, -SIZE, SIZE, -1.0, 1.0);
		glMatrixMode(GL_MODELVIEW);
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutCreateWindow("glutStrokeCharacter() Test");

			StrokeString test = new StrokeString();
			glutDisplayFunc(test);
			glutReshapeFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
