/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/

package glu4gcj;
import gnu.gcj.RawData;

public class Tesselator
{
	// constructors
	public Tesselator()
	{
		this.initImplementation();
	}

	// instance methods
	public native void nextContour (int type);

	public TesselatorListener getCallback () { return this.callback; }
	public native void setCallback (TesselatorListener callback);

	public native void beginContour ();
	public native void endContour ();
	public native void beginPolygon (Object polygonData);
	public void beginPolygon () { this.beginPolygon(null); }
	public native void endPolygon ();
	public native void normal (double valueX, double valueY, double valueZ);

	public native void vertex (double[] location, Object vertexData);

	public native void setProperty (int which, double data);
	public native double getProperty (int which);

	public native void deleteTess ();

	protected void finalize()
	{
		this.deleteTess();
	}
	protected Object getPolygonObject() { return polygonObject; }

	private native void initImplementation ();

	// instance variables
	private RawData implementation;
	private TesselatorListener callback;
	private Object polygonObject;

}
