/************************************************************
* Copyright 2005 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#include "glu4gcj/GLU.h"
#include <java/lang/String.h>

#include <gcj/cni.h>
#include <GL/glu.h>

using namespace glu4gcj;
using java::lang::String;

// functions

// instance methods
String*
GLU::gluErrorString (jint number)
{
	JvInitClass(&GLU::class$);
	String* string = NULL;

	const GLubyte* nativeString = ::gluErrorString(number);
	if (nativeString != NULL)
	{
		string = JvNewStringLatin1((const char*)nativeString);
	}

	return string;
}

String*
GLU::gluGetString (jint number)
{
	JvInitClass(&GLU::class$);
	String* string = NULL;

	const GLubyte* nativeString = ::gluGetString(number);
	if (nativeString != NULL)
	{
		string = JvNewStringLatin1((const char*)nativeString);
	}

	return string;
}

void
GLU::gluLookAt (jdouble eyeX, jdouble eyeY, jdouble eyeZ,
	jdouble centerX, jdouble centerY, jdouble centerZ,
	jdouble upX, jdouble upY, jdouble upZ)
{
	JvInitClass(&GLU::class$);
	::gluLookAt (eyeX, eyeY, eyeZ,
		centerX, centerY, centerZ, upX, upY, upZ);
}

void
GLU::gluOrtho2D (jdouble left, jdouble right,
	jdouble bottom, jdouble top)
{
	JvInitClass(&GLU::class$);
	::gluOrtho2D (left, right, bottom, top);
}

void
GLU::gluPerspective (jdouble fovy, jdouble aspect,
	jdouble zNear, jdouble zFar)
{
	JvInitClass(&GLU::class$);
	::gluPerspective (fovy, aspect, zNear, zFar);
}
