import gl4gcj.*;
import glut4gcj.*;

class TestWindow extends GL implements 
	DisplayFunc, KeyboardFunc
{
	private int id;

	public TestWindow(int windowID)
	{
		this.id = windowID;
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		glBegin(GL_POLYGON);
		glColor3d(1.0, 0.0, 0.0);
		glVertex2d(-0.9,  0.9);
		glColor3d(0.0, 1.0, 0.0);
		glVertex2d(-0.9, -0.9);
		glColor3d(0.0, 0.0, 1.0);
		glVertex2d( 0.9, -0.9);
		glColor3d(1.0, 1.0, 0.0);
		glVertex2d( 0.9,  0.9);
		glEnd();

		glFlush();
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q' || key == '')
		{
			System.exit(0);
		}
	}

}

public class MultiWindow extends GLUT 
{
	public static void main(String[] args)
	{
		try
		{
			int id;

			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutInitWindowSize(200, 200);

			glutInitWindowPosition(0, 0);
			id = glutCreateWindow("Test 1 ");
			TestWindow window1 = new TestWindow(id);
			glutDisplayFunc(window1);
			glutKeyboardFunc(window1);

			glutInitWindowPosition(200, 0);
			id = glutCreateWindow("Test 2 ");
			TestWindow window2 = new TestWindow(id);
			glutDisplayFunc(window2);
			glutKeyboardFunc(window2);

			glutInitWindowPosition(400, 0);
			id = glutCreateWindow("Test 3 ");
			TestWindow window3 = new TestWindow(id);
			glutDisplayFunc(window3);
			glutKeyboardFunc(window3);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
