#include "gl4gcj/GL.h"
#include "gl4gcj/GLException.h"

#include <gcj/cni.h>
#include <assert.h>
#include <GL/gl.h>

using namespace ::gl4gcj;


// function
static 
inline
GLException*
createArraySizeException()
{
	return new GLException(JvNewStringLatin1("Array size is too small."));
}

// Miscellaneous
void
GL::glClearIndex (jfloat c)
{
	JvInitClass(&GL::class$);
	::glClearIndex(c);
}


void
GL::glClearColor (jfloat red, jfloat green, jfloat blue, jfloat alpha)
{
	JvInitClass(&GL::class$);
	::glClearColor(red, green, blue, alpha);
}


void
GL::glClear (jint mask)
{
	JvInitClass(&GL::class$);
	::glClear(mask);
}


void
GL::glIndexMask (jlong mask)
{
	JvInitClass(&GL::class$);
	::glIndexMask(mask);
}


void
GL::glColorMask (jboolean red, jboolean green, jboolean blue, jboolean alpha)
{
	JvInitClass(&GL::class$);
	::glColorMask(red, green, blue, alpha);
}


void
GL::glAlphaFunc (jint func, jfloat ref)
{
	JvInitClass(&GL::class$);
	::glAlphaFunc(func, ref);
}


void
GL::glBlendFunc (jint sfactor, jint dfactor)
{
	JvInitClass(&GL::class$);
	::glBlendFunc(sfactor, dfactor);
}


void
GL::glLogicOp (jint opcode)
{
	JvInitClass(&GL::class$);
	::glLogicOp(opcode);
}


void
GL::glCullFace (jint mode)
{
	JvInitClass(&GL::class$);
	::glCullFace (mode);
}


void
GL::glFrontFace (jint mode)
{
	JvInitClass(&GL::class$);
	::glFrontFace (mode);
}


void
GL::glPointSize (jfloat size)
{
	JvInitClass(&GL::class$);
	::glPointSize (size);
}


void
GL::glLineWidth (jfloat width)
{
	JvInitClass(&GL::class$);
	::glLineWidth (width);
}


void
GL::glLineStipple (jint factor, jshort pattern)
{
	JvInitClass(&GL::class$);
	::glLineStipple (factor, pattern);
}


void
GL::glPolygonMode (jint face, jint mode)
{
	JvInitClass(&GL::class$);
	::glPolygonMode (face, mode);
}


void
GL::glPolygonOffset (jfloat factor, jfloat units)
{
	JvInitClass(&GL::class$);
	::glPolygonOffset (factor, units);
}


void
GL::glPolygonStipple (jbyteArray mask)
{
	JvInitClass(&GL::class$);
	if (mask->length >= 128)
	{
		const GLubyte* native_mask = (const GLubyte*)elements(mask);
		::glPolygonStipple ((const GLubyte*)native_mask);
	}
}


void
GL::glGetPolygonStipple (jbyteArray mask)
{
	JvInitClass(&GL::class$);
	if (mask->length >= 128)
	{
		GLubyte* native_mask = (GLubyte*)elements(mask);
		::glGetPolygonStipple ((GLubyte*)native_mask);
	}
}


void
GL::glEdgeFlag (jboolean flag)
{
	JvInitClass(&GL::class$);
	::glEdgeFlag (flag);
}


void
GL::glEdgeFlagv (jbooleanArray flags)
{
	JvInitClass(&GL::class$);
	GLboolean* native_flags = (GLboolean*)elements(flags);
	::glEdgeFlagv ((const GLboolean*)native_flags);
}


void
GL::glScissor (jint x, jint y, jint width, jint height)
{
	JvInitClass(&GL::class$);
	::glScissor (x, y, width, height);
}


void
GL::glClipPlane (jint plane, jdoubleArray equation)
{
	JvInitClass(&GL::class$);
	if (equation->length >= 4)
	{
		jdouble* native_equation = elements(equation);
		::glClipPlane (plane, (const GLdouble*)native_equation);
	}
}


void
GL::glGetClipPlane (jint plane, jdoubleArray equation)
{
	JvInitClass(&GL::class$);
	if (equation->length >= 4)
	{
		jdouble* native_equation = elements(equation);
		::glGetClipPlane (plane, (GLdouble*)native_equation);
	}
}


void
GL::glDrawBuffer (jint mode)
{
	JvInitClass(&GL::class$);
	::glDrawBuffer (mode);
}


void
GL::glReadBuffer (jint mode)
{
	JvInitClass(&GL::class$);
	::glReadBuffer (mode);
}


void
GL::glEnable (jint cap)
{
	JvInitClass(&GL::class$);
	::glEnable (cap);
}


void
GL::glDisable (jint cap)
{
	JvInitClass(&GL::class$);
	::glDisable (cap);
}


jboolean
GL::glIsEnabled (jint cap)
{
	JvInitClass(&GL::class$);
	jboolean result = (jboolean)glIsEnabled (cap);
	return result;
}


void
GL::glEnableClientState (jint cap)
{
	JvInitClass(&GL::class$);
	::glEnableClientState (cap);
}


void
GL::glDisableClientState (jint cap)
{
	JvInitClass(&GL::class$);
	::glDisableClientState (cap);
}


jbooleanArray
GL::glGetBooleanv (jint pname)
{
	JvInitClass(&GL::class$);
	jbooleanArray params = NULL;
	if (pname == GL_COLOR_WRITEMASK)
		params = JvNewBooleanArray(4);
	else
		params = JvNewBooleanArray(1);

	jboolean* native_params = elements(params);
	::glGetBooleanv(pname, (GLboolean*)native_params);

	return params;
}


/*
void
GL::glGetDoublev (jint pname, jdoubleArray params)
{
	JvInitClass(&GL::class$);
//	jdouble* native_params = elements(params);
//	::glGetDoublev (pname, native_params)
}


void
GL::glGetFloatv (jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
//	jfloat* native_params = elements(params);
//	::glGetFloatv (pname, native_params);
}


void
GL::glGetIntegerv (jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
//	jint* native_params = elements(params);
//	::glGetIntegerv (pname, native_params);
}
*/


void
GL::glPushAttrib (jint mask)
{
	JvInitClass(&GL::class$);
	::glPushAttrib (mask);
}


void
GL::glPopAttrib ()
{
	JvInitClass(&GL::class$);
	::glPopAttrib ();
}


void
GL::glPushClientAttrib (jint mask)
{
	JvInitClass(&GL::class$);
	::glPushClientAttrib (mask);
}


void
GL::glPopClientAttrib ()
{
	JvInitClass(&GL::class$);
	::glPopClientAttrib ();
}


jint
GL::glRenderMode (jint mode)
{
	JvInitClass(&GL::class$);
	return ::glRenderMode(mode);
}


jint
GL::glGetError ()
{
	JvInitClass(&GL::class$);
	return ::glGetError();
}


java::lang::String*
GL::glGetString (jint name)
{
	JvInitClass(&GL::class$);
	::java::lang::String* result = NULL;
	const char* string = (const char*)::glGetString (name);
	result = JvNewStringLatin1(string);
	return result;
}


void
GL::glFinish ()
{
	JvInitClass(&GL::class$);
	::glFinish ();
}


void
GL::glFlush ()
{
	JvInitClass(&GL::class$);
	::glFlush ();
}


void
GL::glHint (jint target, jint mode)
{
	JvInitClass(&GL::class$);
	::glHint (target, mode);
}


// Depth Buffer


void
GL::glClearDepth (jdouble depth)
{
	JvInitClass(&GL::class$);
	::glClearDepth (depth);
}


void
GL::glDepthFunc (jint func)
{
	JvInitClass(&GL::class$);
	::glDepthFunc (func);
}


void
GL::glDepthMask (jboolean flag)
{
	JvInitClass(&GL::class$);
	::glDepthMask (flag);
}


void
GL::glDepthRange (jdouble near_val, jdouble far_val)
{
	JvInitClass(&GL::class$);
	::glDepthRange (near_val, far_val);
}


// Accumulation Buffer

void
GL::glClearAccum (jfloat red, jfloat green, jfloat blue, jfloat alpha)
{
	JvInitClass(&GL::class$);
	::glClearAccum (red, green, blue, alpha);
}


void
GL::glAccum (jint op, jfloat value)
{
	JvInitClass(&GL::class$);
	::glAccum (op, value);
}


// Transformation

void
GL::glMatrixMode (jint mode)
{
	JvInitClass(&GL::class$);
	::glMatrixMode (mode);
}


void
GL::glOrtho (jdouble left, jdouble right, jdouble bottom, jdouble top, jdouble near_val, jdouble far_val)
{
	JvInitClass(&GL::class$);
	::glOrtho (left, right, bottom, top, near_val, far_val);
}


void
GL::glFrustum (jdouble left, jdouble right, jdouble bottom, jdouble top, jdouble near_val, jdouble far_val)
{
	JvInitClass(&GL::class$);
	::glFrustum (left, right, bottom, top, near_val, far_val);
}


void
GL::glViewport (jint x, jint y, jint width, jint height)
{
	JvInitClass(&GL::class$);
	::glViewport (x, y, width, height);
}


void
GL::glPushMatrix ()
{
	JvInitClass(&GL::class$);
	::glPushMatrix ();
}


void
GL::glPopMatrix ()
{
	JvInitClass(&GL::class$);
	::glPopMatrix ();
}


void
GL::glLoadIdentity ()
{
	JvInitClass(&GL::class$);
	::glLoadIdentity ();
}


void
GL::glLoadMatrixd (jdoubleArray m)
{
	JvInitClass(&GL::class$);
	if (m->length >= 16)
	{
		GLdouble* native_matrix = (GLdouble*)elements(m);
		::glLoadMatrixd (native_matrix);
	}
}


void
GL::glLoadMatrixf (jfloatArray m)
{
	JvInitClass(&GL::class$);
	if (m->length >= 16)
	{
		GLfloat* native_matrix = (GLfloat*)elements(m);
		::glLoadMatrixf (native_matrix);
	}
}


void
GL::glMultMatrixd (jdoubleArray m)
{
	JvInitClass(&GL::class$);
	if (m->length >= 16)
	{
		GLdouble* native_matrix = (GLdouble*)elements(m);
		::glMultMatrixd (native_matrix);
	}
}


void
GL::glMultMatrixf (jfloatArray m)
{
	JvInitClass(&GL::class$);
	if (m->length >= 16)
	{
		GLfloat* native_matrix = (GLfloat*)elements(m);
		::glMultMatrixf (native_matrix);
	}
}


void
GL::glRotated (jdouble angle, jdouble x, jdouble y, jdouble z)
{
	JvInitClass(&GL::class$);
	::glRotated (angle, x, y, z);
}


void
GL::glRotatef (jfloat angle, jfloat x, jfloat y, jfloat z)
{
	JvInitClass(&GL::class$);
	::glRotatef (angle, x, y, z);
}


void
GL::glScaled (jdouble x, jdouble y, jdouble z)
{
	JvInitClass(&GL::class$);
	::glScaled (x, y, z);
}


void
GL::glScalef (jfloat x, jfloat y, jfloat z)
{
	JvInitClass(&GL::class$);
	::glScalef (x, y, z);
}


void
GL::glTranslated (jdouble x, jdouble y, jdouble z)
{
	JvInitClass(&GL::class$);
	::glTranslated (x, y, z);
}


void
GL::glTranslatef (jfloat x, jfloat y, jfloat z)
{
	JvInitClass(&GL::class$);
	::glTranslatef (x, y, z);
}


// Display Lists

jboolean
GL::glIsList (jlong list)
{
	JvInitClass(&GL::class$);
	jboolean result = ::glIsList ((GLuint)list); 
	return result;
}


void
GL::glDeleteLists (jlong list, jint range)
{
	JvInitClass(&GL::class$);
	::glDeleteLists (list, range);
}


jlong
GL::glGenLists (jint range)
{
	JvInitClass(&GL::class$);
	jlong result = 0;
	result = ::glGenLists (range);
	return result;
}


void
GL::glNewList (jlong list, jint mode)
{
	JvInitClass(&GL::class$);
	::glNewList (list, mode);
}


void
GL::glEndList ()
{
	JvInitClass(&GL::class$);
	::glEndList ();
}


void
GL::glCallList (jlong list)
{
	JvInitClass(&GL::class$);
	::glCallList (list);
}

void
GL::glCallLists (jbyteArray lists)
{
	JvInitClass(&GL::class$);
	::glCallLists (JvGetArrayLength(lists), GL_BYTE, elements(lists));
}

void
GL::glCallLists (jshortArray lists)
{
	JvInitClass(&GL::class$);
	::glCallLists (JvGetArrayLength(lists), GL_SHORT, elements(lists));
}

void
GL::glCallLists (jintArray lists)
{
	JvInitClass(&GL::class$);
	::glCallLists (JvGetArrayLength(lists), GL_INT, elements(lists));
}

void
GL::glListBase (jlong base)
{
	JvInitClass(&GL::class$);
	::glListBase (base);
}


// Drawing Functions

void
GL::glBegin (jint mode)
{
	JvInitClass(&GL::class$);
	::glBegin (mode);
}


void
GL::glEnd ()
{
	JvInitClass(&GL::class$);
	::glEnd ();
}


void
GL::glVertex2d (jdouble x, jdouble y)
{
	JvInitClass(&GL::class$);
	::glVertex2d (x, y);
}


void
GL::glVertex2f (jfloat x, jfloat y)
{
	JvInitClass(&GL::class$);
	::glVertex2f (x, y);
}


void
GL::glVertex2i (jint x, jint y)
{
	JvInitClass(&GL::class$);
	::glVertex2i (x, y);
}


void
GL::glVertex2s (jshort x, jshort y)
{
	JvInitClass(&GL::class$);
	::glVertex2s (x, y);
}


void
GL::glVertex3d (jdouble x, jdouble y, jdouble z)
{
	JvInitClass(&GL::class$);
	::glVertex3d (x, y, z);
}


void
GL::glVertex3f (jfloat x, jfloat y, jfloat z)
{
	JvInitClass(&GL::class$);
	::glVertex3f (x, y, z);
}


void
GL::glVertex3i (jint x, jint y, jint z)
{
	JvInitClass(&GL::class$);
	::glVertex3i (x, y, z);
}


void
GL::glVertex3s (jshort x, jshort y, jshort z)
{
	JvInitClass(&GL::class$);
	::glVertex3s (x, y, z);
}


void
GL::glVertex4d (jdouble x, jdouble y, jdouble z, jdouble w)
{
	JvInitClass(&GL::class$);
	::glVertex4d (x, y, z, w);
}


void
GL::glVertex4f (jfloat x, jfloat y, jfloat z, jfloat w)
{
	JvInitClass(&GL::class$);
	::glVertex4f (x, y, z, w);
}


void
GL::glVertex4i (jint x, jint y, jint z, jint w)
{
	JvInitClass(&GL::class$);
	::glVertex4i (x, y, z, w);
}


void
GL::glVertex4s (jshort x, jshort y, jshort z, jshort w)
{
	JvInitClass(&GL::class$);
	::glVertex4s (x, y, z, w);
}


void
GL::glVertex2dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glVertex2dv((GLdouble*)elements(v));
	
}


void
GL::glVertex2fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glVertex2fv ((GLfloat*)elements(v));
}

void
GL::glVertex2iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glVertex2iv ((GLint*)elements(v));
}


void
GL::glVertex2sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glVertex2sv ((GLshort*)elements(v));
}


void
GL::glVertex3dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glVertex3dv ((GLdouble*)elements(v));
}


void
GL::glVertex3fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glVertex3fv ((GLfloat*)elements(v));
}


void
GL::glVertex3iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glVertex3iv ((GLint*)elements(v));
}


void
GL::glVertex3sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glVertex3sv ((GLshort*)elements(v));
}


void
GL::glVertex4dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glVertex4dv ((GLdouble*)elements(v));
}


void
GL::glVertex4fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glVertex4fv ((GLfloat*)elements(v));
}


void
GL::glVertex4iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glVertex4iv ((GLint*)elements(v));
}


void
GL::glVertex4sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glVertex4sv ((GLshort*)elements(v));
}


void
GL::glNormal3b (jbyte nx, jbyte ny, jbyte nz)
{
	JvInitClass(&GL::class$);
	::glNormal3b (nx, ny, nz);
}


void
GL::glNormal3d (jdouble nx, jdouble ny, jdouble nz)
{
	JvInitClass(&GL::class$);
	::glNormal3d (nx, ny, nz);
}


void
GL::glNormal3f (jfloat nx, jfloat ny, jfloat nz)
{
	JvInitClass(&GL::class$);
	::glNormal3f (nx, ny, nz);
}


void
GL::glNormal3i (jint nx, jint ny, jint nz)
{
	JvInitClass(&GL::class$);
	::glNormal3i (nx, ny, nz);
}


void
GL::glNormal3s (jshort nx, jshort ny, jshort nz)
{
	JvInitClass(&GL::class$);
	::glNormal3s (nx, ny, nz);
}


void
GL::glNormal3bv (jbyteArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glNormal3bv ((GLbyte*)elements(v));
}


void
GL::glNormal3dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glNormal3dv ((GLdouble*)elements(v));
}


void
GL::glNormal3fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glNormal3fv ((GLfloat*)elements(v));
}


void
GL::glNormal3iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glNormal3iv ((GLint*)elements(v));
}


void
GL::glNormal3sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glNormal3sv ((GLshort*)elements(v));
}


void
GL::glIndexd (jdouble c)
{
	JvInitClass(&GL::class$);
	::glIndexd (c);
}


void
GL::glIndexf (jfloat c)
{
	JvInitClass(&GL::class$);
	::glIndexf (c);
}


void
GL::glIndexi (jint c)
{
	JvInitClass(&GL::class$);
	::glIndexi (c);
}


void
GL::glIndexs (jshort c)
{
	JvInitClass(&GL::class$);
	::glIndexs (c);
}


void
GL::glIndexub (jshort c)
{
	JvInitClass(&GL::class$);
	::glIndexub (c);
}


/*
void
GL::glIndexdv (jdoubleArray c)
{
	JvInitClass(&GL::class$);
	::glIndexdv (c);
}


void
GL::glIndexfv (jfloatArray c)
{
	JvInitClass(&GL::class$);
	::glIndexfv (c);
}


void
GL::glIndexiv (jintArray c)
{
	JvInitClass(&GL::class$);
	::glIndexiv (c);
}


void
GL::glIndexsv (jshortArray c)
{
	JvInitClass(&GL::class$);
	::glIndexsv (c);
}


void
GL::glIndexubv (jshortArray c)
{
	JvInitClass(&GL::class$);
	::glIndexubv (jshortArray c)
}
*/


void
GL::glColor3b (jbyte red, jbyte green, jbyte blue)
{
	JvInitClass(&GL::class$);
	::glColor3b (red, green, blue);
}


void
GL::glColor3d (jdouble red, jdouble green, jdouble blue)
{
	JvInitClass(&GL::class$);
	::glColor3d (red, green, blue);
}


void
GL::glColor3f (jfloat red, jfloat green, jfloat blue)
{
	JvInitClass(&GL::class$);
	::glColor3f (red, green, blue);
}


void
GL::glColor3i (jint red, jint green, jint blue)
{
	JvInitClass(&GL::class$);
	::glColor3i (red, green, blue);
}


void
GL::glColor3s (jshort red, jshort green, jshort blue)
{
	JvInitClass(&GL::class$);
	::glColor3s (red, green, blue);
}


void
GL::glColor3ub (jshort red, jshort green, jshort blue)
{
	JvInitClass(&GL::class$);
	::glColor3ub (red, green, blue);
}


void
GL::glColor3ui (jlong red, jlong green, jlong blue)
{
	JvInitClass(&GL::class$);
	::glColor3ui (red, green, blue);
}


void
GL::glColor3us (jint red, jint green, jint blue)
{
	JvInitClass(&GL::class$);
	::glColor3us (red, green, blue);
}


void
GL::glColor4b (jbyte red, jbyte green, jbyte blue, jbyte alpha)
{
	JvInitClass(&GL::class$);
	::glColor4b (red, green, blue, alpha);
}


void
GL::glColor4d (jdouble red, jdouble green, jdouble blue, jdouble alpha)
{
	JvInitClass(&GL::class$);
	::glColor4d (red, green, blue, alpha);
}


void
GL::glColor4f (jfloat red, jfloat green, jfloat blue, jfloat alpha)
{
	JvInitClass(&GL::class$);
	::glColor4f (red, green, blue, alpha);
}


void
GL::glColor4i (jint red, jint green, jint blue, jint alpha)
{
	JvInitClass(&GL::class$);
	::glColor4i (red, green, blue, alpha);
}


void
GL::glColor4s (jshort red, jshort green, jshort blue, jshort alpha)
{
	JvInitClass(&GL::class$);
	::glColor4s (red, green, blue, alpha);
}


void
GL::glColor4ub (jshort red, jshort green, jshort blue, jshort alpha)
{
	JvInitClass(&GL::class$);
	::glColor4ub (red, green, blue, alpha);
}


void
GL::glColor4ui (jlong red, jlong green, jlong blue, jlong alpha)
{
	JvInitClass(&GL::class$);
	::glColor4ui (red, green, blue, alpha);
}


void
GL::glColor4us (jint red, jint green, jint alpha, jint blue)
{
	JvInitClass(&GL::class$);
	::glColor4us (red, green, alpha, blue);
}


void
GL::glColor3bv (jbyteArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3bv ((GLbyte*)elements(v));
}


void
GL::glColor3dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3dv ((GLdouble*)elements(v));
}


void
GL::glColor3fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3fv ((GLfloat*)elements(v));
}


void
GL::glColor3iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3iv ((GLint*)elements(v));
}


void
GL::glColor3sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3sv ((GLshort*)elements(v));
}

void
GL::glColor3ubv (jbyteArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3ubv ((GLubyte*)elements(v));
}


void
GL::glColor3uiv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3uiv ((GLuint*)elements(v));
}


void
GL::glColor3usv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glColor3usv ((GLushort*)elements(v));
}



void
GL::glColor4bv (jbyteArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4bv ((GLbyte*)elements(v));
}


void
GL::glColor4dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4dv ((GLdouble*)elements(v));
}


void
GL::glColor4fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4fv ((GLfloat*)elements(v));
}


void
GL::glColor4iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4iv ((GLint*)elements(v));
}


void
GL::glColor4sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4sv ((GLshort*)elements(v));
}


void
GL::glColor4ubv (jbyteArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4ubv ((GLubyte*)elements(v));
}


void
GL::glColor4uiv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4uiv ((GLuint*)elements(v));
}


void
GL::glColor4usv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glColor4usv ((GLushort*)elements(v));
}



void
GL::glTexCoord1d (jdouble s)
{
	JvInitClass(&GL::class$);
	::glTexCoord1d (s);
}


void
GL::glTexCoord1f (jfloat s)
{
	JvInitClass(&GL::class$);
	::glTexCoord1f (s);
}


void
GL::glTexCoord1i (jint s)
{
	JvInitClass(&GL::class$);
	::glTexCoord1i (s);
}


void
GL::glTexCoord1s (jshort s)
{
	JvInitClass(&GL::class$);
	::glTexCoord1s (s);
}


void
GL::glTexCoord2d (jdouble s, jdouble t)
{
	JvInitClass(&GL::class$);
	::glTexCoord2d (s, t);
}


void
GL::glTexCoord2f (jfloat s, jfloat t)
{
	JvInitClass(&GL::class$);
	::glTexCoord2f (s, t);
}


void
GL::glTexCoord2i (jint s, jint t)
{
	JvInitClass(&GL::class$);
	::glTexCoord2i (s, t);
}


void
GL::glTexCoord2s (jshort s, jshort t)
{
	JvInitClass(&GL::class$);
	::glTexCoord2s (s, t);
}


void
GL::glTexCoord3d (jdouble s, jdouble t, jdouble r)
{
	JvInitClass(&GL::class$);
	::glTexCoord3d (s, t, r);
}


void
GL::glTexCoord3f (jfloat s, jfloat t, jfloat r)
{
	JvInitClass(&GL::class$);
	::glTexCoord3f (s, t, r);
}


void
GL::glTexCoord3i (jint s, jint t, jint r)
{
	JvInitClass(&GL::class$);
	::glTexCoord3i (s, t, r);
}


void
GL::glTexCoord3s (jshort s, jshort t, jshort r)
{
	JvInitClass(&GL::class$);
	::glTexCoord3s (s, t, r);
}


void
GL::glTexCoord4d (jdouble s, jdouble t, jdouble r, jdouble q)
{
	JvInitClass(&GL::class$);
	::glTexCoord4d (s, t, r, q);
}


void
GL::glTexCoord4f (jfloat s, jfloat t, jfloat r, jfloat q)
{
	JvInitClass(&GL::class$);
	::glTexCoord4f (s, t, r, q);
}


void
GL::glTexCoord4i (jint s, jint t, jint r, jint q)
{
	JvInitClass(&GL::class$);
	::glTexCoord4i (s, t, r, q);
}


void
GL::glTexCoord4s (jshort s, jshort t, jshort r, jshort q)
{
	JvInitClass(&GL::class$);
	::glTexCoord4s (s, t, r, q);
}


void
GL::glTexCoord1dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 1) throw createArraySizeException();
	::glTexCoord1dv ((GLdouble*)elements(v));
}


void
GL::glTexCoord1fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 1) throw createArraySizeException();
	::glTexCoord1fv ((GLfloat*)elements(v));
}


void
GL::glTexCoord1iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 1) throw createArraySizeException();
	::glTexCoord1iv ((GLint*)elements(v));
}


void
GL::glTexCoord1sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 1) throw createArraySizeException();
	::glTexCoord1sv ((GLshort*)elements(v));
}


void
GL::glTexCoord2dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glTexCoord2dv ((GLdouble*)elements(v));
}


void
GL::glTexCoord2fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glTexCoord2fv ((GLfloat*)elements(v));
}


void
GL::glTexCoord2iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glTexCoord2iv ((GLint*)elements(v));
}


void
GL::glTexCoord2sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glTexCoord2sv ((GLshort*)elements(v));
}


void
GL::glTexCoord3dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glTexCoord3dv ((GLdouble*)elements(v));
}


void
GL::glTexCoord3fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glTexCoord3fv ((GLfloat*)elements(v));
}


void
GL::glTexCoord3iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glTexCoord3iv ((GLint*)elements(v));
}


void
GL::glTexCoord3sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glTexCoord3sv ((GLshort*)elements(v));
}


void
GL::glTexCoord4dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glTexCoord4dv ((GLdouble*)elements( v));
}


void
GL::glTexCoord4fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glTexCoord4fv ((GLfloat*)elements(v));
}


void
GL::glTexCoord4iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glTexCoord4iv ((GLint*)elements(v));
}


void
GL::glTexCoord4sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glTexCoord4sv ((GLshort*)elements(v));
}


void
GL::glRasterPos2d (jdouble x, jdouble y)
{
	JvInitClass(&GL::class$);
	::glRasterPos2d (x, y);
}


void
GL::glRasterPos2f (jfloat x, jfloat y)
{
	JvInitClass(&GL::class$);
	::glRasterPos2f (x, y);
}


void
GL::glRasterPos2i (jint x, jint y)
{
	JvInitClass(&GL::class$);
	::glRasterPos2i (x, y);
}


void
GL::glRasterPos2s (jshort x, jshort y)
{
	JvInitClass(&GL::class$);
	::glRasterPos2s (x, y);
}


void
GL::glRasterPos3d (jdouble x, jdouble y, jdouble z)
{
	JvInitClass(&GL::class$);
	::glRasterPos3d (x, y, z);
}


void
GL::glRasterPos3f (jfloat x, jfloat y, jfloat z)
{
	JvInitClass(&GL::class$);
	::glRasterPos3f (x, y, z);
}


void
GL::glRasterPos3i (jint x, jint y, jint z)
{
	JvInitClass(&GL::class$);
	::glRasterPos3i (x, y, z);
}


void
GL::glRasterPos3s (jshort x, jshort y, jshort z)
{
	JvInitClass(&GL::class$);
	::glRasterPos3s (x, y, z);
}


void
GL::glRasterPos4d (jdouble x, jdouble y, jdouble z, jdouble w)
{
	JvInitClass(&GL::class$);
	::glRasterPos4d (x, y, z, w);
}


void
GL::glRasterPos4f (jfloat x, jfloat y, jfloat z, jfloat w)
{
	JvInitClass(&GL::class$);
	::glRasterPos4f (x, y, z, w);
}


void
GL::glRasterPos4i (jint x, jint y, jint z, jint w)
{
	JvInitClass(&GL::class$);
	::glRasterPos4i (x, y, z, w);
}


void
GL::glRasterPos4s (jshort x, jshort y, jshort z, jshort w)
{
	JvInitClass(&GL::class$);
	::glRasterPos4s (x, y, z, w);
}


void
GL::glRasterPos2dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glRasterPos2dv ((GLdouble*)elements(v));
}


void
GL::glRasterPos2fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glRasterPos2fv ((GLfloat*)elements(v));
}


void
GL::glRasterPos2iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glRasterPos2iv ((GLint*)elements(v));
}


void
GL::glRasterPos2sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 2) throw createArraySizeException();
	::glRasterPos2sv ((GLshort*)elements(v));
}


void
GL::glRasterPos3dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glRasterPos3dv ((GLdouble*)elements(v));
}


void
GL::glRasterPos3fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glRasterPos3fv ((GLfloat*)elements(v));
}


void
GL::glRasterPos3iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glRasterPos3iv ((GLint*)elements(v));
}


void
GL::glRasterPos3sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 3) throw createArraySizeException();
	::glRasterPos3sv ((GLshort*)elements(v));
}


void
GL::glRasterPos4dv (jdoubleArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glRasterPos4dv ((GLdouble*)elements(v));
}


void
GL::glRasterPos4fv (jfloatArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glRasterPos4fv ((GLfloat*)elements(v));
}


void
GL::glRasterPos4iv (jintArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glRasterPos4iv ((GLint*)elements(v));
}


void
GL::glRasterPos4sv (jshortArray v)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v) < 4) throw createArraySizeException();
	::glRasterPos4sv ((GLshort*)elements(v));
}


void
GL::glRectd (jdouble x1, jdouble y1, jdouble x2, jdouble y2)
{
	JvInitClass(&GL::class$);
	::glRectd (x1, y1, x2, y2);
}


void
GL::glRectf (jfloat x1, jfloat y1, jfloat x2, jfloat y2)
{
	JvInitClass(&GL::class$);
	::glRectf (x1, y1, x2, y2);
}


void
GL::glRecti (jint x1, jint y1, jint x2, jint y2)
{
	JvInitClass(&GL::class$);
	::glRecti (x1, y1, x2, y2);
}


void
GL::glRects (jshort x1, jshort y1, jshort x2, jshort y2)
{
	JvInitClass(&GL::class$);
	::glRects (x1, y1, x2, y2);
}


void
GL::glRectdv (jdoubleArray v1, jdoubleArray v2)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v1) < 2) throw createArraySizeException();
	if (JvGetArrayLength(v2) < 2) throw createArraySizeException();
	::glRectdv ((GLdouble*)elements( v1), (GLdouble*)elements(v2));
}


void
GL::glRectfv (jfloatArray v1, jfloatArray v2)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v1) < 2) throw createArraySizeException();
	if (JvGetArrayLength(v2) < 2) throw createArraySizeException();
	::glRectfv ((GLfloat*)elements(v1), (GLfloat*)elements(v2));
}


void
GL::glRectiv (jintArray v1, jintArray v2)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v1) < 2) throw createArraySizeException();
	if (JvGetArrayLength(v2) < 2) throw createArraySizeException();
	::glRectiv ((GLint*)elements(v1), (GLint*)elements(v2));
}


void
GL::glRectsv (jshortArray v1, jshortArray v2)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(v1) < 2) throw createArraySizeException();
	if (JvGetArrayLength(v2) < 2) throw createArraySizeException();
	::glRectsv ((GLshort*)elements(v1), (GLshort*)elements(v2));
}


void
GL::glVertexPointer (jint size, jshortArray vertexArray)
{
	JvInitClass(&GL::class$);
	::glVertexPointer(size, GL_SHORT, 0, elements(vertexArray));
}

void
GL::glVertexPointer (jint size, jintArray vertexArray)
{
	JvInitClass(&GL::class$);
	::glVertexPointer(size, GL_INT, 0, elements(vertexArray));
}

void
GL::glVertexPointer (jint size, jfloatArray vertexArray)
{
	JvInitClass(&GL::class$);
	::glVertexPointer(size, GL_FLOAT, 0, elements(vertexArray));
}

void
GL::glVertexPointer (jint size, jdoubleArray vertexArray)
{
	JvInitClass(&GL::class$);
	::glVertexPointer(size, GL_DOUBLE, 0, elements(vertexArray));
}


void
GL::glNormalPointer (jbyteArray normalArray)
{
	JvInitClass(&GL::class$);
	::glNormalPointer(GL_BYTE, 0, elements(normalArray));
}

void
GL::glNormalPointer (jshortArray normalArray)
{
	JvInitClass(&GL::class$);
	::glNormalPointer(GL_SHORT, 0, elements(normalArray));
}

void
GL::glNormalPointer (jintArray normalArray)
{
	JvInitClass(&GL::class$);
	::glNormalPointer(GL_INT, 0, elements(normalArray));
}

void
GL::glNormalPointer (jdoubleArray normalArray)
{
	JvInitClass(&GL::class$);
	::glNormalPointer(GL_DOUBLE, 0, elements(normalArray));
}

void
GL::glNormalPointer (jfloatArray normalArray)
{
	JvInitClass(&GL::class$);
	::glNormalPointer(GL_FLOAT, 0, elements(normalArray));
}


void
GL::glColorPointer (jint size, jbyteArray colorArray)
{
	JvInitClass(&GL::class$);
	::glColorPointer(size, GL_BYTE, 0, elements(colorArray));
}

void
GL::glColorPointer (jint size, jshortArray colorArray)
{
	JvInitClass(&GL::class$);
	::glColorPointer(size, GL_SHORT, 0, elements(colorArray));
}

void
GL::glColorPointer (jint size, jintArray colorArray)
{
	JvInitClass(&GL::class$);
	::glColorPointer(size, GL_INT, 0, elements(colorArray));
}

void
GL::glColorPointer (jint size, jfloatArray colorArray)
{
	JvInitClass(&GL::class$);
	::glColorPointer(size, GL_FLOAT, 0, elements(colorArray));
}

void
GL::glColorPointer (jint size, jdoubleArray colorArray)
{
	JvInitClass(&GL::class$);
	::glColorPointer(size, GL_DOUBLE, 0, elements(colorArray));
}


void
GL::glIndexPointer (jbyteArray indexArray)
{
	JvInitClass(&GL::class$);
	::glIndexPointer(GL_BYTE, 0, elements(indexArray));
}

void
GL::glIndexPointer (jshortArray indexArray)
{
	JvInitClass(&GL::class$);
	::glIndexPointer(GL_SHORT, 0, elements(indexArray));
}

void
GL::glIndexPointer (jintArray indexArray)
{
	JvInitClass(&GL::class$);
	::glIndexPointer(GL_INT, 0, elements(indexArray));
}

void
GL::glIndexPointer (jfloatArray indexArray)
{
	JvInitClass(&GL::class$);
	::glIndexPointer(GL_FLOAT, 0, elements(indexArray));
}

void
GL::glIndexPointer (jdoubleArray indexArray)
{
	JvInitClass(&GL::class$);
	::glIndexPointer(GL_DOUBLE, 0, elements(indexArray));
}



void
GL::glTexCoordPointer (jint size, jshortArray texCoordArray)
{
	JvInitClass(&GL::class$);
	::glTexCoordPointer(size, GL_SHORT, 0, elements(texCoordArray));
}

void
GL::glTexCoordPointer (jint size, jintArray texCoordArray)
{
	JvInitClass(&GL::class$);
	::glTexCoordPointer(size, GL_INT, 0, elements(texCoordArray));
}

void
GL::glTexCoordPointer (jint size, jfloatArray texCoordArray)
{
	JvInitClass(&GL::class$);
	::glTexCoordPointer(size, GL_FLOAT, 0, elements(texCoordArray));
}

void
GL::glTexCoordPointer (jint size, jdoubleArray texCoordArray)
{
	JvInitClass(&GL::class$);
	::glTexCoordPointer(size, GL_DOUBLE, 0, elements(texCoordArray));
}


void
GL::glEdgeFlagPointer (jbooleanArray edgeFlagArray)
{
	JvInitClass(&GL::class$);
	::glEdgeFlagPointer(0, elements(edgeFlagArray));
}



/************************************************************
// Vertex Arrays

void
GL::glGetPointerv (jint, JArray<JArray< ::java::lang::Object *> *> *)
{
	JvInitClass(&GL::class$);
}

************************************************************/


void
GL::glArrayElement (jint index)
{
	JvInitClass(&GL::class$);
	::glArrayElement(index);
}


void
GL::glDrawArrays (jint mode, jint first, jint count)
{
	JvInitClass(&GL::class$);
	::glDrawArrays(mode, first, count);
}


void
GL::glDrawElements (jint mode, jbyteArray indices)
{
	JvInitClass(&GL::class$);
	::glDrawElements (mode, JvGetArrayLength(indices), 
		GL_UNSIGNED_BYTE, elements(indices));
}

void
GL::glDrawElements (jint mode, jshortArray indices)
{
	JvInitClass(&GL::class$);
	::glDrawElements (mode, JvGetArrayLength(indices), 
		GL_UNSIGNED_SHORT, elements(indices));
}
void

GL::glDrawElements (jint mode, jintArray indices)
{
	JvInitClass(&GL::class$);
	::glDrawElements (mode, JvGetArrayLength(indices), 
		GL_UNSIGNED_INT, elements(indices));
}

/*
void
GL::glInterleavedArrays (jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}
*/

void
GL::glShadeModel (jint mode)
{
	JvInitClass(&GL::class$);
	::glShadeModel(mode);
}

void
GL::glLightf (jint lignt, jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glLightf(lignt, pname, param);
}

void
GL::glLighti (jint lignt, jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glLighti(lignt, pname, param);
}

void
GL::glLightfv (jint lignt, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(params) < 1) throw createArraySizeException();
	::glLightfv(lignt, pname, (GLfloat*)elements(params));
}

void
GL::glLightiv (jint lignt, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(params) < 1) throw createArraySizeException();
	::glLightiv(lignt, pname, (GLint*)elements(params));
}

void
GL::glGetLightfv (jint lignt, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(params) < 1) throw createArraySizeException();
	::glGetLightfv(lignt, pname, (GLfloat*)elements(params));
}

void
GL::glGetLightiv (jint lignt, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(params) < 1) throw createArraySizeException();
	::glGetLightiv(lignt, pname, (GLint*)elements(params));
}

void
GL::glLightModelf (jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glLightModelf(pname, param);
}

void
GL::glLightModeli (jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glLightModeli(pname, param);
}

void
GL::glLightModelfv (jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(params) < 1) throw createArraySizeException();
	::glLightModelfv(pname, (const GLfloat*)elements(params));
}

void
GL::glLightModeliv (jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(params) < 1) throw createArraySizeException();
	::glLightModeliv(pname, (const GLint*)elements(params));
}

void
GL::glMaterialf (jint face, jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glMaterialf(face, pname, param);
}

void
GL::glMateriali (jint face, jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glMaterialf(face, pname, param);
}

void
GL::glMaterialfv (jint face, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glMaterialfv(face, pname, (const GLfloat*)elements(params));
}

void
GL::glMaterialiv (jint face, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glMaterialiv(face, pname, (const GLint*)elements(params));
}

void
GL::glGetMaterialfv (jint face, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glGetMaterialfv(face, pname, (GLfloat*)elements(params));
}

void
GL::glGetMaterialiv (jint face, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glGetMaterialiv(face, pname, (GLint*)elements(params));
}

void
GL::glColorMaterial (jint face, jint mode)
{
	JvInitClass(&GL::class$);
	::glColorMaterial(face, mode);
}



void
GL::glPixelZoom (jfloat xfactor, jfloat yfactor)
{
	JvInitClass(&GL::class$);
	::glPixelZoom(xfactor, yfactor);
}

void
GL::glPixelStoref (jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glPixelStoref(pname, param);
}


void
GL::glPixelStorei (jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glPixelStorei(pname, param);
}


void
GL::glPixelTransferf (jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glPixelTransferf(pname, param);
}


void
GL::glPixelTransferi (jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glPixelTransferi(pname, param);
}


void
GL::glPixelMapfv (jint map, jfloatArray values)
{
	JvInitClass(&GL::class$);
	::glPixelMapfv(map, JvGetArrayLength(values), (const GLfloat*)elements(values));
}


void
GL::glPixelMapuiv (jint map, jintArray values)
{
	JvInitClass(&GL::class$);
	::glPixelMapuiv(map, JvGetArrayLength(values), (const GLuint*)elements(values));
}


void
GL::glPixelMapusv (jint map, jshortArray values)
{
	JvInitClass(&GL::class$);
	::glPixelMapusv(map, JvGetArrayLength(values), (const GLushort*)elements(values));
}


void
GL::glGetPixelMapfv (jint map, jfloatArray values)
{
	JvInitClass(&GL::class$);
	::glGetPixelMapfv(map, (GLfloat*)elements(values));
}


void
GL::glGetPixelMapuiv (jint map, jintArray values)
{
	JvInitClass(&GL::class$);
	::glGetPixelMapuiv(map, (GLuint*)elements(values));
}


void
GL::glGetPixelMapusv (jint map, jshortArray values)
{
	JvInitClass(&GL::class$);
	::glGetPixelMapusv(map, (GLushort*)elements(values));
}



void
GL::glBitmap (jint width, jint height, jfloat xorg, jfloat yorg,
	jfloat xmove, jfloat ymove, jbyteArray bitmap)
{
	JvInitClass(&GL::class$);
	::glBitmap(width, height, xorg, yorg, xmove, ymove, (const GLubyte*)elements(bitmap));
}

void
GL::glReadPixels (jint x, jint y, jint width, jint height, jint format, jint type, jfloatArray pixels)
{
	JvInitClass(&GL::class$);
	::glReadPixels(x, y, width, height, format, type, elements(pixels));
}

void
GL::glReadPixels (jint x, jint y, jint width, jint height, jint format, jint type, jbyteArray pixels)
{
	JvInitClass(&GL::class$);
	::glReadPixels(x, y, width, height, format, type, elements(pixels));
}

void
GL::glReadPixels (jint x, jint y, jint width, jint height, jint format, jint type, jshortArray pixels)
{
	JvInitClass(&GL::class$);
	::glReadPixels(x, y, width, height, format, type, elements(pixels));
}

void
GL::glReadPixels (jint x, jint y, jint width, jint height, jint format, jint type, jintArray pixels)
{
	JvInitClass(&GL::class$);
	::glReadPixels(x, y, width, height, format, type, elements(pixels));
}


void
GL::glDrawPixels (jint width, jint height, jint format, jint type, jfloatArray pixels)
{
	JvInitClass(&GL::class$);
	::glDrawPixels(width, height, format, type, elements(pixels));
}

void
GL::glDrawPixels (jint width, jint height, jint format, jint type, jbyteArray pixels)
{
	JvInitClass(&GL::class$);
	::glDrawPixels(width, height, format, type, elements(pixels));
}


void
GL::glDrawPixels (jint width, jint height, jint format, jint type, jshortArray pixels)
{
	JvInitClass(&GL::class$);
	::glDrawPixels(width, height, format, type, elements(pixels));
}

void
GL::glDrawPixels (jint width, jint height, jint format, jint type, jintArray pixels)
{
	JvInitClass(&GL::class$);
	::glDrawPixels(width, height, format, type, elements(pixels));
}


void
GL::glCopyPixels (jint x, jint y, jint width, jint height, jint buffer_type)
{
	JvInitClass(&GL::class$);
	::glCopyPixels(x, y, width, height, buffer_type);
}

// stenciling

void
GL::glStencilFunc (jint func, jint ref, jint mask)
{
	JvInitClass(&GL::class$);
	::glStencilFunc(func, ref, mask);
}

void
GL::glStencilMask (jint mask)
{
	JvInitClass(&GL::class$);
	::glStencilMask(mask);
}


void
GL::glStencilOp (jint fail, jint zfail, jint zpass)
{
	JvInitClass(&GL::class$);
	::glStencilOp(fail, zfail, zpass);
}


void
GL::glClearStencil (jint s)
{
	JvInitClass(&GL::class$);
	::glClearStencil(s);
}


// Texture mapping

void
GL::glTexGend (jint coord, jint pname, jdouble param)
{
	JvInitClass(&GL::class$);
	::glTexGenf(coord, pname, param);
}


void
GL::glTexGenf (jint coord, jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glTexGenf(coord, pname, param);
}

void
GL::glTexGeni (jint coord, jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glTexGeni(coord, pname, param);
}

void
GL::glTexGendv (jint coord, jint pname, jdoubleArray param)
{
	JvInitClass(&GL::class$);
	::glTexGendv(coord, pname, (const GLdouble*)elements(param));
}


void
GL::glTexGenfv (jint coord, jint pname, jfloatArray param)
{
	JvInitClass(&GL::class$);
	::glTexGenfv(coord, pname, (const GLfloat*)elements(param));
}


void
GL::glTexGeniv (jint coord, jint pname, jintArray param)
{
	JvInitClass(&GL::class$);
	::glTexGeniv(coord, pname, (const GLint*)elements(param));
}


void
GL::glGetTexGendv (jint coord, jint pname, jdoubleArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexGendv(coord, pname, (GLdouble*)elements(params));
}


void
GL::glGetTexGenfv (jint coord, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexGenfv(coord, pname, (GLfloat*)elements(params));
}


void
GL::glGetTexGeniv (jint coord, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexGeniv(coord, pname, (GLint*)elements(params));
}


void
GL::glTexEnvf (jint target, jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glTexEnvf(target, pname, param);
}


void
GL::glTexEnvi (jint target, jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glTexEnvi(target, pname, param);
}


void
GL::glTexEnvfv (jint target, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glTexEnvfv(target, pname, (GLfloat*)elements(params));
}


void
GL::glTexEnviv (jint target, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glTexEnviv(target, pname, (GLint*)elements(params));
}


void
GL::glGetTexEnvfv (jint target, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexEnvfv(target, pname, (GLfloat*)elements(params));
}


void
GL::glGetTexEnviv (jint target, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexEnviv(target, pname, (GLint*)elements(params));
}

void
GL::glTexParameterf (jint target, jint pname, jfloat param)
{
	JvInitClass(&GL::class$);
	::glTexParameterf(target, pname, param);
}


void
GL::glTexParameteri (jint target, jint pname, jint param)
{
	JvInitClass(&GL::class$);
	::glTexParameteri(target, pname, param);
}


void
GL::glTexParameterfv (jint target, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glTexParameterfv(target, pname, (GLfloat*)elements(params));
}


void
GL::glTexParameteriv (jint target, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glTexParameteriv(target, pname, (GLint*)elements(params));
}


void
GL::glGetTexParameterfv (jint target, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexParameterfv(target, pname, (GLfloat*)elements(params));
}

void
GL::glGetTexParameteriv (jint target, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexParameteriv(target, pname, (GLint*)elements(params));
}

void
GL::glGetTexLevelParameterfv (jint target, jint level, jint pname, jfloatArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexLevelParameterfv(target, level, pname, (GLfloat*)elements(params));
}


void
GL::glGetTexLevelParameteriv (jint target, jint level, jint pname, jintArray params)
{
	JvInitClass(&GL::class$);
	::glGetTexLevelParameteriv(target, level, pname, (GLint*)elements(params));
}

void
GL::glTexImage1D (jint target, jint level, jint internalFormat, jint width, jint border, jint format, jint type, jfloatArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage1D(target, level, internalFormat, width, border, format, type, (const void*)elements(pixels));
}

void
GL::glTexImage1D (jint target, jint level, jint internalFormat, jint width, jint border, jint format, jint type, jbyteArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage1D(target, level, internalFormat, width, border, format, type, (const void*)elements(pixels));
}

void
GL::glTexImage1D (jint target, jint level, jint internalFormat, jint width, jint border, jint format, jint type, jshortArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage1D(target, level, internalFormat, width, border, format, type, (const void*)elements(pixels));
}

void
GL::glTexImage1D (jint target, jint level, jint internalFormat, jint width, jint border, jint format, jint type, jintArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage1D(target, level, internalFormat, width, border, format, type, (const void*)elements(pixels));
}


void
GL::glTexImage2D (jint target, jint level, jint internalFormat, jint width, jint height, jint border, jint format, jint type, jfloatArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage2D(target, level, internalFormat, width, height, border, format, type, (const void*)elements(pixels));
}

void
GL::glTexImage2D (jint target, jint level, jint internalFormat, jint width, jint height, jint border, jint format, jint type, jbyteArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage2D(target, level, internalFormat, width, height, border, format, type, (const void*)elements(pixels));
}

void
GL::glTexImage2D (jint target, jint level, jint internalFormat, jint width, jint height, jint border, jint format, jint type, jshortArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage2D(target, level, internalFormat, width, height, border, format, type, (const void*)elements(pixels));
}

void
GL::glTexImage2D (jint target, jint level, jint internalFormat, jint width, jint height, jint border, jint format, jint type, jintArray pixels)
{
	JvInitClass(&GL::class$);
	::glTexImage2D(target, level, internalFormat, width, height, border, format, type, (const void*)elements(pixels));
}


void
GL::glGetTexImage (jint target, jint level, jint format, jint type, jfloatArray pixels)
{
	JvInitClass(&GL::class$);
	::glGetTexImage(target, level, format, type, elements(pixels));
}

void
GL::glGetTexImage (jint target, jint level, jint format, jint type, jbyteArray pixels)
{
	JvInitClass(&GL::class$);
	::glGetTexImage(target, level, format, type, elements(pixels));
}

void
GL::glGetTexImage (jint target, jint level, jint format, jint type, jshortArray pixels)
{
	JvInitClass(&GL::class$);
	::glGetTexImage(target, level, format, type, elements(pixels));
}

void
GL::glGetTexImage (jint target, jint level, jint format, jint type, jintArray pixels)
{
	JvInitClass(&GL::class$);
	::glGetTexImage(target, level, format, type, elements(pixels));
}


// 1.1 functions 
jint
GL::glGenTexture ()
{
	JvInitClass(&GL::class$);
	GLuint texture;
	::glGenTextures(1, &texture);
	return (jint)texture;
}

void
GL::glGenTextures (jint n, jintArray textureNameArray)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(textureNameArray) < n) throw createArraySizeException();
	GLuint* textures = (GLuint*)elements(textureNameArray);
	::glGenTextures(n, textures);
}

void
GL::glDeleteTexture (jint texture)
{
	JvInitClass(&GL::class$);
	::glDeleteTextures(1, (const GLuint*)&texture);
}

void
GL::glDeleteTextures (jint n, jintArray textureNameArray)
{
	JvInitClass(&GL::class$);
	if (JvGetArrayLength(textureNameArray) < n) throw createArraySizeException();
	GLuint* textures = (GLuint*)elements(textureNameArray);
	::glDeleteTextures(n, textures);
}

void
GL::glBindTexture (jint target, jint texture)
{
	JvInitClass(&GL::class$);
	::glBindTexture(target, texture);
}


/************************************************************
void
GL::glPrioritizeTextures (jint, jlongArray, jfloatArray)
{
	JvInitClass(&GL::class$);
}


jbyte
GL::glAreTexturesResident (jint, jlongArray, jbyteArray)
{
	JvInitClass(&GL::class$);
}


jbyte
GL::glIsTexture (jlong)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexSubImage1D (jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexSubImage2D (jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyTexImage1D (jint, jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyTexImage2D (jint, jint, jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyTexSubImage1D (jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyTexSubImage2D (jint, jint, jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMap1d (jint, jdouble, jdouble, jint, jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMap1f (jint, jfloat, jfloat, jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMap2d (jint, jdouble, jdouble, jint, jint, jdouble, jdouble, jint, jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMap2f (jint, jfloat, jfloat, jint, jint, jfloat, jfloat, jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetMapdv (jint, jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetMapfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetMapiv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord1d (jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord1f (jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord1dv (jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord1fv (jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord2d (jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord2f (jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord2dv (jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalCoord2fv (jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMapGrid1d (jint, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMapGrid1f (jint, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMapGrid2d (jint, jdouble, jdouble, jint, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMapGrid2f (jint, jfloat, jfloat, jint, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalPoint1 (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalPoint2 (jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalMesh1 (jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glEvalMesh2 (jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glFogf (jint, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glFogi (jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glFogfv (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glFogiv (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glFeedbackBuffer (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glPassThrough (jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glSelectBuffer (jint, jlongArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glInitNames ()
{
	JvInitClass(&GL::class$);
}


void
GL::glLoadName (jlong)
{
	JvInitClass(&GL::class$);
}


void
GL::glPushName (jlong)
{
	JvInitClass(&GL::class$);
}


void
GL::glPopName ()
{
	JvInitClass(&GL::class$);
}


void
GL::glDrawRangeElements (jint, jlong, jlong, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexImage3D (jint, jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexSubImage3D (jint, jint, jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyTexSubImage3D (jint, jint, jint, jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorTable (jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorSubTable (jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorTableParameteriv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorTableParameterfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyColorSubTable (jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyColorTable (jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetColorTable (jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetColorTableParameterfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetColorTableParameteriv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glBlendEquation (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glBlendColor (jfloat, jfloat, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glHistogram (jint, jint, jint, jbyte)
{
	JvInitClass(&GL::class$);
}


void
GL::glResetHistogram (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetHistogram (jint, jbyte, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetHistogramParameterfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetHistogramParameteriv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMinmax (jint, jint, jbyte)
{
	JvInitClass(&GL::class$);
}


void
GL::glResetMinmax (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetMinmax (jint, jbyte, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetMinmaxParameterfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetMinmaxParameteriv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glConvolutionFilter1D (jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glConvolutionFilter2D (jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glConvolutionParameterf (jint, jint, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glConvolutionParameterfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glConvolutionParameteri (jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glConvolutionParameteriv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyConvolutionFilter1D (jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyConvolutionFilter2D (jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetConvolutionFilter (jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetConvolutionParameterfv (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetConvolutionParameteriv (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glSeparableFilter2D (jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetSeparableFilter (jint, jint, jint, JArray< ::java::lang::Object *> *, JArray< ::java::lang::Object *> *, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glActiveTexture (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glClientActiveTexture (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glCompressedTexImage1D (jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCompressedTexImage2D (jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCompressedTexImage3D (jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCompressedTexSubImage1D (jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCompressedTexSubImage2D (jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCompressedTexSubImage3D (jint, jint, jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetCompressedTexImage (jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1d (jint, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1dv (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1f (jint, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1fv (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1i (jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1iv (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1s (jint, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1sv (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2d (jint, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2dv (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2f (jint, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2fv (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2i (jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2iv (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2s (jint, jshort, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2sv (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3d (jint, jdouble, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3dv (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3f (jint, jfloat, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3fv (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3i (jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3iv (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3s (jint, jshort, jshort, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3sv (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4d (jint, jdouble, jdouble, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4dv (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4f (jint, jfloat, jfloat, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4fv (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4i (jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4iv (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4s (jint, jshort, jshort, jshort, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4sv (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glLoadTransposeMatrixd ()
{
	JvInitClass(&GL::class$);
}


void
GL::glLoadTransposeMatrixf ()
{
	JvInitClass(&GL::class$);
}


void
GL::glMultTransposeMatrixd ()
{
	JvInitClass(&GL::class$);
}


void
GL::glMultTransposeMatrixf ()
{
	JvInitClass(&GL::class$);
}


void
GL::glSampleCoverage (jfloat, jbyte)
{
	JvInitClass(&GL::class$);
}


void
GL::glActiveTextureARB (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glClientActiveTextureARB (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1dARB (jint, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1dvARB (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1fARB (jint, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1fvARB (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1iARB (jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1ivARB (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1sARB (jint, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord1svARB (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2dARB (jint, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2dvARB (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2fARB (jint, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2fvARB (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2iARB (jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2ivARB (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2sARB (jint, jshort, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord2svARB (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3dARB (jint, jdouble, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3dvARB (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3fARB (jint, jfloat, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3fvARB (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3iARB (jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3ivARB (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3sARB (jint, jshort, jshort, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord3svARB (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4dARB (jint, jdouble, jdouble, jdouble, jdouble)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4dvARB (jint, jdoubleArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4fARB (jint, jfloat, jfloat, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4fvARB (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4iARB (jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4ivARB (jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4sARB (jint, jshort, jshort, jshort, jshort)
{
	JvInitClass(&GL::class$);
}


void
GL::glMultiTexCoord4svARB (jint, jshortArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glBlendColorEXT (jfloat, jfloat, jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glPolygonOffsetEXT (jfloat, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexImage3DEXT (jint, jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexSubImage3DEXT (jint, jint, jint, jint, jint, jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glCopyTexSubImage3DEXT (jint, jint, jint, jint, jint, jint, jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glGenTexturesEXT (jint, jlongArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glDeleteTexturesEXT (jint, jlongArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glBindTextureEXT (jint, jlong)
{
	JvInitClass(&GL::class$);
}


void
GL::glPrioritizeTexturesEXT (jint, jlongArray, jfloatArray)
{
	JvInitClass(&GL::class$);
}


jbyte
GL::glAreTexturesResidentEXT (jint, jlongArray, jbyteArray)
{
	JvInitClass(&GL::class$);
}


jbyte
GL::glIsTextureEXT (jlong)
{
	JvInitClass(&GL::class$);
}


void
GL::glVertexPointerEXT (jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glNormalPointerEXT (jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorPointerEXT (jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glIndexPointerEXT (jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glTexCoordPointerEXT (jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glEdgeFlagPointerEXT (jint, jint, jbyteArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetPointervEXT (jint, JArray<JArray< ::java::lang::Object *> *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glArrayElementEXT (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glDrawArraysEXT (jint, jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glBlendEquationEXT (jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glPointParameterfEXT (jint, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glPointParameterfvEXT (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glPointParameterfSGIS (jint, jfloat)
{
	JvInitClass(&GL::class$);
}


void
GL::glPointParameterfvSGIS (jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorTableEXT (jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glColorSubTableEXT (jint, jint, jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetColorTableEXT (jint, jint, jint, JArray< ::java::lang::Object *> *)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetColorTableParameterfvEXT (jint, jint, jfloatArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glGetColorTableParameterivEXT (jint, jint, jintArray)
{
	JvInitClass(&GL::class$);
}


void
GL::glLockArraysEXT (jint, jint)
{
	JvInitClass(&GL::class$);
}


void
GL::glUnlockArraysEXT ()
{
	JvInitClass(&GL::class$);
}


************************************************************/
