package gl4gcj;
/** \mainpage
* gl4gcj is a GCJ(http://gcc.gnu.org/java/) Java binding to OpenGL.
* 
* Packages:
* <dl>
*   <dt> gl4gcj </dt>
*   <dd> OpenGL gcj binding.</dd>
*   <dt> glut4gcj</dt>
*   <dd> GLUT gcj binding.</dd>
* </dl>
**/

public class GL implements GLConstants
{
	// Miscellaneous
	public static native void glClearIndex(float c);
	public static native void glClearColor(float red, float green, float blue, float alpha);
	public static void glClearColor(double red, double green, double blue, double alpha)
	{
		glClearColor((float)red, (float)green, (float)blue, (float)alpha);
	}
	public static native void glClear(int mask);
	public static native void glIndexMask(long mask);
	public static native void glColorMask(boolean red,  boolean green,  boolean blue,  boolean alpha);
	public static native void glAlphaFunc(int func,  float ref);
	public static native void glBlendFunc(int sfactor, int dfactor);
	public static native void glLogicOp(int opcode);
	public static native void glCullFace(int mode);
	public static native void glFrontFace(int mode);
	public static native void glPointSize(float size);
	public static native void glLineWidth(float width);
	public static native void glLineStipple(int factor,  short pattern);
	public static native void glPolygonMode(int face, int mode);
	public static native void glPolygonOffset(float factor, float units);
	public static native void glPolygonStipple(byte[] mask);
	public static native void glGetPolygonStipple(byte[] mask);
	public static native void glEdgeFlag(boolean flag);
	public static native void glEdgeFlagv(boolean[] flags);
	public static native void glScissor(int x, int y, int width, int height);
	public static native void glClipPlane(int plane, double[] equation);
	public static native void glGetClipPlane(int plane, double[] equation);
	public static native void glDrawBuffer(int mode);
	public static native void glReadBuffer(int mode);
	public static native void glEnable(int cap);
	public static native void glDisable(int cap);
	public static native boolean glIsEnabled(int cap);
	public static native void glEnableClientState(int cap);
	public static native void glDisableClientState(int cap);
	public static native boolean[] glGetBooleanv(int pname);
	/*
	public static native void glGetDoublev(int pname,  double[] params);
	public static native void glGetFloatv(int pname,  float[] params);
	public static native void glGetIntegerv(int pname,  int[] params);
	*/
	public static native void glPushAttrib(int mask);
	public static native void glPopAttrib();
	public static native void glPushClientAttrib(int mask);
	public static native void glPopClientAttrib();
	public static native int glRenderMode(int mode);

	public static native int glGetError();
	public static String glGetErrorString()
	{
		return glGetErrorString(glGetError());
	}
	public static String glGetErrorString(int id)
	{
		String string = "GL_NO_ERROR";
		switch (id)
		{
			case GL_INVALID_ENUM :
				string = "GL_INVALID_ENUM";
				break;
			case GL_INVALID_VALUE :
				string = "GL_INVALID_VALUE";
				break;
			case GL_INVALID_OPERATION :
				string = "GL_INVALID_OPERATION";
				break;
			case GL_STACK_OVERFLOW :
				string = "GL_STACK_OVERFLOW";
				break;
			case GL_STACK_UNDERFLOW :
				string = "GL_STACK_UNDERFLOW";
				break;
			case GL_OUT_OF_MEMORY :
				string = "GL_OUT_OF_MEMORY";
				break;
			case GL_TABLE_TOO_LARGE :
				string = "GL_TABLE_TOO_LARGE";
				break;
			default:
				break;
		}
		return string;
	}

	public static native String glGetString(int name);
	public static native void glFinish();
	public static native void glFlush();
	public static native void glHint(int target, int mode);

	// Depth Buffer
	public static native void glClearDepth(double depth);
	public static native void glDepthFunc(int func);
	public static native void glDepthMask(boolean flag);
	public static native void glDepthRange(double near_val, double far_val);

	// Accumulation Buffer
	public static native void glClearAccum(float red, float green, float blue, float alpha);
	public static native void glAccum(int op, float value);

	// Transformation
	public static native void glMatrixMode(int mode);
	public static native void glOrtho(double left, double right, double bottom, double top, double near_val, double far_val);
	public static native void glFrustum(double left, double right, double bottom, double top, double near_val, double far_val);
	public static native void glViewport(int x, int y, int width, int height);
	public static native void glPushMatrix();
	public static native void glPopMatrix();
	public static native void glLoadIdentity();
	public static native void glLoadMatrixd(double[] m);
	public static native void glLoadMatrixf(float[] m);
	public static native void glMultMatrixd(double[] m);
	public static native void glMultMatrixf(float[] m);
	public static native void glRotated(double angle, double x, double y, double z);
	public static native void glRotatef(float angle, float x, float y, float z);
	public static native void glScaled(double x, double y, double z);
	public static native void glScalef(float x, float y, float z);
	public static native void glTranslated(double x, double y, double z);
	public static native void glTranslatef(float x, float y, float z);

	// Display Lists
	public static native boolean glIsList(long list);
	public static native void glDeleteLists(long list, int range);
	public static native long glGenLists(int range);
	public static native void glNewList(long list, int mode);
	public static native void glEndList();
	public static native void glCallList(long list);

	public static native void glCallLists(byte[] lists);
	public static native void glCallLists(short[] lists);
	public static native void glCallLists(int[] lists);

	public static native void glListBase(long base);

	// Drawing Functions
	public static native void glBegin(int mode);
	public static native void glEnd();

	public static native void glVertex2d(double x, double y);
	public static native void glVertex2f(float x, float y);
	public static native void glVertex2i(int x, int y);
	public static native void glVertex2s(short x, short y);
	public static native void glVertex3d(double x, double y, double z);
	public static native void glVertex3f(float x, float y, float z);
	public static native void glVertex3i(int x, int y, int z);
	public static native void glVertex3s(short x, short y, short z);
	public static native void glVertex4d(double x, double y, double z, double w);
	public static native void glVertex4f(float x, float y, float z, float w);
	public static native void glVertex4i(int x, int y, int z, int w);
	public static native void glVertex4s(short x, short y, short z, short w);
	
	public static native void glVertex2dv(double[] v);
	public static native void glVertex2fv(float[] v);
	public static native void glVertex2iv(int[] v);
	public static native void glVertex2sv(short[] v);
	public static native void glVertex3dv(double[] v);
	public static native void glVertex3fv(float[] v);
	public static native void glVertex3iv(int[] v);
	public static native void glVertex3sv(short[] v);
	public static native void glVertex4dv(double[] v);
	public static native void glVertex4fv(float[] v);
	public static native void glVertex4iv(int[] v);
	public static native void glVertex4sv(short[] v);

	public static native void glNormal3b(byte nx, byte ny, byte nz);
	public static native void glNormal3d(double nx, double ny, double nz);
	public static native void glNormal3f(float nx, float ny, float nz);
	public static native void glNormal3i(int nx, int ny, int nz);
	public static native void glNormal3s(short nx, short ny, short nz);
	public static native void glNormal3bv(byte[] v);
	public static native void glNormal3dv(double[] v);
	public static native void glNormal3fv(float[] v);
	public static native void glNormal3iv(int[] v);
	public static native void glNormal3sv(short[] v);

	public static native void glIndexd(double c);
	public static native void glIndexf(float c);
	public static native void glIndexi(int c);
	public static native void glIndexs(short c);
	public static native void glIndexub(short c);
	/*
	// need?
	public static native void glIndexdv(double[] c);
	public static native void glIndexfv(float[] c);
	public static native void glIndexiv(int[] c);
	public static native void glIndexsv(short[] c);
	public static native void glIndexubv(short[] c);
	*/

	public static native void glColor3b(byte red, byte green, byte blue);
	public static native void glColor3d(double red, double green, double blue);
	public static native void glColor3f(float red, float green, float blue);
	public static native void glColor3i(int red, int green, int blue);
	public static native void glColor3s(short red, short green, short blue);
	public static native void glColor3ub(short red, short green, short blue);
	public static native void glColor3ui(long red, long green, long blue);
	public static native void glColor3us(int red, int green, int blue);
	public static native void glColor4b(byte red, byte green, byte blue, byte alpha);
	public static native void glColor4d(double red, double green, double blue, double alpha);
	public static native void glColor4f(float red, float green, float blue, float alpha);
	public static native void glColor4i(int red, int green, int blue, int alpha);
	public static native void glColor4s(short red, short green, short blue, short alpha);
	public static native void glColor4ub(short red, short green, short blue, short alpha);
	public static native void glColor4ui(long red, long green, long blue, long alpha);
	public static native void glColor4us(int red, int green, int blue, int alpha);

	public static native void glColor3bv(byte[] v);
	public static native void glColor3dv(double[] v);
	public static native void glColor3fv(float[] v);
	public static native void glColor3iv(int[] v);
	public static native void glColor3sv(short[] v);
	public static native void glColor3ubv(byte[] v);
	public static native void glColor3uiv(int[] v);
	public static native void glColor3usv(short[] v);
	public static native void glColor4bv(byte[] v);
	public static native void glColor4dv(double[] v);
	public static native void glColor4fv(float[] v);
	public static native void glColor4iv(int[] v);
	public static native void glColor4sv(short[] v);
	public static native void glColor4ubv(byte[] v);
	public static native void glColor4uiv(int[] v);
	public static native void glColor4usv(short[] v);

	public static native void glTexCoord1d(double s);
	public static native void glTexCoord1f(float s);
	public static native void glTexCoord1i(int s);
	public static native void glTexCoord1s(short s);
	public static native void glTexCoord2d(double s, double t);
	public static native void glTexCoord2f(float s, float t);
	public static native void glTexCoord2i(int s, int t);
	public static native void glTexCoord2s(short s, short t);
	public static native void glTexCoord3d(double s, double t, double r);
	public static native void glTexCoord3f(float s, float t, float r);
	public static native void glTexCoord3i(int s, int t, int r);
	public static native void glTexCoord3s(short s, short t, short r);
	public static native void glTexCoord4d(double s, double t, double r, double q);
	public static native void glTexCoord4f(float s, float t, float r, float q);
	public static native void glTexCoord4i(int s, int t, int r, int q);
	public static native void glTexCoord4s(short s, short t, short r, short q);
	public static native void glTexCoord1dv(double[] v);
	public static native void glTexCoord1fv(float[] v);
	public static native void glTexCoord1iv(int[] v);
	public static native void glTexCoord1sv(short[] v);
	public static native void glTexCoord2dv(double[] v);
	public static native void glTexCoord2fv(float[] v);
	public static native void glTexCoord2iv(int[] v);
	public static native void glTexCoord2sv(short[] v);
	public static native void glTexCoord3dv(double[] v);
	public static native void glTexCoord3fv(float[] v);
	public static native void glTexCoord3iv(int[] v);
	public static native void glTexCoord3sv(short[] v);
	public static native void glTexCoord4dv(double[] v);
	public static native void glTexCoord4fv(float[] v);
	public static native void glTexCoord4iv(int[] v);
	public static native void glTexCoord4sv(short[] v);

	public static native void glRasterPos2d(double x, double y);
	public static native void glRasterPos2f(float x, float y);
	public static native void glRasterPos2i(int x, int y);
	public static native void glRasterPos2s(short x, short y);
	public static native void glRasterPos3d(double x, double y, double z);
	public static native void glRasterPos3f(float x, float y, float z);
	public static native void glRasterPos3i(int x, int y, int z);
	public static native void glRasterPos3s(short x, short y, short z);
	public static native void glRasterPos4d(double x, double y, double z, double w);
	public static native void glRasterPos4f(float x, float y, float z, float w);
	public static native void glRasterPos4i(int x, int y, int z, int w);
	public static native void glRasterPos4s(short x, short y, short z, short w);
	public static native void glRasterPos2dv(double[] v);
	public static native void glRasterPos2fv(float[] v);
	public static native void glRasterPos2iv(int[] v);
	public static native void glRasterPos2sv(short[] v);
	public static native void glRasterPos3dv(double[] v);
	public static native void glRasterPos3fv(float[] v);
	public static native void glRasterPos3iv(int[] v);
	public static native void glRasterPos3sv(short[] v);
	public static native void glRasterPos4dv(double[] v);
	public static native void glRasterPos4fv(float[] v);
	public static native void glRasterPos4iv(int[] v);
	public static native void glRasterPos4sv(short[] v);

	public static native void glRectd(double x1, double y1, double x2, double y2);
	public static native void glRectf(float x1, float y1, float x2, float y2);
	public static native void glRecti(int x1, int y1, int x2, int y2);
	public static native void glRects(short x1, short y1, short x2, short y2);
	public static native void glRectdv(double[] v1, double[] v2);
	public static native void glRectfv(float[] v1, float[] v2);
	public static native void glRectiv(int[] v1, int[] v2);
	public static native void glRectsv(short[] v1, short[] v2);

	// Vertex Arrays
	public static native void glVertexPointer(int size, short[] vertexArray);
	public static native void glVertexPointer(int size, int[] vertexArray);
	public static native void glVertexPointer(int size, float[] vertexArray);
	public static native void glVertexPointer(int size, double[] vertexArray);

	public static native void glNormalPointer(byte[] normalArray);
	public static native void glNormalPointer(short[] normalArray);
	public static native void glNormalPointer(int[] normalArray);
	public static native void glNormalPointer(float[] normalArray);
	public static native void glNormalPointer(double[] normalArray);

	public static native void glColorPointer(int size, byte[] colorArray);
	public static native void glColorPointer(int size, short[] colorArray);
	public static native void glColorPointer(int size, int[] colorArray);
	public static native void glColorPointer(int size, double[] colorArray);
	public static native void glColorPointer(int size, float[] colorArray);

	public static native void glIndexPointer(byte[] indexArray);
	public static native void glIndexPointer(short[] indexArray);
	public static native void glIndexPointer(int[] indexArray);
	public static native void glIndexPointer(float[] indexArray);
	public static native void glIndexPointer(double[] indexArray);

	public static native void glTexCoordPointer(int size, short[] texCoordArray);
	public static native void glTexCoordPointer(int size, int[] texCoordArray);
	public static native void glTexCoordPointer(int size, float[] texCoordArray);
	public static native void glTexCoordPointer(int size, double[] texCoordArray);

	public static native void glEdgeFlagPointer(boolean[] edgeFlagArray);

/*
	public static native void glGetPointerv(int pname, Object[][] params);
*/
	public static native void glArrayElement(int i);
	public static native void glDrawArrays(int mode, int first, int count);

	public static native void glDrawElements(int mode, byte[] indices);
	public static native void glDrawElements(int mode, short[] indices);
	public static native void glDrawElements(int mode, int[] indices);
/*
	public static native void glInterleavedArrays(int format, int stride, Object[] pointer);
*/

	// Lighting
	public static native void glShadeModel(int mode);
	public static native void glLightf(int light, int pname, float param);
	public static native void glLighti(int light, int pname, int param);
	public static native void glLightfv(int light, int pname, float[] params);
	public static native void glLightiv(int light, int pname, int[] params);
	public static native void glGetLightfv(int light, int pname, float[] params);
	public static native void glGetLightiv(int light, int pname, int[] params);
	public static native void glLightModelf(int pname, float param);
	public static native void glLightModeli(int pname, int param);
	public static native void glLightModelfv(int pname, float[] params);
	public static native void glLightModeliv(int pname, int[] params);

	public static native void glMaterialf(int face, int pname, float param);
	public static native void glMateriali(int face, int pname, int param);
	public static native void glMaterialfv(int face, int pname, float[] params);
	public static native void glMaterialiv(int face, int pname, int[] params);
	public static native void glGetMaterialfv(int face, int pname, float[] params);
	public static native void glGetMaterialiv(int face, int pname, int[] params);
	public static native void glColorMaterial(int face, int mode);

	// Raster functions
	public static native void glPixelZoom(float xfactor,float yfactor);
	public static native void glPixelStoref(int pname,float param);
	public static native void glPixelStorei(int pname,int param);
	public static native void glPixelTransferf(int pname,float param);
	public static native void glPixelTransferi(int pname,int param);

	//?? warning...  no values size check
	public static native void glPixelMapfv(int map, float[] values);
	public static native void glPixelMapuiv(int map, int[] values);
	public static native void glPixelMapusv(int map, short[] values);

	//?? dangerous...  no values size check
	public static native void glGetPixelMapfv(int map, float[] values);
	public static native void glGetPixelMapuiv(int map, int[] values);
	public static native void glGetPixelMapusv(int map, short[] values);

	public static native void glBitmap(int width, int height, float xorig, float yorig, float xmove, float ymove, byte[] bitmap);

	//?? dangerous...  no pixels size check
	public static native void glReadPixels(int x, int y, int width, int height, int format, int type, float[] pixels);
	public static native void glReadPixels(int x, int y, int width, int height, int format, int type, byte[] pixels);
	public static native void glReadPixels(int x, int y, int width, int height, int format, int type, short[] pixels);
	public static native void glReadPixels(int x, int y, int width, int height, int format, int type, int[] pixels);

	//?? warning...  no values size check
	public static native void glDrawPixels(int width, int height, int format, int type, float[] pixels);
	public static native void glDrawPixels(int width, int height, int format, int type, byte[] pixels);
	public static native void glDrawPixels(int width, int height, int format, int type, short[] pixels);
	public static native void glDrawPixels(int width, int height, int format, int type, int[] pixels);

	public static native void glCopyPixels(int x, int y, int width, int height, int bufferType);

	// stenciling
	public static native void glStencilFunc(int func, int ref, int mask);
	public static native void glStencilMask(int mask);
	public static native void glStencilOp(int fail, int zfail, int zpass);
	public static native void glClearStencil(int s);

	// Texture mapping
	public static native void glTexGend(int coord, int pname, double param);
	public static native void glTexGenf(int coord, int pname, float param);
	public static native void glTexGeni(int coord, int pname, int param);

	//?? warning...  no checking size of params.
	public static native void glTexGendv(int coord, int pname, double[] params);
	public static native void glTexGenfv(int coord, int pname, float[] params);
	public static native void glTexGeniv(int coord, int pname, int[] params);

	//?? dangerous...  no checking size of params.
	public static native void glGetTexGendv(int coord, int pname, double[] params);
	public static native void glGetTexGenfv(int coord, int pname, float[] params);
	public static native void glGetTexGeniv(int coord, int pname, int[] params);

	public static native void glTexEnvf(int target, int pname, float param);
	public static native void glTexEnvi(int target, int pname, int param);

	//?? warning...  no checking size of params.
	public static native void glTexEnvfv(int target, int pname, float[] params);
	public static native void glTexEnviv(int target, int pname, int[] params);

	//?? dangerous...  no checking size of params.
	public static native void glGetTexEnvfv(int target, int pname, float[] params);
	public static native void glGetTexEnviv(int target, int pname, int[] params);

	public static native void glTexParameterf(int target, int pname, float param);
	public static native void glTexParameteri(int target, int pname, int param);

	//?? warning...  no checking size of params.
	public static native void glTexParameterfv(int target, int pname, float[] params);
	public static native void glTexParameteriv(int target, int pname, int[] params);

	//?? dangerous...  no checking size of params.
	public static native void glGetTexParameterfv(int target, int pname, float[] params);
	public static native void glGetTexParameteriv(int target, int pname, int[] params);
	public static native void glGetTexLevelParameterfv(int target, int level, int pname, float[] params);
	public static native void glGetTexLevelParameteriv(int target, int level, int pname, int[] params);

	//?? warning...  no checking size of pixels.
	public static native void glTexImage1D(int target, int level, int internalFormat, int width, int border, int format, int type, float[] pixels);
	public static native void glTexImage1D(int target, int level, int internalFormat, int width, int border, int format, int type, byte[] pixels);
	public static native void glTexImage1D(int target, int level, int internalFormat, int width, int border, int format, int type, short[] pixels);
	public static native void glTexImage1D(int target, int level, int internalFormat, int width, int border, int format, int type, int[] pixels);

	public static native void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, float[] pixels);
	public static native void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, byte[] pixels);
	public static native void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, short[] pixels);
	public static native void glTexImage2D(int target, int level, int internalFormat, int width, int height, int border, int format, int type, int[] pixels);

	//?? dangerous...  no checking size of pixels.
	public static native void glGetTexImage(int target, int level, int format, int type, float[] pixels);
	public static native void glGetTexImage(int target, int level, int format, int type, byte[] pixels);
	public static native void glGetTexImage(int target, int level, int format, int type, short[] pixels);
	public static native void glGetTexImage(int target, int level, int format, int type, int[] pixels);

	// 1.1 functions 
	public static native int glGenTexture();
	public static int[] glGenTextures(int num)
	{
		int[] texstureNameArray = new int[num];
		glGenTextures(num, texstureNameArray);
		return texstureNameArray;
	}
	public static void glGenTextures(int[] texstureNameArray)
	{
		glGenTextures(texstureNameArray.length, texstureNameArray);
	}
	public static native void glGenTextures(int n, int[] texstureNameArray);

	public static native void glDeleteTexture(int texture);
	public static void glDeleteTextures(int[] texstureNameArray)
	{
		glDeleteTextures(texstureNameArray.length, texstureNameArray);
	}
	public static native void glDeleteTextures(int n, int[] texstureNameArray);
	public static native void glBindTexture(int target, int texture);

/*
	public static native void glPrioritizeTextures(int n, long[] textures, float[] priorities);
	public static native byte glAreTexturesResident(int n, long[] textures, byte[] residences);
	public static native byte glIsTexture(long texture);
	public static native void glTexSubImage1D(int target, int level, int xoffset, int width, int format, int type, Object[] pixels);
	public static native void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Object[] pixels);
	public static native void glCopyTexImage1D(int target, int level, int internalformat, int x, int y, int width, int border);
	public static native void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border);
	public static native void glCopyTexSubImage1D(int target, int level, int xoffset, int x, int y, int width);
	public static native void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height);
	public static native void glMap1d(int target, double u1, double u2, int stride, int order, double[] points);
	public static native void glMap1f(int target, float u1, float u2, int stride, int order, float[] points);
	public static native void glMap2d(int target, double u1, double u2, int ustride, int uorder, double v1, double v2, int vstride, int vorder, double[] points);
	public static native void glMap2f(int target, float u1, float u2, int ustride, int uorder, float v1, float v2, int vstride, int vorder, float[] points);
	public static native void glGetMapdv(int target, int query, double[] v);
	public static native void glGetMapfv(int target, int query, float[] v);
	public static native void glGetMapiv(int target, int query, int[] v);
	public static native void glEvalCoord1d(double u);
	public static native void glEvalCoord1f(float u);
	public static native void glEvalCoord1dv(double[] u);
	public static native void glEvalCoord1fv(float[] u);
	public static native void glEvalCoord2d(double u, double v);
	public static native void glEvalCoord2f(float u, float v);
	public static native void glEvalCoord2dv(double[] u);
	public static native void glEvalCoord2fv(float[] u);
	public static native void glMapGrid1d(int un, double u1, double u2);
	public static native void glMapGrid1f(int un, float u1, float u2);
	public static native void glMapGrid2d(int un, double u1, double u2, int vn, double v1, double v2);
	public static native void glMapGrid2f(int un, float u1, float u2, int vn, float v1, float v2);
	public static native void glEvalPoint1(int i);
	public static native void glEvalPoint2(int i, int j);
	public static native void glEvalMesh1(int mode, int i1, int i2);
	public static native void glEvalMesh2(int mode, int i1, int i2, int j1, int j2);
	public static native void glFogf(int pname, float param);
	public static native void glFogi(int pname, int param);
	public static native void glFogfv(int pname, float[] params);
	public static native void glFogiv(int pname, int[] params);
	public static native void glFeedbackBuffer(int size, int type, float[] buffer);
	public static native void glPassThrough(float token);
	public static native void glSelectBuffer(int size, long[] buffer);
	public static native void glInitNames();
	public static native void glLoadName(long name);
	public static native void glPushName(long name);
	public static native void glPopName();

	// OpenGL 1.2
	public static native void glDrawRangeElements(int mode, long start, long end, int count, int type, Object[] indices);
	public static native void glTexImage3D(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, Object[] pixels);
	public static native void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, Object[] pixels);
	public static native void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);

	// GL_ARB_imaging
	public static native void glColorTable(int target, int internalformat, int width, int format, int type, Object[] table);
	public static native void glColorSubTable(int target, int start, int count, int format, int type, Object[] data);
	public static native void glColorTableParameteriv(int target, int pname, int[] params);
	public static native void glColorTableParameterfv(int target, int pname, float[] params);
	public static native void glCopyColorSubTable(int target, int start, int x, int y, int width);
	public static native void glCopyColorTable(int target, int internalformat, int x, int y, int width);
	public static native void glGetColorTable(int target, int format, int type, Object[] table);
	public static native void glGetColorTableParameterfv(int target, int pname, float[] params);
	public static native void glGetColorTableParameteriv(int target, int pname, int[] params);
	public static native void glBlendEquation(int mode);
	public static native void glBlendColor(float red, float green, float blue, float alpha);
	public static native void glHistogram(int target, int width, int internalformat, byte sink);
	public static native void glResetHistogram(int target);
	public static native void glGetHistogram(int target, byte reset, int format, int type, Object[] values);
	public static native void glGetHistogramParameterfv(int target, int pname, float[] params);
	public static native void glGetHistogramParameteriv(int target, int pname, int[] params);
	public static native void glMinmax(int target, int internalformat, byte sink);
	public static native void glResetMinmax(int target);
	public static native void glGetMinmax(int target, byte reset, int format, int types, Object[] values);
	public static native void glGetMinmaxParameterfv(int target, int pname, float[] params);
	public static native void glGetMinmaxParameteriv(int target, int pname, int[] params);
	public static native void glConvolutionFilter1D(int target, int internalformat, int width, int format, int type, Object[] image);
	public static native void glConvolutionFilter2D(int target, int internalformat, int width, int height, int format, int type, Object[] image);
	public static native void glConvolutionParameterf(int target, int pname, float params);
	public static native void glConvolutionParameterfv(int target, int pname, float[] params);
	public static native void glConvolutionParameteri(int target, int pname, int params);
	public static native void glConvolutionParameteriv(int target, int pname, int[] params);
	public static native void glCopyConvolutionFilter1D(int target, int internalformat, int x, int y, int width);
	public static native void glCopyConvolutionFilter2D(int target, int internalformat, int x, int y, int width, int height);
	public static native void glGetConvolutionFilter(int target, int format, int type, Object[] image);
	public static native void glGetConvolutionParameterfv(int target, int pname, float[] params);
	public static native void glGetConvolutionParameteriv(int target, int pname, int[] params);
	public static native void glSeparableFilter2D(int target, int internalformat, int width, int height, int format, int type, Object[] row, Object[] column);
	public static native void glGetSeparableFilter(int target, int format, int type, Object[] row, Object[] column, Object[] span);

	// OpenGL 1.3
	public static native void glActiveTexture(int texture);
	public static native void glClientActiveTexture(int texture);
	public static native void glCompressedTexImage1D(int target, int level, int internalformat, int width, int border, int imageSize, Object[] data);
	public static native void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Object[] data);
	public static native void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, Object[] data);
	public static native void glCompressedTexSubImage1D(int target, int level, int xoffset, int width, int format, int imageSize, Object[] data);
	public static native void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Object[] data);
	public static native void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, Object[] data);
	public static native void glGetCompressedTexImage(int target, int lod, Object[] img);
	public static native void glMultiTexCoord1d(int target, double s);
	public static native void glMultiTexCoord1dv(int target, double[] v);
	public static native void glMultiTexCoord1f(int target, float s);
	public static native void glMultiTexCoord1fv(int target, float[] v);
	public static native void glMultiTexCoord1i(int target, int s);
	public static native void glMultiTexCoord1iv(int target, int[] v);
	public static native void glMultiTexCoord1s(int target, short s);
	public static native void glMultiTexCoord1sv(int target, short[] v);
	public static native void glMultiTexCoord2d(int target, double s, double t);
	public static native void glMultiTexCoord2dv(int target, double[] v);
	public static native void glMultiTexCoord2f(int target, float s, float t);
	public static native void glMultiTexCoord2fv(int target, float[] v);
	public static native void glMultiTexCoord2i(int target, int s, int t);
	public static native void glMultiTexCoord2iv(int target, int[] v);
	public static native void glMultiTexCoord2s(int target, short s, short t);
	public static native void glMultiTexCoord2sv(int target, short[] v);
	public static native void glMultiTexCoord3d(int target, double s, double t, double r);
	public static native void glMultiTexCoord3dv(int target, double[] v);
	public static native void glMultiTexCoord3f(int target, float s, float t, float r);
	public static native void glMultiTexCoord3fv(int target, float[] v);
	public static native void glMultiTexCoord3i(int target, int s, int t, int r);
	public static native void glMultiTexCoord3iv(int target, int[] v);
	public static native void glMultiTexCoord3s(int target, short s, short t, short r);
	public static native void glMultiTexCoord3sv(int target, short[] v);
	public static native void glMultiTexCoord4d(int target, double s, double t, double r, double q);
	public static native void glMultiTexCoord4dv(int target, double[] v);
	public static native void glMultiTexCoord4f(int target, float s, float t, float r, float q);
	public static native void glMultiTexCoord4fv(int target, float[] v);
	public static native void glMultiTexCoord4i(int target, int s, int t, int r, int q);
	public static native void glMultiTexCoord4iv(int target, int[] v);
	public static native void glMultiTexCoord4s(int target, short s, short t, short r, short q);
	public static native void glMultiTexCoord4sv(int target, short[] v);
	public static native void glLoadTransposeMatrixd();
	public static native void glLoadTransposeMatrixf();
	public static native void glMultTransposeMatrixd();
	public static native void glMultTransposeMatrixf();
	public static native void glSampleCoverage(float value, byte invert);

	// GL_ARB_multitexture 
	public static native void glActiveTextureARB(int texture);
	public static native void glClientActiveTextureARB(int texture);
	public static native void glMultiTexCoord1dARB(int target, double s);
	public static native void glMultiTexCoord1dvARB(int target, double[] v);
	public static native void glMultiTexCoord1fARB(int target, float s);
	public static native void glMultiTexCoord1fvARB(int target, float[] v);
	public static native void glMultiTexCoord1iARB(int target, int s);
	public static native void glMultiTexCoord1ivARB(int target, int[] v);
	public static native void glMultiTexCoord1sARB(int target, short s);
	public static native void glMultiTexCoord1svARB(int target, short[] v);
	public static native void glMultiTexCoord2dARB(int target, double s, double t);
	public static native void glMultiTexCoord2dvARB(int target, double[] v);
	public static native void glMultiTexCoord2fARB(int target, float s, float t);
	public static native void glMultiTexCoord2fvARB(int target, float[] v);
	public static native void glMultiTexCoord2iARB(int target, int s, int t);
	public static native void glMultiTexCoord2ivARB(int target, int[] v);
	public static native void glMultiTexCoord2sARB(int target, short s, short t);
	public static native void glMultiTexCoord2svARB(int target, short[] v);
	public static native void glMultiTexCoord3dARB(int target, double s, double t, double r);
	public static native void glMultiTexCoord3dvARB(int target, double[] v);
	public static native void glMultiTexCoord3fARB(int target, float s, float t, float r);
	public static native void glMultiTexCoord3fvARB(int target, float[] v);
	public static native void glMultiTexCoord3iARB(int target, int s, int t, int r);
	public static native void glMultiTexCoord3ivARB(int target, int[] v);
	public static native void glMultiTexCoord3sARB(int target, short s, short t, short r);
	public static native void glMultiTexCoord3svARB(int target, short[] v);
	public static native void glMultiTexCoord4dARB(int target, double s, double t, double r, double q);
	public static native void glMultiTexCoord4dvARB(int target, double[] v);
	public static native void glMultiTexCoord4fARB(int target, float s, float t, float r, float q);
	public static native void glMultiTexCoord4fvARB(int target, float[] v);
	public static native void glMultiTexCoord4iARB(int target, int s, int t, int r, int q);
	public static native void glMultiTexCoord4ivARB(int target, int[] v);
	public static native void glMultiTexCoord4sARB(int target, short s, short t, short r, short q);
	public static native void glMultiTexCoord4svARB(int target, short[] v);

	public static native void glBlendColorEXT(float red, float green, float blue, float alpha);
	public static native void glPolygonOffsetEXT(float factor, float bias);
	public static native void glTexImage3DEXT(int target, int level, int internalFormat, int width, int height, int depth, int border, int format, int type, Object[] pixels);
	public static native void glTexSubImage3DEXT(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, Object[] pixels);
	public static native void glCopyTexSubImage3DEXT(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height);
	public static native void glGenTexturesEXT(int n, long[] textures);
	public static native void glDeleteTexturesEXT(int n, long[] textures);
	public static native void glBindTextureEXT(int target, long texture);
	public static native void glPrioritizeTexturesEXT(int n, long[] textures, float[] priorities);
	public static native byte glAreTexturesResidentEXT(int n, long[] textures, byte[] residences);
	public static native byte glIsTextureEXT(long texture);
	public static native void glVertexPointerEXT(int size, int type, int stride, int count, Object[] ptr);
	public static native void glNormalPointerEXT(int type, int stride, int count, Object[] ptr);
	public static native void glColorPointerEXT(int size, int type, int stride, int count, Object[] ptr);
	public static native void glIndexPointerEXT(int type, int stride, int count, Object[] ptr);
	public static native void glTexCoordPointerEXT(int size, int type, int stride, int count, Object[] ptr);
	public static native void glEdgeFlagPointerEXT(int stride, int count, byte[] ptr);
	public static native void glGetPointervEXT(int pname, Object[][] params);
	public static native void glArrayElementEXT(int i);
	public static native void glDrawArraysEXT(int mode, int first, int count);
	public static native void glBlendEquationEXT(int mode);
	public static native void glPointParameterfEXT(int pname, float param);
	public static native void glPointParameterfvEXT(int pname, float[] params);
	public static native void glPointParameterfSGIS(int pname, float param);
	public static native void glPointParameterfvSGIS(int pname, float[] params);
	public static native void glColorTableEXT(int target, int internalformat, int width, int format, int type, Object[] table);
	public static native void glColorSubTableEXT(int target, int start, int count, int format, int type, Object[] data);
	public static native void glGetColorTableEXT(int target, int format, int type, Object[] table);
	public static native void glGetColorTableParameterfvEXT(int target, int pname, float[] params);
	public static native void glGetColorTableParameterivEXT(int target, int pname, int[] params);
	public static native void glLockArraysEXT(int first, int count);
	public static native void glUnlockArraysEXT();
*/

}
