import gl4gcj.*;
import glut4gcj.*;

class EventTest extends GLUT implements 
	ButtonBoxFunc, DialsFunc, DisplayFunc,
	EntryFunc, JoystickFunc, KeyboardFunc,
	KeyboardUpFunc, MenuStateFunc,
	MenuStatusFunc, MotionFunc, MouseFunc,
	OverlayDisplayFunc, PassiveMotionFunc, ReshapeFunc,
	SpaceballButtonFunc, SpaceballMotionFunc, SpaceballRotateFunc,
	SpecialFunc, SpecialUpFunc, TabletButtonFunc,
	TabletMotionFunc, VisibilityFunc, WindowStatusFunc
{
	public void buttonBox(int button, int state)
	{
		System.out.println("button(" + button + ", " + state + ")");
	}

	public void dials(int dial, int value)
	{
		System.out.println("dials(" + dial + ", " + value + ")");
	}

	public void display()
	{
		System.out.println("display()");

		glClear(GL_COLOR_BUFFER_BIT);

		glColor3d(1.0, 0.0, 0.0);
		glRectd(-0.9, -0.9, 0.9, 0.9);

		glFlush();
	}

	public void entry(int state)
	{
		System.out.println("entry(" + state + ")");
	}

	public void joystick(int buttonMask, int x, int y, int z)
	{
		System.out.println("joystick(" + buttonMask + ", " + x + ", " + y + ", " + z + ")");
	}

	public void keyboard(byte key, int x, int y)
	{
		System.out.println("keyboard(" + (char)key + "," + x + ", " + y + ")");
		if (key == 'q' || key == 'Q' || key == '') System.exit(0);
	}

	public void keyboardUp(byte key, int x, int y)
	{
		System.out.println("keyboardUp(" + (char)key + "," + x + ", " + y + ")");
	}


	public void reshape(int width, int height)
	{
		System.out.println("reshape(" + width + ", " + height + ")");
		glViewport(0, 0, width, height);

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
	}

	public void menuState(int state)
	{
		System.out.println("menuState(" + state + ")");
	}

	public void menuStatus(int state, int x, int y)
	{
		System.out.println("menuStatus(" + state + ", " + x + "," + y + ")");
	}


	public void motion(int x, int y)
	{
		System.out.println("motion(" + x + "," + y + ")");
	}

	public void mouse(int button, int state, int x, int y)
	{
		System.out.println("mouse(" + button + "," + state + "," + x + "," + y + ")");
	}

	public void overlayDisplay()
	{
		System.out.println("overlayDisplay()");
	}

	public void passiveMotion( int x, int y)
	{
		System.out.println("passiveMotion(" + x + "," + y + ")");
	}

	public void spaceballButton(int button, int state)
	{
		System.out.println("spaceballButton(" + button + "," + state + ")");
	}

	public void spaceballMotion(int x, int y, int z)
	{
		System.out.println("spaceballMotion(" + x + "," + y + ", " + z + ")");
	}

	public void spaceballRotate(int x, int y, int z)
	{
		System.out.println("spaceballRotate(" + x + "," + y + ", " + z + ")");
	}

	public void special(int key, int x, int y)
	{
		System.out.println("special(" + key + "," + x + ", " + y + ")");
	}

	public void specialUp(int key, int x, int y)
	{
		System.out.println("specialUp(" + key + "," + x + ", " + y + ")");
	}

	public void tabletButton(int button, int state, int x, int y)
	{
		System.out.println("tabletButton(" + button + ", " + state + ", " + x + "," + y + ")");
	}

	public void tabletMotion(int x, int y)
	{
		System.out.println("tabletMotion(" + x + "," + y + ")");
	}

	public void visibility(int state)
	{
		System.out.println("visibility(" + state + ")");
	}

	public void windowStatus(int status)
	{
		System.out.println("windowStatus(" + status + ")");
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutCreateWindow("Event Test");

			EventTest test = new EventTest();

			glutButtonBoxFunc(test);
			glutDialsFunc(test);
			glutDisplayFunc(test);
			glutEntryFunc(test);
			glutJoystickFunc(test, 10);
			glutKeyboardFunc(test);
			glutKeyboardUpFunc(test);
			glutMenuStateFunc(test);
			glutMenuStatusFunc(test);
			glutMotionFunc(test);
			glutMouseFunc(test);
			glutOverlayDisplayFunc(test);
			glutPassiveMotionFunc(test);
			glutReshapeFunc(test);
			glutSpaceballButtonFunc(test);
			glutSpaceballMotionFunc(test);
			glutSpaceballRotateFunc(test);
			glutSpecialFunc(test);
			glutSpecialUpFunc(test);
			glutTabletButtonFunc(test);
			glutTabletMotionFunc(test);
			glutVisibilityFunc(test);
			glutWindowStatusFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
