import glut4gcj.*;

public class DrawPixels extends GLUT 
	implements DisplayFunc, KeyboardFunc, MouseFunc
{
	private float zoom = 1.0f;

	private void drawAxis()
	{
		glPushAttrib(GL_CURRENT_BIT);
		glColor3d(0.5, 0.5, 0.5);

		glBegin(GL_LINES);
		glVertex2d(-1.0,  0.0);
		glVertex2d( 1.0,  0.0);
		glVertex2d( 0.0, -1.0);
		glVertex2d( 0.0,  1.0);
		glEnd();

		glPopAttrib();
	}

	private void drawIcon()
	{
		glPushAttrib(GL_CURRENT_BIT);

		glColor3d(0.0, 1.0, 1.0);
		glRasterPos2i(0, 0);
		glDrawPixels(Icon.WIDTH, Icon.HEIGHT,
			Icon.FORMAT, Icon.TYPE, Icon.PIXELS);

		glPopAttrib();
	}
	
	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		drawAxis();
		drawIcon();

		glFlush();
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'z')
			this.zoom *= 1.1;
		else if (key == 'Z')
			this.zoom *= 0.9;
		glPixelZoom(this.zoom, this.zoom);
		glutPostRedisplay();
	}

	public void mouse(int button, int state, int x, int y)
	{
		if (state == GLUT_DOWN)
		{
			if (button == GLUT_LEFT_BUTTON)
				this.zoom *= 1.1;
			else if (button == GLUT_RIGHT_BUTTON)
				this.zoom *= 0.9;
			glPixelZoom(this.zoom, this.zoom);
			glutPostRedisplay();
		}
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutCreateWindow("glDrawPixels Test");

			DrawPixels test = new DrawPixels();
			glutDisplayFunc(test);
			glutKeyboardFunc(test);
			glutMouseFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
