import glut4gcj.*;

public class TextureTest extends GLUT 
	implements DisplayFunc, TimerFunc
{
	public static final int INTERVAL = 10;
	private int angle;

	public TextureTest()
	{
		this.angle = 0;

		glClearColor(0.0f, 0.0f, 0.0f, 0.0f);

		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		glEnable(GL_TEXTURE_2D);
		glTexImage2D(GL_TEXTURE_2D, 0,
			Icon.FORMAT, Icon.WIDTH, Icon.HEIGHT, 0,
			Icon.FORMAT, Icon.TYPE, Icon.PIXELS);

		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

		glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

		glMatrixMode(GL_MODELVIEW);
	}

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);
		glLoadIdentity();
		glRotated(this.angle, 1.0, 1.0, 0.0);

		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f);
			glVertex2f(-0.7f, -0.7f);
			glTexCoord2f(1.0f, 0.0f);
			glVertex2f( 0.7f, -0.7f);
			glTexCoord2f(1.0f, 1.0f);
			glVertex2f( 0.7f,  0.7f);
			glTexCoord2f(0.0f, 1.0f);
			glVertex2f(-0.7f,  0.7f);
		glEnd();

		glutSwapBuffers();
	}

	public void timer(int value)
	{
		this.angle = (this.angle + 1) % 360;
		glutPostRedisplay();
		glutTimerFunc(INTERVAL, this);
	}

	public static void main(String[] args)
	{
		glutInit(args);
		glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
		glutCreateWindow("Texture Test");

		TextureTest test = new TextureTest();
		glutDisplayFunc(test);
		glutTimerFunc(INTERVAL, test);

		glutMainLoop();
	}

}

