import glut4gcj.*;

class MenuTest extends GLUT implements 
	DisplayFunc, MenuFunc, TimerFunc
{
	static final String MESSAGE = "Click Right Button";

	static final int FILE_QUIT_ACTION = 1;
	static final int Z_ROTATE_START_ACTION = 2;
	static final int Z_ROTATE_STOP_ACTION = 3;
	static final int Y_ROTATE_START_ACTION = 4;
	static final int Y_ROTATE_STOP_ACTION = 5;
	static final int X_ROTATE_START_ACTION = 6;
	static final int X_ROTATE_STOP_ACTION = 7;

	private Rotater zRotater = new Rotater();
	private Rotater yRotater = new Rotater();
	private Rotater xRotater = new Rotater();

	public MenuTest()
	{
		int fileMenu = glutCreateMenu(this);
		glutAddMenuEntry("Quit", FILE_QUIT_ACTION);

		int zRotateMenu = glutCreateMenu(this);
		glutAddMenuEntry("Start", Z_ROTATE_START_ACTION);
		glutAddMenuEntry("Stop", Z_ROTATE_STOP_ACTION);

		int yRotateMenu = glutCreateMenu(this);
		glutAddMenuEntry("Start", Y_ROTATE_START_ACTION);
		glutAddMenuEntry("Stop", Y_ROTATE_STOP_ACTION);

		int xRotateMenu = glutCreateMenu(this);
		glutAddMenuEntry("Start", X_ROTATE_START_ACTION);
		glutAddMenuEntry("Stop", X_ROTATE_STOP_ACTION);

		int menu = glutCreateMenu(this);
		glutAddSubMenu("File", fileMenu);
		glutAddSubMenu("Z Rotation", zRotateMenu);
		glutAddSubMenu("Y Rotation", yRotateMenu);
		glutAddSubMenu("X Rotation", xRotateMenu);

		glutAttachMenu(GLUT_RIGHT_BUTTON);
	}

	public void display()
	{
		glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
		glClear(GL_COLOR_BUFFER_BIT);

		int messageLength = glutStrokeLength(GLUT_STROKE_ROMAN, MESSAGE);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glRotated(zRotater.getAngle(), 0.0, 0.0, 1.0);
		glRotated(yRotater.getAngle(), 0.0, 1.0, 0.0);
		glRotated(xRotater.getAngle(), 1.0, 0.0, 0.0);
		glScaled(1.8/messageLength, 1.8/messageLength, 1.0);
		glTranslated(-messageLength/2.0,  - 60.0, 0.0);
		glutStrokeCharacter(GLUT_STROKE_ROMAN, MESSAGE);

		glutSwapBuffers();
	}

	public void timer(int value)
	{
		glutPostRedisplay();
		glutTimerFunc(10, this);
	}

	class Rotater implements TimerFunc
	{
		private int waitTime;
		private int increment;
		private int angle = 0;
		private boolean done = false;

		public Rotater()
		{
			this(20, 2);
		}

		public Rotater(int msec, int increment)
		{
			this.waitTime = msec;
			this.increment = increment;
		}

		public void start()
		{
			this.done = false;
			glutTimerFunc(this.waitTime, this);
		}

		public void stop() { this.done = true; }

		public int getAngle() { return angle; }

		public void timer(int value)
		{
			this.angle = (this.angle + this.increment) % 360;
			if (!done) glutTimerFunc(this.waitTime, this);
		}
	}


	public void menu(int value)
	{
		switch (value)
		{
			case Z_ROTATE_START_ACTION :
				zRotater.start();
				break;
			case Z_ROTATE_STOP_ACTION :
				zRotater.stop();
				break;
			case Y_ROTATE_START_ACTION :
				yRotater.start();
				break;
			case Y_ROTATE_STOP_ACTION :
				yRotater.stop();
				break;
			case X_ROTATE_START_ACTION :
				xRotater.start();
				break;
			case X_ROTATE_STOP_ACTION :
				xRotater.stop();
				break;
			case FILE_QUIT_ACTION :
				System.exit(0);
				break;
			default:
				break;
		}
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB|GLUT_DOUBLE);
			glutCreateWindow("MenuTest");

			MenuTest window = new MenuTest();
			glutDisplayFunc(window);
			glutTimerFunc(30, window);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
