import glut4gcj.*;

public class BitmapString extends GLUT implements DisplayFunc
{
	static final double SIZE = 1.0;

	private void drawAxis()
	{
		glPushAttrib(GL_CURRENT_BIT);
		glColor3d(0.5, 0.5, 0.5);

		glBegin(GL_LINES);
		glVertex2d(-1.0,  0.0);
		glVertex2d( 1.0,  0.0);
		glVertex2d( 0.0, -1.0);
		glVertex2d( 0.0,  1.0);
		glEnd();

		glPopAttrib();
	}
	
	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		drawAxis();

		glRasterPos2i(0, 0);
		glColor3d(1.0, 1.0, 1.0);
//		System.out.println("w = " + glutBitmapWidth(GLUT_BITMAP_TIMES_ROMAN_24, "Hello, World!"));
//		System.out.println("w = " + glutBitmapLength(GLUT_BITMAP_TIMES_ROMAN_24, "Hello, World!"));
		glutBitmapCharacter(GLUT_BITMAP_TIMES_ROMAN_24, "Hello, World!");

		glFlush();
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutCreateWindow("glutBitmapCharacter() Test");

			BitmapString bitmapStringTest = new BitmapString();
			glutDisplayFunc(bitmapStringTest);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
