package gl4gcj;

public interface GLConstants
{
	// Data types 
	int GL_BYTE                            = 0x1400;
	int GL_UNSIGNED_BYTE                   = 0x1401;
	int GL_SHORT                           = 0x1402;
	int GL_UNSIGNED_SHORT                  = 0x1403;
	int GL_INT                             = 0x1404;
	int GL_UNSIGNED_INT                    = 0x1405;
	int GL_FLOAT                           = 0x1406;
	int GL_DOUBLE                          = 0x140A;
	int GL_2_BYTES                         = 0x1407;
	int GL_3_BYTES                         = 0x1408;
	int GL_4_BYTES                         = 0x1409;

	// Primitives
	int GL_POINTS                          = 0x0000;
	int GL_LINES                           = 0x0001;
	int GL_LINE_LOOP                       = 0x0002;
	int GL_LINE_STRIP                      = 0x0003;
	int GL_TRIANGLES                       = 0x0004;
	int GL_TRIANGLE_STRIP                  = 0x0005;
	int GL_TRIANGLE_FAN                    = 0x0006;
	int GL_QUADS                           = 0x0007;
	int GL_QUAD_STRIP                      = 0x0008;
	int GL_POLYGON                         = 0x0009;

	// Vertex Arrays 
	int GL_VERTEX_ARRAY                    = 0x8074;
	int GL_NORMAL_ARRAY                    = 0x8075;
	int GL_COLOR_ARRAY                     = 0x8076;
	int GL_INDEX_ARRAY                     = 0x8077;
	int GL_TEXTURE_COORD_ARRAY             = 0x8078;
	int GL_EDGE_FLAG_ARRAY                 = 0x8079;
	int GL_VERTEX_ARRAY_SIZE               = 0x807A;
	int GL_VERTEX_ARRAY_TYPE               = 0x807B;
	int GL_VERTEX_ARRAY_STRIDE             = 0x807C;
	int GL_NORMAL_ARRAY_TYPE               = 0x807E;
	int GL_NORMAL_ARRAY_STRIDE             = 0x807F;
	int GL_COLOR_ARRAY_SIZE                = 0x8081;
	int GL_COLOR_ARRAY_TYPE                = 0x8082;
	int GL_COLOR_ARRAY_STRIDE              = 0x8083;
	int GL_INDEX_ARRAY_TYPE                = 0x8085;
	int GL_INDEX_ARRAY_STRIDE              = 0x8086;
	int GL_TEXTURE_COORD_ARRAY_SIZE        = 0x8088;
	int GL_TEXTURE_COORD_ARRAY_TYPE        = 0x8089;
	int GL_TEXTURE_COORD_ARRAY_STRIDE      = 0x808A;
	int GL_EDGE_FLAG_ARRAY_STRIDE          = 0x808C;
	int GL_VERTEX_ARRAY_POINTER            = 0x808E;
	int GL_NORMAL_ARRAY_POINTER            = 0x808F;
	int GL_COLOR_ARRAY_POINTER             = 0x8090;
	int GL_INDEX_ARRAY_POINTER             = 0x8091;
	int GL_TEXTURE_COORD_ARRAY_POINTER     = 0x8092;
	int GL_EDGE_FLAG_ARRAY_POINTER         = 0x8093;
	int GL_V2F                             = 0x2A20;
	int GL_V3F                             = 0x2A21;
	int GL_C4UB_V2F                        = 0x2A22;
	int GL_C4UB_V3F                        = 0x2A23;
	int GL_C3F_V3F                         = 0x2A24;
	int GL_N3F_V3F                         = 0x2A25;
	int GL_C4F_N3F_V3F                     = 0x2A26;
	int GL_T2F_V3F                         = 0x2A27;
	int GL_T4F_V4F                         = 0x2A28;
	int GL_T2F_C4UB_V3F                    = 0x2A29;
	int GL_T2F_C3F_V3F                     = 0x2A2A;
	int GL_T2F_N3F_V3F                     = 0x2A2B;
	int GL_T2F_C4F_N3F_V3F                 = 0x2A2C;
	int GL_T4F_C4F_N3F_V4F                 = 0x2A2D;

	// Matrix Mode 
	int GL_MATRIX_MODE                     = 0x0BA0;
	int GL_MODELVIEW                       = 0x1700;
	int GL_PROJECTION                      = 0x1701;
	int GL_TEXTURE                         = 0x1702;

	// Points 
	int GL_POINT_SMOOTH                    = 0x0B10;
	int GL_POINT_SIZE                      = 0x0B11;
	int GL_POINT_SIZE_GRANULARITY          = 0x0B13;
	int GL_POINT_SIZE_RANGE                = 0x0B12;

	// Lines 
	int GL_LINE_SMOOTH                     = 0x0B20;
	int GL_LINE_STIPPLE                    = 0x0B24;
	int GL_LINE_STIPPLE_PATTERN            = 0x0B25;
	int GL_LINE_STIPPLE_REPEAT             = 0x0B26;
	int GL_LINE_WIDTH                      = 0x0B21;
	int GL_LINE_WIDTH_GRANULARITY          = 0x0B23;
	int GL_LINE_WIDTH_RANGE                = 0x0B22;

	// Polygons 
	int GL_POINT                           = 0x1B00;
	int GL_LINE                            = 0x1B01;
	int GL_FILL                            = 0x1B02;
	int GL_CW                              = 0x0900;
	int GL_CCW                             = 0x0901;
	int GL_FRONT                           = 0x0404;
	int GL_BACK                            = 0x0405;
	int GL_POLYGON_MODE                    = 0x0B40;
	int GL_POLYGON_SMOOTH                  = 0x0B41;
	int GL_POLYGON_STIPPLE                 = 0x0B42;
	int GL_EDGE_FLAG                       = 0x0B43;
	int GL_CULL_FACE                       = 0x0B44;
	int GL_CULL_FACE_MODE                  = 0x0B45;
	int GL_FRONT_FACE                      = 0x0B46;
	int GL_POLYGON_OFFSET_FACTOR           = 0x8038;
	int GL_POLYGON_OFFSET_UNITS            = 0x2A00;
	int GL_POLYGON_OFFSET_POINT            = 0x2A01;
	int GL_POLYGON_OFFSET_LINE             = 0x2A02;
	int GL_POLYGON_OFFSET_FILL             = 0x8037;

	// Display Lists 
	int GL_COMPILE                         = 0x1300;
	int GL_COMPILE_AND_EXECUTE             = 0x1301;
	int GL_LIST_BASE                       = 0x0B32;
	int GL_LIST_INDEX                      = 0x0B33;
	int GL_LIST_MODE                       = 0x0B30;

	// Depth buffer 
	int GL_NEVER                           = 0x0200;
	int GL_LESS                            = 0x0201;
	int GL_EQUAL                           = 0x0202;
	int GL_LEQUAL                          = 0x0203;
	int GL_GREATER                         = 0x0204;
	int GL_NOTEQUAL                        = 0x0205;
	int GL_GEQUAL                          = 0x0206;
	int GL_ALWAYS                          = 0x0207;
	int GL_DEPTH_TEST                      = 0x0B71;
	int GL_DEPTH_BITS                      = 0x0D56;
	int GL_DEPTH_CLEAR_VALUE               = 0x0B73;
	int GL_DEPTH_FUNC                      = 0x0B74;
	int GL_DEPTH_RANGE                     = 0x0B70;
	int GL_DEPTH_WRITEMASK                 = 0x0B72;
	int GL_DEPTH_COMPONENT                 = 0x1902;

	// Lighting 
	int GL_LIGHTING                        = 0x0B50;
	int GL_LIGHT0                          = 0x4000;
	int GL_LIGHT1                          = 0x4001;
	int GL_LIGHT2                          = 0x4002;
	int GL_LIGHT3                          = 0x4003;
	int GL_LIGHT4                          = 0x4004;
	int GL_LIGHT5                          = 0x4005;
	int GL_LIGHT6                          = 0x4006;
	int GL_LIGHT7                          = 0x4007;
	int GL_SPOT_EXPONENT                   = 0x1205;
	int GL_SPOT_CUTOFF                     = 0x1206;
	int GL_CONSTANT_ATTENUATION            = 0x1207;
	int GL_LINEAR_ATTENUATION              = 0x1208;
	int GL_QUADRATIC_ATTENUATION           = 0x1209;
	int GL_AMBIENT                         = 0x1200;
	int GL_DIFFUSE                         = 0x1201;
	int GL_SPECULAR                        = 0x1202;
	int GL_SHININESS                       = 0x1601;
	int GL_EMISSION                        = 0x1600;
	int GL_POSITION                        = 0x1203;
	int GL_SPOT_DIRECTION                  = 0x1204;
	int GL_AMBIENT_AND_DIFFUSE             = 0x1602;
	int GL_COLOR_INDEXES                   = 0x1603;
	int GL_LIGHT_MODEL_TWO_SIDE            = 0x0B52;
	int GL_LIGHT_MODEL_LOCAL_VIEWER        = 0x0B51;
	int GL_LIGHT_MODEL_AMBIENT             = 0x0B53;
	int GL_FRONT_AND_BACK                  = 0x0408;
	int GL_SHADE_MODEL                     = 0x0B54;
	int GL_FLAT                            = 0x1D00;
	int GL_SMOOTH                          = 0x1D01;
	int GL_COLOR_MATERIAL                  = 0x0B57;
	int GL_COLOR_MATERIAL_FACE             = 0x0B55;
	int GL_COLOR_MATERIAL_PARAMETER        = 0x0B56;
	int GL_NORMALIZE                       = 0x0BA1;

	// User clipping planes 
	int GL_CLIP_PLANE0                     = 0x3000;
	int GL_CLIP_PLANE1                     = 0x3001;
	int GL_CLIP_PLANE2                     = 0x3002;
	int GL_CLIP_PLANE3                     = 0x3003;
	int GL_CLIP_PLANE4                     = 0x3004;
	int GL_CLIP_PLANE5                     = 0x3005;

	// Accumulation buffer 
	int GL_ACCUM_RED_BITS                  = 0x0D58;
	int GL_ACCUM_GREEN_BITS                = 0x0D59;
	int GL_ACCUM_BLUE_BITS                 = 0x0D5A;
	int GL_ACCUM_ALPHA_BITS                = 0x0D5B;
	int GL_ACCUM_CLEAR_VALUE               = 0x0B80;
	int GL_ACCUM                           = 0x0100;
	int GL_ADD                             = 0x0104;
	int GL_LOAD                            = 0x0101;
	int GL_MULT                            = 0x0103;
	int GL_RETURN                          = 0x0102;

	// Alpha testing 
	int GL_ALPHA_TEST                      = 0x0BC0;
	int GL_ALPHA_TEST_REF                  = 0x0BC2;
	int GL_ALPHA_TEST_FUNC                 = 0x0BC1;

	// Blending 
	int GL_BLEND                           = 0x0BE2;
	int GL_BLEND_SRC                       = 0x0BE1;
	int GL_BLEND_DST                       = 0x0BE0;
	int GL_ZERO                            = 0x0;
	int GL_ONE                             = 0x1;
	int GL_SRC_COLOR                       = 0x0300;
	int GL_ONE_MINUS_SRC_COLOR             = 0x0301;
	int GL_SRC_ALPHA                       = 0x0302;
	int GL_ONE_MINUS_SRC_ALPHA             = 0x0303;
	int GL_DST_ALPHA                       = 0x0304;
	int GL_ONE_MINUS_DST_ALPHA             = 0x0305;
	int GL_DST_COLOR                       = 0x0306;
	int GL_ONE_MINUS_DST_COLOR             = 0x0307;
	int GL_SRC_ALPHA_SATURATE              = 0x0308;

	// Render Mode 
	int GL_FEEDBACK                        = 0x1C01;
	int GL_RENDER                          = 0x1C00;
	int GL_SELECT                          = 0x1C02;

	// Feedback 
	int GL_2D                              = 0x0600;
	int GL_3D                              = 0x0601;
	int GL_3D_COLOR                        = 0x0602;
	int GL_3D_COLOR_TEXTURE                = 0x0603;
	int GL_4D_COLOR_TEXTURE                = 0x0604;
	int GL_POINT_TOKEN                     = 0x0701;
	int GL_LINE_TOKEN                      = 0x0702;
	int GL_LINE_RESET_TOKEN                = 0x0707;
	int GL_POLYGON_TOKEN                   = 0x0703;
	int GL_BITMAP_TOKEN                    = 0x0704;
	int GL_DRAW_PIXEL_TOKEN                = 0x0705;
	int GL_COPY_PIXEL_TOKEN                = 0x0706;
	int GL_PASS_THROUGH_TOKEN              = 0x0700;
	int GL_FEEDBACK_BUFFER_POINTER         = 0x0DF0;
	int GL_FEEDBACK_BUFFER_SIZE            = 0x0DF1;
	int GL_FEEDBACK_BUFFER_TYPE            = 0x0DF2;

	// Selection 
	int GL_SELECTION_BUFFER_POINTER        = 0x0DF3;
	int GL_SELECTION_BUFFER_SIZE           = 0x0DF4;

	// Fog 
	int GL_FOG                             = 0x0B60;
	int GL_FOG_MODE                        = 0x0B65;
	int GL_FOG_DENSITY                     = 0x0B62;
	int GL_FOG_COLOR                       = 0x0B66;
	int GL_FOG_INDEX                       = 0x0B61;
	int GL_FOG_START                       = 0x0B63;
	int GL_FOG_END                         = 0x0B64;
	int GL_LINEAR                          = 0x2601;
	int GL_EXP                             = 0x0800;
	int GL_EXP2                            = 0x0801;

	// Logic Ops 
	int GL_LOGIC_OP                        = 0x0BF1;
	int GL_INDEX_LOGIC_OP                  = 0x0BF1;
	int GL_COLOR_LOGIC_OP                  = 0x0BF2;
	int GL_LOGIC_OP_MODE                   = 0x0BF0;
	int GL_CLEAR                           = 0x1500;
	int GL_SET                             = 0x150F;
	int GL_COPY                            = 0x1503;
	int GL_COPY_INVERTED                   = 0x150C;
	int GL_NOOP                            = 0x1505;
	int GL_INVERT                          = 0x150A;
	int GL_AND                             = 0x1501;
	int GL_NAND                            = 0x150E;
	int GL_OR                              = 0x1507;
	int GL_NOR                             = 0x1508;
	int GL_XOR                             = 0x1506;
	int        GL_EQUIV                    = 0x1509;
	int GL_AND_REVERSE                     = 0x1502;
	int GL_AND_INVERTED                    = 0x1504;
	int GL_OR_REVERSE                      = 0x150B;
	int GL_OR_INVERTED                     = 0x150D;

	// Stencil 
	int GL_STENCIL_TEST                    = 0x0B90;
	int GL_STENCIL_WRITEMASK               = 0x0B98;
	int GL_STENCIL_BITS                    = 0x0D57;
	int GL_STENCIL_FUNC                    = 0x0B92;
	int GL_STENCIL_VALUE_MASK              = 0x0B93;
	int GL_STENCIL_REF                     = 0x0B97;
	int GL_STENCIL_FAIL                    = 0x0B94;
	int GL_STENCIL_PASS_DEPTH_PASS         = 0x0B96;
	int GL_STENCIL_PASS_DEPTH_FAIL         = 0x0B95;
	int GL_STENCIL_CLEAR_VALUE             = 0x0B91;
	int GL_STENCIL_INDEX                   = 0x1901;
	int GL_KEEP                            = 0x1E00;
	int GL_REPLACE                         = 0x1E01;
	int GL_INCR                            = 0x1E02;
	int GL_DECR                            = 0x1E03;

	// Buffers, Pixel Drawing/Reading 
	int GL_NONE                            = 0x0;
	int GL_LEFT                            = 0x0406;
	int GL_RIGHT                           = 0x0407;
	//GL_FRONT                             = 0x0404
	//GL_BACK                              = 0x0405
	//GL_FRONT_AND_BACK                    = 0x0408
	int GL_FRONT_LEFT                      = 0x0400;
	int GL_FRONT_RIGHT                     = 0x0401;
	int GL_BACK_LEFT                       = 0x0402;
	int GL_BACK_RIGHT                      = 0x0403;
	int GL_AUX0                            = 0x0409;
	int GL_AUX1                            = 0x040A;
	int GL_AUX2                            = 0x040B;
	int GL_AUX3                            = 0x040C;
	int GL_COLOR_INDEX                     = 0x1900;
	int GL_RED                             = 0x1903;
	int GL_GREEN                           = 0x1904;
	int GL_BLUE                            = 0x1905;
	int GL_ALPHA                           = 0x1906;
	int GL_LUMINANCE                       = 0x1909;
	int GL_LUMINANCE_ALPHA                 = 0x190A;
	int GL_ALPHA_BITS                      = 0x0D55;
	int GL_RED_BITS                        = 0x0D52;
	int GL_GREEN_BITS                      = 0x0D53;
	int GL_BLUE_BITS                       = 0x0D54;
	int GL_INDEX_BITS                      = 0x0D51;
	int GL_SUBPIXEL_BITS                   = 0x0D50;
	int GL_AUX_BUFFERS                     = 0x0C00;
	int GL_READ_BUFFER                     = 0x0C02;
	int GL_DRAW_BUFFER                     = 0x0C01;
	int GL_DOUBLEBUFFER                    = 0x0C32;
	int GL_STEREO                          = 0x0C33;
	int GL_BITMAP                          = 0x1A00;
	int GL_COLOR                           = 0x1800;
	int GL_DEPTH                           = 0x1801;
	int GL_STENCIL                         = 0x1802;
	int GL_DITHER                          = 0x0BD0;
	int GL_RGB                             = 0x1907;
	int GL_RGBA                            = 0x1908;

	// Implementation limits 
	int GL_MAX_LIST_NESTING                = 0x0B31;
	int GL_MAX_ATTRIB_STACK_DEPTH          = 0x0D35;
	int GL_MAX_MODELVIEW_STACK_DEPTH       = 0x0D36;
	int GL_MAX_NAME_STACK_DEPTH            = 0x0D37;
	int GL_MAX_PROJECTION_STACK_DEPTH      = 0x0D38;
	int GL_MAX_TEXTURE_STACK_DEPTH         = 0x0D39;
	int GL_MAX_EVAL_ORDER                  = 0x0D30;
	int GL_MAX_LIGHTS                      = 0x0D31;
	int GL_MAX_CLIP_PLANES                 = 0x0D32;
	int GL_MAX_TEXTURE_SIZE                = 0x0D33;
	int GL_MAX_PIXEL_MAP_TABLE             = 0x0D34;
	int GL_MAX_VIEWPORT_DIMS               = 0x0D3A;
	int GL_MAX_CLIENT_ATTRIB_STACK_DEPTH   = 0x0D3B;

	// Gets 
	int GL_ATTRIB_STACK_DEPTH              = 0x0BB0;
	int GL_CLIENT_ATTRIB_STACK_DEPTH       = 0x0BB1;
	int GL_COLOR_CLEAR_VALUE               = 0x0C22;
	int GL_COLOR_WRITEMASK                 = 0x0C23;
	int GL_CURRENT_INDEX                   = 0x0B01;
	int GL_CURRENT_COLOR                   = 0x0B00;
	int GL_CURRENT_NORMAL                  = 0x0B02;
	int GL_CURRENT_RASTER_COLOR            = 0x0B04;
	int GL_CURRENT_RASTER_DISTANCE         = 0x0B09;
	int GL_CURRENT_RASTER_INDEX            = 0x0B05;
	int GL_CURRENT_RASTER_POSITION         = 0x0B07;
	int GL_CURRENT_RASTER_TEXTURE_COORDS   = 0x0B06;
	int GL_CURRENT_RASTER_POSITION_VALID   = 0x0B08;
	int GL_CURRENT_TEXTURE_COORDS          = 0x0B03;
	int GL_INDEX_CLEAR_VALUE               = 0x0C20;
	int GL_INDEX_MODE                      = 0x0C30;
	int GL_INDEX_WRITEMASK                 = 0x0C21;
	int GL_MODELVIEW_MATRIX                = 0x0BA6;
	int GL_MODELVIEW_STACK_DEPTH           = 0x0BA3;
	int GL_NAME_STACK_DEPTH                = 0x0D70;
	int GL_PROJECTION_MATRIX               = 0x0BA7;
	int GL_PROJECTION_STACK_DEPTH          = 0x0BA4;
	int GL_RENDER_MODE                     = 0x0C40;
	int GL_RGBA_MODE                       = 0x0C31;
	int GL_TEXTURE_MATRIX                  = 0x0BA8;
	int GL_TEXTURE_STACK_DEPTH             = 0x0BA5;
	int GL_VIEWPORT                        = 0x0BA2;

	// Evaluators 
	int GL_AUTO_NORMAL                     = 0x0D80;
	int GL_MAP1_COLOR_4                    = 0x0D90;
	int GL_MAP1_INDEX                      = 0x0D91;
	int GL_MAP1_NORMAL                     = 0x0D92;
	int GL_MAP1_TEXTURE_COORD_1            = 0x0D93;
	int GL_MAP1_TEXTURE_COORD_2            = 0x0D94;
	int GL_MAP1_TEXTURE_COORD_3            = 0x0D95;
	int GL_MAP1_TEXTURE_COORD_4            = 0x0D96;
	int GL_MAP1_VERTEX_3                   = 0x0D97;
	int GL_MAP1_VERTEX_4                   = 0x0D98;
	int GL_MAP2_COLOR_4                    = 0x0DB0;
	int GL_MAP2_INDEX                      = 0x0DB1;
	int GL_MAP2_NORMAL                     = 0x0DB2;
	int GL_MAP2_TEXTURE_COORD_1            = 0x0DB3;
	int GL_MAP2_TEXTURE_COORD_2            = 0x0DB4;
	int GL_MAP2_TEXTURE_COORD_3            = 0x0DB5;
	int GL_MAP2_TEXTURE_COORD_4            = 0x0DB6;
	int GL_MAP2_VERTEX_3                   = 0x0DB7;
	int GL_MAP2_VERTEX_4                   = 0x0DB8;
	int GL_MAP1_GRID_DOMAIN                = 0x0DD0;
	int GL_MAP1_GRID_SEGMENTS              = 0x0DD1;
	int GL_MAP2_GRID_DOMAIN                = 0x0DD2;
	int GL_MAP2_GRID_SEGMENTS              = 0x0DD3;
	int GL_COEFF                           = 0x0A00;
	int GL_DOMAIN                          = 0x0A02;
	int GL_ORDER                           = 0x0A01;

	// Hints 
	int GL_FOG_HINT                        = 0x0C54;
	int GL_LINE_SMOOTH_HINT                = 0x0C52;
	int GL_PERSPECTIVE_CORRECTION_HINT     = 0x0C50;
	int GL_POINT_SMOOTH_HINT               = 0x0C51;
	int GL_POLYGON_SMOOTH_HINT             = 0x0C53;
	int GL_DONT_CARE                       = 0x1100;
	int GL_FASTEST                         = 0x1101;
	int GL_NICEST                          = 0x1102;

	// Scissor box 
	int GL_SCISSOR_TEST                    = 0x0C11;
	int GL_SCISSOR_BOX                     = 0x0C10;

	// Pixel Mode / Transfer 
	int GL_MAP_COLOR                       = 0x0D10;
	int GL_MAP_STENCIL                     = 0x0D11;
	int GL_INDEX_SHIFT                     = 0x0D12;
	int GL_INDEX_OFFSET                    = 0x0D13;
	int GL_RED_SCALE                       = 0x0D14;
	int GL_RED_BIAS                        = 0x0D15;
	int GL_GREEN_SCALE                     = 0x0D18;
	int GL_GREEN_BIAS                      = 0x0D19;
	int GL_BLUE_SCALE                      = 0x0D1A;
	int GL_BLUE_BIAS                       = 0x0D1B;
	int GL_ALPHA_SCALE                     = 0x0D1C;
	int GL_ALPHA_BIAS                      = 0x0D1D;
	int GL_DEPTH_SCALE                     = 0x0D1E;
	int GL_DEPTH_BIAS                      = 0x0D1F;
	int GL_PIXEL_MAP_S_TO_S_SIZE           = 0x0CB1;
	int GL_PIXEL_MAP_I_TO_I_SIZE           = 0x0CB0;
	int GL_PIXEL_MAP_I_TO_R_SIZE           = 0x0CB2;
	int GL_PIXEL_MAP_I_TO_G_SIZE           = 0x0CB3;
	int GL_PIXEL_MAP_I_TO_B_SIZE           = 0x0CB4;
	int GL_PIXEL_MAP_I_TO_A_SIZE           = 0x0CB5;
	int GL_PIXEL_MAP_R_TO_R_SIZE           = 0x0CB6;
	int GL_PIXEL_MAP_G_TO_G_SIZE           = 0x0CB7;
	int GL_PIXEL_MAP_B_TO_B_SIZE           = 0x0CB8;
	int GL_PIXEL_MAP_A_TO_A_SIZE           = 0x0CB9;
	int GL_PIXEL_MAP_S_TO_S                = 0x0C71;
	int GL_PIXEL_MAP_I_TO_I                = 0x0C70;
	int GL_PIXEL_MAP_I_TO_R                = 0x0C72;
	int GL_PIXEL_MAP_I_TO_G                = 0x0C73;
	int GL_PIXEL_MAP_I_TO_B                = 0x0C74;
	int GL_PIXEL_MAP_I_TO_A                = 0x0C75;
	int GL_PIXEL_MAP_R_TO_R                = 0x0C76;
	int GL_PIXEL_MAP_G_TO_G                = 0x0C77;
	int GL_PIXEL_MAP_B_TO_B                = 0x0C78;
	int GL_PIXEL_MAP_A_TO_A                = 0x0C79;
	int GL_PACK_ALIGNMENT                  = 0x0D05;
	int GL_PACK_LSB_FIRST                  = 0x0D01;
	int GL_PACK_ROW_LENGTH                 = 0x0D02;
	int GL_PACK_SKIP_PIXELS                = 0x0D04;
	int GL_PACK_SKIP_ROWS                  = 0x0D03;
	int GL_PACK_SWAP_BYTES                 = 0x0D00;
	int GL_UNPACK_ALIGNMENT                = 0x0CF5;
	int GL_UNPACK_LSB_FIRST                = 0x0CF1;
	int GL_UNPACK_ROW_LENGTH               = 0x0CF2;
	int GL_UNPACK_SKIP_PIXELS              = 0x0CF4;
	int GL_UNPACK_SKIP_ROWS                = 0x0CF3;
	int GL_UNPACK_SWAP_BYTES               = 0x0CF0;
	int GL_ZOOM_X                          = 0x0D16;
	int GL_ZOOM_Y                          = 0x0D17;

	// Texture mapping 
	int GL_TEXTURE_ENV                     = 0x2300;
	int GL_TEXTURE_ENV_MODE                = 0x2200;
	int GL_TEXTURE_1D                      = 0x0DE0;
	int GL_TEXTURE_2D                      = 0x0DE1;
	int GL_TEXTURE_WRAP_S                  = 0x2802;
	int GL_TEXTURE_WRAP_T                  = 0x2803;
	int GL_TEXTURE_MAG_FILTER              = 0x2800;
	int GL_TEXTURE_MIN_FILTER              = 0x2801;
	int GL_TEXTURE_ENV_COLOR               = 0x2201;
	int GL_TEXTURE_GEN_S                   = 0x0C60;
	int GL_TEXTURE_GEN_T                   = 0x0C61;
	int GL_TEXTURE_GEN_MODE                = 0x2500;
	int GL_TEXTURE_BORDER_COLOR            = 0x1004;
	int GL_TEXTURE_WIDTH                   = 0x1000;
	int GL_TEXTURE_HEIGHT                  = 0x1001;
	int GL_TEXTURE_BORDER                  = 0x1005;
	int GL_TEXTURE_COMPONENTS              = 0x1003;
	int GL_TEXTURE_RED_SIZE                = 0x805C;
	int GL_TEXTURE_GREEN_SIZE              = 0x805D;
	int GL_TEXTURE_BLUE_SIZE               = 0x805E;
	int GL_TEXTURE_ALPHA_SIZE              = 0x805F;
	int GL_TEXTURE_LUMINANCE_SIZE          = 0x8060;
	int GL_TEXTURE_INTENSITY_SIZE          = 0x8061;
	int GL_NEAREST_MIPMAP_NEAREST          = 0x2700;
	int GL_NEAREST_MIPMAP_LINEAR           = 0x2702;
	int GL_LINEAR_MIPMAP_NEAREST           = 0x2701;
	int GL_LINEAR_MIPMAP_LINEAR            = 0x2703;
	int GL_OBJECT_LINEAR                   = 0x2401;
	int GL_OBJECT_PLANE                    = 0x2501;
	int GL_EYE_LINEAR                      = 0x2400;
	int GL_EYE_PLANE                       = 0x2502;
	int GL_SPHERE_MAP                      = 0x2402;
	int GL_DECAL                           = 0x2101;
	int GL_MODULATE                        = 0x2100;
	int GL_NEAREST                         = 0x2600;
	int GL_REPEAT                          = 0x2901;
	int GL_CLAMP                           = 0x2900;
	int GL_S                               = 0x2000;
	int GL_T                               = 0x2001;
	int GL_R                               = 0x2002;
	int GL_Q                               = 0x2003;
	int GL_TEXTURE_GEN_R                   = 0x0C62;
	int GL_TEXTURE_GEN_Q                   = 0x0C63;

	// Utility 
	int GL_VENDOR                          = 0x1F00;
	int GL_RENDERER                        = 0x1F01;
	int GL_VERSION                         = 0x1F02;
	int GL_EXTENSIONS                      = 0x1F03;

	// Errors 
	int GL_NO_ERROR                        = 0x0;
	int GL_INVALID_VALUE                   = 0x0501;
	int GL_INVALID_ENUM                    = 0x0500;
	int GL_INVALID_OPERATION               = 0x0502;
	int GL_STACK_OVERFLOW                  = 0x0503;
	int GL_STACK_UNDERFLOW                 = 0x0504;
	int GL_OUT_OF_MEMORY                   = 0x0505;

	// glPush/PopAttrib bits 
	int GL_CURRENT_BIT                     = 0x00000001;
	int GL_POINT_BIT                       = 0x00000002;
	int GL_LINE_BIT                        = 0x00000004;
	int GL_POLYGON_BIT                     = 0x00000008;
	int GL_POLYGON_STIPPLE_BIT             = 0x00000010;
	int GL_PIXEL_MODE_BIT                  = 0x00000020;
	int GL_LIGHTING_BIT                    = 0x00000040;
	int GL_FOG_BIT                         = 0x00000080;
	int GL_DEPTH_BUFFER_BIT                = 0x00000100;
	int GL_ACCUM_BUFFER_BIT                = 0x00000200;
	int GL_STENCIL_BUFFER_BIT              = 0x00000400;
	int GL_VIEWPORT_BIT                    = 0x00000800;
	int GL_TRANSFORM_BIT                   = 0x00001000;
	int GL_ENABLE_BIT                      = 0x00002000;
	int GL_COLOR_BUFFER_BIT                = 0x00004000;
	int GL_HINT_BIT                        = 0x00008000;
	int GL_EVAL_BIT                        = 0x00010000;
	int GL_LIST_BIT                        = 0x00020000;
	int GL_TEXTURE_BIT                     = 0x00040000;
	int GL_SCISSOR_BIT                     = 0x00080000;
	int GL_ALL_ATTRIB_BITS                 = 0x000FFFFF;


	// OpenGL 1.1 
	int GL_PROXY_TEXTURE_1D                = 0x8063;
	int GL_PROXY_TEXTURE_2D                = 0x8064;
	int GL_TEXTURE_PRIORITY                = 0x8066;
	int GL_TEXTURE_RESIDENT                = 0x8067;
	int GL_TEXTURE_BINDING_1D              = 0x8068;
	int GL_TEXTURE_BINDING_2D              = 0x8069;
	int GL_TEXTURE_INTERNAL_FORMAT         = 0x1003;
	int GL_ALPHA4                          = 0x803B;
	int GL_ALPHA8                          = 0x803C;
	int GL_ALPHA12                         = 0x803D;
	int GL_ALPHA16                         = 0x803E;
	int GL_LUMINANCE4                      = 0x803F;
	int GL_LUMINANCE8                      = 0x8040;
	int GL_LUMINANCE12                     = 0x8041;
	int GL_LUMINANCE16                     = 0x8042;
	int GL_LUMINANCE4_ALPHA4               = 0x8043;
	int GL_LUMINANCE6_ALPHA2               = 0x8044;
	int GL_LUMINANCE8_ALPHA8               = 0x8045;
	int GL_LUMINANCE12_ALPHA4              = 0x8046;
	int GL_LUMINANCE12_ALPHA12             = 0x8047;
	int GL_LUMINANCE16_ALPHA16             = 0x8048;
	int GL_INTENSITY                       = 0x8049;
	int GL_INTENSITY4                      = 0x804A;
	int GL_INTENSITY8                      = 0x804B;
	int GL_INTENSITY12                     = 0x804C;
	int GL_INTENSITY16                     = 0x804D;
	int GL_R3_G3_B2                        = 0x2A10;
	int GL_RGB4                            = 0x804F;
	int GL_RGB5                            = 0x8050;
	int GL_RGB8                            = 0x8051;
	int GL_RGB10                           = 0x8052;
	int GL_RGB12                           = 0x8053;
	int GL_RGB16                           = 0x8054;
	int GL_RGBA2                           = 0x8055;
	int GL_RGBA4                           = 0x8056;
	int GL_RGB5_A1                         = 0x8057;
	int GL_RGBA8                           = 0x8058;
	int GL_RGB10_A2                        = 0x8059;
	int GL_RGBA12                          = 0x805A;
	int GL_RGBA16                          = 0x805B;
	int GL_CLIENT_PIXEL_STORE_BIT          = 0x00000001;
	int GL_CLIENT_VERTEX_ARRAY_BIT         = 0x00000002;
	int GL_ALL_CLIENT_ATTRIB_BITS          = 0xFFFFFFFF;
	int GL_CLIENT_ALL_ATTRIB_BITS          = 0xFFFFFFFF;

	// OpenGL 1.2
	int GL_RESCALE_NORMAL                  = 0x803A;
	int GL_CLAMP_TO_EDGE                   = 0x812F;
	int GL_MAX_ELEMENTS_VERTICES           = 0x80E8;
	int GL_MAX_ELEMENTS_INDICES            = 0x80E9;
	int GL_BGR                             = 0x80E0;
	int GL_BGRA                            = 0x80E1;
	int GL_UNSIGNED_BYTE_3_3_2             = 0x8032;
	int GL_UNSIGNED_BYTE_2_3_3_REV         = 0x8362;
	int GL_UNSIGNED_SHORT_5_6_5            = 0x8363;
	int GL_UNSIGNED_SHORT_5_6_5_REV        = 0x8364;
	int GL_UNSIGNED_SHORT_4_4_4_4          = 0x8033;
	int GL_UNSIGNED_SHORT_4_4_4_4_REV      = 0x8365;
	int GL_UNSIGNED_SHORT_5_5_5_1          = 0x8034;
	int GL_UNSIGNED_SHORT_1_5_5_5_REV      = 0x8366;
	int GL_UNSIGNED_INT_8_8_8_8            = 0x8035;
	int GL_UNSIGNED_INT_8_8_8_8_REV        = 0x8367;
	int GL_UNSIGNED_INT_10_10_10_2         = 0x8036;
	int GL_UNSIGNED_INT_2_10_10_10_REV     = 0x8368;
	int GL_LIGHT_MODEL_COLOR_CONTROL       = 0x81F8;
	int GL_SINGLE_COLOR                    = 0x81F9;
	int GL_SEPARATE_SPECULAR_COLOR         = 0x81FA;
	int GL_TEXTURE_MIN_LOD                 = 0x813A;
	int GL_TEXTURE_MAX_LOD                 = 0x813B;
	int GL_TEXTURE_BASE_LEVEL              = 0x813C;
	int GL_TEXTURE_MAX_LEVEL               = 0x813D;
	int GL_SMOOTH_POINT_SIZE_RANGE         = 0x0B12;
	int GL_SMOOTH_POINT_SIZE_GRANULARITY   = 0x0B13;
	int GL_SMOOTH_LINE_WIDTH_RANGE         = 0x0B22;
	int GL_SMOOTH_LINE_WIDTH_GRANULARITY   = 0x0B23;
	int GL_ALIASED_POINT_SIZE_RANGE        = 0x846D;
	int GL_ALIASED_LINE_WIDTH_RANGE        = 0x846E;
	int GL_PACK_SKIP_IMAGES                = 0x806B;
	int GL_PACK_IMAGE_HEIGHT               = 0x806C;
	int GL_UNPACK_SKIP_IMAGES              = 0x806D;
	int GL_UNPACK_IMAGE_HEIGHT             = 0x806E;
	int GL_TEXTURE_3D                      = 0x806F;
	int GL_PROXY_TEXTURE_3D                = 0x8070;
	int GL_TEXTURE_DEPTH                   = 0x8071;
	int GL_TEXTURE_WRAP_R                  = 0x8072;
	int GL_MAX_3D_TEXTURE_SIZE             = 0x8073;
	int GL_TEXTURE_BINDING_3D              = 0x806A;

	// GL_ARB_imaging
	int GL_CONSTANT_COLOR                      = 0x8001;
	int GL_ONE_MINUS_CONSTANT_COLOR            = 0x8002;
	int GL_CONSTANT_ALPHA                      = 0x8003;
	int GL_ONE_MINUS_CONSTANT_ALPHA            = 0x8004;
	int GL_COLOR_TABLE                         = 0x80D0;
	int GL_POST_CONVOLUTION_COLOR_TABLE        = 0x80D1;
	int GL_POST_COLOR_MATRIX_COLOR_TABLE       = 0x80D2;
	int GL_PROXY_COLOR_TABLE                   = 0x80D3;
	int GL_PROXY_POST_CONVOLUTION_COLOR_TABLE  = 0x80D4;
	int GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5;
	int GL_COLOR_TABLE_SCALE                   = 0x80D6;
	int GL_COLOR_TABLE_BIAS                    = 0x80D7;
	int GL_COLOR_TABLE_FORMAT                  = 0x80D8;
	int GL_COLOR_TABLE_WIDTH                   = 0x80D9;
	int GL_COLOR_TABLE_RED_SIZE                = 0x80DA;
	int GL_COLOR_TABLE_GREEN_SIZE              = 0x80DB;
	int GL_COLOR_TABLE_BLUE_SIZE               = 0x80DC;
	int GL_COLOR_TABLE_ALPHA_SIZE              = 0x80DD;
	int GL_COLOR_TABLE_LUMINANCE_SIZE          = 0x80DE;
	int GL_COLOR_TABLE_INTENSITY_SIZE          = 0x80DF;
	int GL_CONVOLUTION_1D                      = 0x8010;
	int GL_CONVOLUTION_2D                      = 0x8011;
	int GL_SEPARABLE_2D                        = 0x8012;
	int GL_CONVOLUTION_BORDER_MODE             = 0x8013;
	int GL_CONVOLUTION_FILTER_SCALE            = 0x8014;
	int GL_CONVOLUTION_FILTER_BIAS             = 0x8015;
	int GL_REDUCE                              = 0x8016;
	int GL_CONVOLUTION_FORMAT                  = 0x8017;
	int GL_CONVOLUTION_WIDTH                   = 0x8018;
	int GL_CONVOLUTION_HEIGHT                  = 0x8019;
	int GL_MAX_CONVOLUTION_WIDTH               = 0x801A;
	int GL_MAX_CONVOLUTION_HEIGHT              = 0x801B;
	int GL_POST_CONVOLUTION_RED_SCALE          = 0x801C;
	int GL_POST_CONVOLUTION_GREEN_SCALE        = 0x801D;
	int GL_POST_CONVOLUTION_BLUE_SCALE         = 0x801E;
	int GL_POST_CONVOLUTION_ALPHA_SCALE        = 0x801F;
	int GL_POST_CONVOLUTION_RED_BIAS           = 0x8020;
	int GL_POST_CONVOLUTION_GREEN_BIAS         = 0x8021;
	int GL_POST_CONVOLUTION_BLUE_BIAS          = 0x8022;
	int GL_POST_CONVOLUTION_ALPHA_BIAS         = 0x8023;
	int GL_CONSTANT_BORDER                     = 0x8151;
	int GL_REPLICATE_BORDER                    = 0x8153;
	int GL_CONVOLUTION_BORDER_COLOR            = 0x8154;
	int GL_COLOR_MATRIX                        = 0x80B1;
	int GL_COLOR_MATRIX_STACK_DEPTH            = 0x80B2;
	int GL_MAX_COLOR_MATRIX_STACK_DEPTH        = 0x80B3;
	int GL_POST_COLOR_MATRIX_RED_SCALE         = 0x80B4;
	int GL_POST_COLOR_MATRIX_GREEN_SCALE       = 0x80B5;
	int GL_POST_COLOR_MATRIX_BLUE_SCALE        = 0x80B6;
	int GL_POST_COLOR_MATRIX_ALPHA_SCALE       = 0x80B7;
	int GL_POST_COLOR_MATRIX_RED_BIAS          = 0x80B8;
	int GL_POST_COLOR_MATRIX_GREEN_BIAS        = 0x80B9;
	int GL_POST_COLOR_MATRIX_BLUE_BIAS         = 0x80BA;
	int GL_POST_COLOR_MATRIX_ALPHA_BIAS        = 0x80BB;
	int GL_HISTOGRAM                           = 0x8024;
	int GL_PROXY_HISTOGRAM                     = 0x8025;
	int GL_HISTOGRAM_WIDTH                     = 0x8026;
	int GL_HISTOGRAM_FORMAT                    = 0x8027;
	int GL_HISTOGRAM_RED_SIZE                  = 0x8028;
	int GL_HISTOGRAM_GREEN_SIZE                = 0x8029;
	int GL_HISTOGRAM_BLUE_SIZE                 = 0x802A;
	int GL_HISTOGRAM_ALPHA_SIZE                = 0x802B;
	int GL_HISTOGRAM_LUMINANCE_SIZE            = 0x802C;
	int GL_HISTOGRAM_SINK                      = 0x802D;
	int GL_MINMAX                              = 0x802E;
	int GL_MINMAX_FORMAT                       = 0x802F;
	int GL_MINMAX_SINK                         = 0x8030;
	int GL_TABLE_TOO_LARGE                     = 0x8031;
	int GL_BLEND_EQUATION                      = 0x8009;
	int GL_MIN                                 = 0x8007;
	int GL_MAX                                 = 0x8008;
	int GL_FUNC_ADD                            = 0x8006;
	int GL_FUNC_SUBTRACT                       = 0x800A;
	int GL_FUNC_REVERSE_SUBTRACT               = 0x800B;
	int GL_BLEND_COLOR                         = 0x8005;

	// OpenGL 1.3

	// multitexture
	int GL_TEXTURE0                            = 0x84C0;
	int GL_TEXTURE1                            = 0x84C1;
	int GL_TEXTURE2                            = 0x84C2;
	int GL_TEXTURE3                            = 0x84C3;
	int GL_TEXTURE4                            = 0x84C4;
	int GL_TEXTURE5                            = 0x84C5;
	int GL_TEXTURE6                            = 0x84C6;
	int GL_TEXTURE7                            = 0x84C7;
	int GL_TEXTURE8                            = 0x84C8;
	int GL_TEXTURE9                            = 0x84C9;
	int GL_TEXTURE10                           = 0x84CA;
	int GL_TEXTURE11                           = 0x84CB;
	int GL_TEXTURE12                           = 0x84CC;
	int GL_TEXTURE13                           = 0x84CD;
	int GL_TEXTURE14                           = 0x84CE;
	int GL_TEXTURE15                           = 0x84CF;
	int GL_TEXTURE16                           = 0x84D0;
	int GL_TEXTURE17                           = 0x84D1;
	int GL_TEXTURE18                           = 0x84D2;
	int GL_TEXTURE19                           = 0x84D3;
	int GL_TEXTURE20                           = 0x84D4;
	int GL_TEXTURE21                           = 0x84D5;
	int GL_TEXTURE22                           = 0x84D6;
	int GL_TEXTURE23                           = 0x84D7;
	int GL_TEXTURE24                           = 0x84D8;
	int GL_TEXTURE25                           = 0x84D9;
	int GL_TEXTURE26                           = 0x84DA;
	int GL_TEXTURE27                           = 0x84DB;
	int GL_TEXTURE28                           = 0x84DC;
	int GL_TEXTURE29                           = 0x84DD;
	int GL_TEXTURE30                           = 0x84DE;
	int GL_TEXTURE31                           = 0x84DF;
	int GL_ACTIVE_TEXTURE                      = 0x84E0;
	int GL_CLIENT_ACTIVE_TEXTURE               = 0x84E1;
	int GL_MAX_TEXTURE_UNITS                   = 0x84E2;

	// texture_cube_map 
	int GL_NORMAL_MAP                          = 0x8511;
	int GL_REFLECTION_MAP                      = 0x8512;
	int GL_TEXTURE_CUBE_MAP                    = 0x8513;
	int GL_TEXTURE_BINDING_CUBE_MAP            = 0x8514;
	int GL_TEXTURE_CUBE_MAP_POSITIVE_X         = 0x8515;
	int GL_TEXTURE_CUBE_MAP_NEGATIVE_X         = 0x8516;
	int GL_TEXTURE_CUBE_MAP_POSITIVE_Y         = 0x8517;
	int GL_TEXTURE_CUBE_MAP_NEGATIVE_Y         = 0x8518;
	int GL_TEXTURE_CUBE_MAP_POSITIVE_Z         = 0x8519;
	int GL_TEXTURE_CUBE_MAP_NEGATIVE_Z         = 0x851A;
	int GL_PROXY_TEXTURE_CUBE_MAP              = 0x851B;
	int GL_MAX_CUBE_MAP_TEXTURE_SIZE           = 0x851C;

	// texture_compression 
	int GL_COMPRESSED_ALPHA                    = 0x84E9;
	int GL_COMPRESSED_LUMINANCE                = 0x84EA;
	int GL_COMPRESSED_LUMINANCE_ALPHA          = 0x84EB;
	int GL_COMPRESSED_INTENSITY                = 0x84EC;
	int GL_COMPRESSED_RGB                      = 0x84ED;
	int GL_COMPRESSED_RGBA                     = 0x84EE;
	int GL_TEXTURE_COMPRESSION_HINT            = 0x84EF;
	int GL_TEXTURE_COMPRESSED_IMAGE_SIZE       = 0x86A0;
	int GL_TEXTURE_COMPRESSED                  = 0x86A1;
	int GL_NUM_COMPRESSED_TEXTURE_FORMATS      = 0x86A2;
	int GL_COMPRESSED_TEXTURE_FORMATS          = 0x86A3;

	// multisample
	int GL_MULTISAMPLE                         = 0x809D;
	int GL_SAMPLE_ALPHA_TO_COVERAGE            = 0x809E;
	int GL_SAMPLE_ALPHA_TO_ONE                 = 0x809F;
	int GL_SAMPLE_COVERAGE                     = 0x80A0;
	int GL_SAMPLE_BUFFERS                      = 0x80A8;
	int GL_SAMPLES                             = 0x80A9;
	int GL_SAMPLE_COVERAGE_VALUE               = 0x80AA;
	int GL_SAMPLE_COVERAGE_INVERT              = 0x80AB;
	int GL_MULTISAMPLE_BIT                     = 0x20000000;

	// transpose_matrix
	int GL_TRANSPOSE_MODELVIEW_MATRIX          = 0x84E3;
	int GL_TRANSPOSE_PROJECTION_MATRIX         = 0x84E4;
	int GL_TRANSPOSE_TEXTURE_MATRIX            = 0x84E5;
	int GL_TRANSPOSE_COLOR_MATRIX              = 0x84E6;

	// texture_env_combine
	int GL_COMBINE                             = 0x8570;
	int GL_COMBINE_RGB                         = 0x8571;
	int GL_COMBINE_ALPHA                       = 0x8572;
	int GL_SOURCE0_RGB                         = 0x8580;
	int GL_SOURCE1_RGB                         = 0x8581;
	int GL_SOURCE2_RGB                         = 0x8582;
	int GL_SOURCE0_ALPHA                       = 0x8588;
	int GL_SOURCE1_ALPHA                       = 0x8589;
	int GL_SOURCE2_ALPHA                       = 0x858A;
	int GL_OPERAND0_RGB                        = 0x8590;
	int GL_OPERAND1_RGB                        = 0x8591;
	int GL_OPERAND2_RGB                        = 0x8592;
	int GL_OPERAND0_ALPHA                      = 0x8598;
	int GL_OPERAND1_ALPHA                      = 0x8599;
	int GL_OPERAND2_ALPHA                      = 0x859A;
	int GL_RGB_SCALE                           = 0x8573;
	int GL_ADD_SIGNED                          = 0x8574;
	int GL_INTERPOLATE                         = 0x8575;
	int GL_SUBTRACT                            = 0x84E7;
	int GL_CONSTANT                            = 0x8576;
	int GL_PRIMARY_COLOR                       = 0x8577;
	int GL_PREVIOUS                            = 0x8578;

	// texture_env_dot3
	int GL_DOT3_RGB                            = 0x86AE;
	int GL_DOT3_RGBA                           = 0x86AF;

	// texture_border_clamp
	int GL_CLAMP_TO_BORDER                     = 0x812D;
};
