import gl4gcj.*;
import glut4gcj.*;

class VertexPointerRect extends GL implements 
	DisplayFunc, KeyboardFunc
{
	static final double SIZE = 0.9
	static final double[] SQUARE_VERTEX_ARRAY = new double[]{ 
		-SIZE,  SIZE, 0.0, 
		-SIZE, -SIZE, 0.0, 
		 SIZE, -SIZE, 0.0, 
		 SIZE,  SIZE, 0.0, 
	};

	static final double[] SQUARE_COLOR_ARRAY = new double[]{ 
		1.0, 0.0, 0.0,
		0.0, 1.0, 0.0,
		0.0, 0.0, 1.0,
		1.0, 1.0, 0.0,
	};

	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		glEnableClientState(GL_VERTEX_ARRAY);
		glEnableClientState(GL_COLOR_ARRAY);

		glVertexPointer(3, SQUARE_VERTEX_ARRAY);
		glColorPointer(3, SQUARE_COLOR_ARRAY);
		glDrawArrays(GL_POLYGON, 0, 4);

		glDisableClientState(GL_VERTEX_ARRAY);
		glDisableClientState(GL_COLOR_ARRAY);

		glFlush();
	}

	public void keyboard(byte key, int x, int y)
	{
		if (key == 'q' || key == 'Q' || key == '') System.exit(0);
	}
}

public class VertexPointerTest extends GLUT 
{
	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutCreateWindow("Vertex Pointer Test");

			VertexPointerRect test = new VertexPointerRect();
			glutDisplayFunc(test);
			glutKeyboardFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
