import gl4gcj.*;
import glut4gcj.*;

class EventTest extends GLUT implements 
	DisplayFunc, ReshapeFunc, KeyboardFunc,
	MouseFunc, MotionFunc, PassiveMotionFunc,
	EntryFunc, SpecialFunc
{
	public void display()
	{
		glClear(GL_COLOR_BUFFER_BIT);

		glColor3d(1.0, 0.0, 0.0);
		glRectd(-0.9, -0.9, 0.9, 0.9);

		glFlush();
	}

	public void reshape(int width, int height)
	{
		System.out.println("reshape(" + width + ", " + height + ")");
		glViewport(0, 0, width, height);

		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
	}

	public void keyboard(byte key, int x, int y)
	{
		System.out.println("keyboard(" + (char)key + "," + x + ", " + y + ")");
		if (key == 'q' || key == 'Q' || key == '') System.exit(0);
	}

	public void special(int key, int x, int y)
	{
		System.out.println("special(" + key + "," + x + ", " + y + ")");
	}

	public void mouse(int button, int state, int x, int y)
	{
		System.out.println("mouse(" + button + "," + state + "," + x + "," + y + ")");
	}

	public void motion(int x, int y)
	{
		System.out.println("motion(" + x + "," + y + ")");
	}

	public void passiveMotion( int x, int y)
	{
		System.out.println("passiveMotion(" + x + "," + y + ")");
	}

	public void entry(int state)
	{
		System.out.println("entry(" + state + ")");
	}

	public static void main(String[] args)
	{
		try
		{
			glutInit(args);
			glutInitDisplayMode(GLUT_RGB);
			glutCreateWindow("Event Test");

			EventTest test = new EventTest();
			glutDisplayFunc(test);
			glutReshapeFunc(test);
			glutEntryFunc(test);
			glutMouseFunc(test);
			glutMotionFunc(test);
			glutPassiveMotionFunc(test);
			glutKeyboardFunc(test);
			glutSpecialFunc(test);

			glutMainLoop();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
}
