package glut4gcj;

public interface GLUTConstants
{
	/* Display mode bit masks. */
	int GLUT_RGB		=0;
	int GLUT_RGBA		= GLUT_RGB;
	int GLUT_INDEX		=1;
	int GLUT_SINGLE		=0;
	int GLUT_DOUBLE		=2;
	int GLUT_ACCUM		=4;
	int GLUT_ALPHA		=8;
	int GLUT_DEPTH		=16;
	int GLUT_STENCIL		=32;
	// GLUT_API_VERSION >= 2;
	int GLUT_MULTISAMPLE	=128;
	int GLUT_STEREO		=256;
	// GLUT_API_VERSION >= 3;
	int GLUT_LUMINANCE		=512;

	/* Mouse buttons. */
	int GLUT_LEFT_BUTTON	=0;
	int GLUT_MIDDLE_BUTTON	=1;
	int GLUT_RIGHT_BUTTON	=2;

	/* Mouse button  state. */
	int GLUT_DOWN		=0;
	int GLUT_UP			=1;

	// GLUT_API_VERSION >= 2;
	// function keys 
	int GLUT_KEY_F1		=1;
	int GLUT_KEY_F2		=2;
	int GLUT_KEY_F3		=3;
	int GLUT_KEY_F4		=4;
	int GLUT_KEY_F5		=5;
	int GLUT_KEY_F6		=6;
	int GLUT_KEY_F7		=7;
	int GLUT_KEY_F8		=8;
	int GLUT_KEY_F9		=9;
	int GLUT_KEY_F10		=10;
	int GLUT_KEY_F11		=11;
	int GLUT_KEY_F12		=12;
	// directional keys 
	int GLUT_KEY_LEFT		=100;
	int GLUT_KEY_UP		= 101;
	int GLUT_KEY_RIGHT		=102;
	int GLUT_KEY_DOWN		=103;
	int GLUT_KEY_PAGE_UP	=104;
	int GLUT_KEY_PAGE_DOWN	=105;
	int GLUT_KEY_HOME		=106;
	int GLUT_KEY_END		=107;
	int GLUT_KEY_INSERT		=108;

	/* Entry/exit  state. */
	int GLUT_LEFT			= 0;
	int GLUT_ENTERED		= 1;

	/* Menu usage  state. */
	int GLUT_MENU_NOT_IN_USE	= 0;
	int GLUT_MENU_IN_USE	= 1;

	/* Visibility  state. */
	int GLUT_NOT_VISIBLE	= 0;
	int GLUT_VISIBLE		= 1;

	/* Window status  state. */
	int GLUT_HIDDEN		= 0;
	int GLUT_FULLY_RETAINED	= 1;
	int GLUT_PARTIALLY_RETAINED	= 2;
	int GLUT_FULLY_COVERED	= 3;

	/* Color index component selection values. */
	int GLUT_RED		= 0;
	int GLUT_GREEN		= 1;
	int GLUT_BLUE		= 2;

	/* Layers for use. */
	int GLUT_NORMAL		= 0;
	int GLUT_OVERLAY		= 1;

	/* glutGet parameters. */
	int GLUT_WINDOW_X		= 100;
	int GLUT_WINDOW_Y		= 101;
	int GLUT_WINDOW_WIDTH	= 102;
	int GLUT_WINDOW_HEIGHT	= 103;
	int GLUT_WINDOW_BUFFER_SIZE	= 104;
	int GLUT_WINDOW_STENCIL_SIZE= 105;
	int GLUT_WINDOW_DEPTH_SIZE	= 106;
	int GLUT_WINDOW_RED_SIZE	= 107;
	int GLUT_WINDOW_GREEN_SIZE	= 108;
	int GLUT_WINDOW_BLUE_SIZE	= 109;
	int GLUT_WINDOW_ALPHA_SIZE	= 110;
	int GLUT_WINDOW_ACCUM_RED_SIZE= 111;
	int GLUT_WINDOW_ACCUM_GREEN_SIZE= 112;
	int GLUT_WINDOW_ACCUM_BLUE_SIZE= 113;
	int GLUT_WINDOW_ACCUM_ALPHA_SIZE= 114;
	int GLUT_WINDOW_DOUBLEBUFFER= 115;
	int GLUT_WINDOW_RGBA	= 116;
	int GLUT_WINDOW_PARENT	= 117;
	int GLUT_WINDOW_NUM_CHILDREN= 118;
	int GLUT_WINDOW_COLORMAP_SIZE= 119;

	// GLUT_API_VERSION >= 2
	int GLUT_WINDOW_NUM_SAMPLES	= 120;
	int GLUT_WINDOW_STEREO	= 121;

	// GLUT_API_VERSION >= 3
	int GLUT_WINDOW_CURSOR	= 122;

	int GLUT_SCREEN_WIDTH	= 200;
	int GLUT_SCREEN_HEIGHT	= 201;
	int GLUT_SCREEN_WIDTH_MM	= 202;
	int GLUT_SCREEN_HEIGHT_MM	= 203;
	int GLUT_MENU_NUM_ITEMS	= 300;
	int GLUT_DISPLAY_MODE_POSSIBLE= 400;
	int GLUT_INIT_WINDOW_X	= 500;
	int GLUT_INIT_WINDOW_Y	= 501;
	int GLUT_INIT_WINDOW_WIDTH	= 502;
	int GLUT_INIT_WINDOW_HEIGHT	= 503;
	int GLUT_INIT_DISPLAY_MODE	= 504;
	int GLUT_ELAPSED_TIME	= 700;
	int GLUT_WINDOW_FORMAT_ID	= 123;

	/* glutDeviceGet parameters. */
	int GLUT_HAS_KEYBOARD	= 600;
	int GLUT_HAS_MOUSE		= 601;
	int GLUT_HAS_SPACEBALL	= 602;
	int GLUT_HAS_DIAL_AND_BUTTON_BOX= 603;
	int GLUT_HAS_TABLET		= 604;
	int GLUT_NUM_MOUSE_BUTTONS	= 605;
	int GLUT_NUM_SPACEBALL_BUTTONS= 606;
	int GLUT_NUM_BUTTON_BOX_BUTTONS= 607;
	int GLUT_NUM_DIALS		= 608;
	int GLUT_NUM_TABLET_BUTTONS	= 609;

	int GLUT_DEVICE_IGNORE_KEY_REPEAT  = 610;
	int GLUT_DEVICE_KEY_REPEAT         = 611;
	int GLUT_HAS_JOYSTICK	= 612;
	int GLUT_OWNS_JOYSTICK	= 613;
	int GLUT_JOYSTICK_BUTTONS	= 614;
	int GLUT_JOYSTICK_AXES	= 615;
	int GLUT_JOYSTICK_POLL_RATE	= 616;

	/* glutLayerGet parameters. */
	int GLUT_OVERLAY_POSSIBLE          = 800;
	int GLUT_LAYER_IN_USE	= 801;
	int GLUT_HAS_OVERLAY	= 802;
	int GLUT_TRANSPARENT_INDEX	= 803;
	int GLUT_NORMAL_DAMAGED	= 804;
	int GLUT_OVERLAY_DAMAGED	= 805;

	/* glutVideoResizeGet parameters. */
	int GLUT_VIDEO_RESIZE_POSSIBLE= 900;
	int GLUT_VIDEO_RESIZE_IN_USE= 901;
	int GLUT_VIDEO_RESIZE_X_DELTA= 902;
	int GLUT_VIDEO_RESIZE_Y_DELTA= 903;
	int GLUT_VIDEO_RESIZE_WIDTH_DELTA= 904;
	int GLUT_VIDEO_RESIZE_HEIGHT_DELTA= 905;
	int GLUT_VIDEO_RESIZE_X	= 906;
	int GLUT_VIDEO_RESIZE_Y	= 907;
	int GLUT_VIDEO_RESIZE_WIDTH	= 908;
	int GLUT_VIDEO_RESIZE_HEIGHT= 909;

	/* glutGetModifiers return mask. */
	int GLUT_ACTIVE_SHIFT              = 1;
	int GLUT_ACTIVE_CTRL               = 2;
	int GLUT_ACTIVE_ALT                = 4;

	/* glutSetCursor parameters. */
	/* Basic arrows. */
	int GLUT_CURSOR_RIGHT_ARROW	= 0;
	int GLUT_CURSOR_LEFT_ARROW	= 1;
	/* Symbolic cursor shapes. */
	int GLUT_CURSOR_INFO	= 2;
	int GLUT_CURSOR_DESTROY	= 3;
	int GLUT_CURSOR_HELP	= 4;
	int GLUT_CURSOR_CYCLE	= 5;
	int GLUT_CURSOR_SPRAY	= 6;
	int GLUT_CURSOR_WAIT	= 7;
	int GLUT_CURSOR_TEXT	= 8;
	int GLUT_CURSOR_CROSSHAIR	= 9;
	/* Directional cursors. */
	int GLUT_CURSOR_UP_DOWN	= 10;
	int GLUT_CURSOR_LEFT_RIGHT	= 11;
	/* Sizing cursors. */
	int GLUT_CURSOR_TOP_SIDE	= 12;
	int GLUT_CURSOR_BOTTOM_SIDE	= 13;
	int GLUT_CURSOR_LEFT_SIDE	= 14;
	int GLUT_CURSOR_RIGHT_SIDE	= 15;
	int GLUT_CURSOR_TOP_LEFT_CORNER= 16;
	int GLUT_CURSOR_TOP_RIGHT_CORNER= 17;
	int GLUT_CURSOR_BOTTOM_RIGHT_CORNER= 18;
	int GLUT_CURSOR_BOTTOM_LEFT_CORNER= 19;
	/* Inherit from parent window. */
	int GLUT_CURSOR_INHERIT	= 100;
	/* Blank cursor. */
	int GLUT_CURSOR_NONE	= 101;
	/* Fullscreen crosshair (if available). */
	int GLUT_CURSOR_FULL_CROSSHAIR= 102;

	/* GLUT device control sub-API. */
	/* glutSetKeyRepeat modes. */
	int GLUT_KEY_REPEAT_OFF	= 0;
	int GLUT_KEY_REPEAT_ON	= 1;
	int GLUT_KEY_REPEAT_DEFAULT	= 2;

	/* Joystick button masks. */
	int GLUT_JOYSTICK_BUTTON_A	= 1;
	int GLUT_JOYSTICK_BUTTON_B	= 2;
	int GLUT_JOYSTICK_BUTTON_C	= 4;
	int GLUT_JOYSTICK_BUTTON_D	= 8;

	/* GLUT game mode sub-API. */
	/* glutGameModeGet. */
	int GLUT_GAME_MODE_ACTIVE          = 0;
	int GLUT_GAME_MODE_POSSIBLE        = 1;
	int GLUT_GAME_MODE_WIDTH           = 2;
	int GLUT_GAME_MODE_HEIGHT          = 3;
	int GLUT_GAME_MODE_PIXEL_DEPTH     = 4;
	int GLUT_GAME_MODE_REFRESH_RATE    = 5;
	int GLUT_GAME_MODE_DISPLAY_CHANGED = 6;
}
