package glut4gcj;

import gl4gcj.GL;

public class GLUT extends GL implements GLUTConstants
{
	// GLUT initialization sub-API. 
	public static native String[] glutInit(String[] args);
	public static native void glutInitDisplayMode(int mode);

	public static native void glutInitDisplayString(String string);

	public static native void glutInitWindowPosition(int x, int y);
	public static native void glutInitWindowSize(int width, int height);
	public static native void glutMainLoop();

	// GLUT window sub-API. 
	public static native int glutCreateWindow(String title);
	public static native int glutCreateSubWindow(int win, int x, int y, int width, int height);
	public static native void glutDestroyWindow(int win);
	public static native void glutPostRedisplay();

	public static native void glutPostWindowRedisplay(int win);

	public static native void glutSwapBuffers();
	public static native int glutGetWindow();
	public static native void glutSetWindow(int win);
	public static native void glutSetWindowTitle(String title);
	public static native void glutSetIconTitle(String title);
	public static native void glutPositionWindow(int x, int y);
	public static native void glutReshapeWindow(int width, int height);
	public static native void glutPopWindow();
	public static native void glutPushWindow();
	public static native void glutIconifyWindow();
	public static native void glutShowWindow();
	public static native void glutHideWindow();

	public static native void glutFullScreen();
	public static native void glutSetCursor(int cursor);

	public static native void glutWarpPointer(int x, int y);

	// GLUT overlay sub-API. 
	public static native void glutEstablishOverlay();
	public static native void glutRemoveOverlay();
	public static native void glutUseLayer(int layer);
	public static native void glutPostOverlayRedisplay();

	public static native void glutPostWindowOverlayRedisplay(int win);

	public static native void glutShowOverlay();
	public static native void glutHideOverlay();

	// GLUT menu sub-API.
	public static native int glutCreateMenu(MenuFunc menuFunc);
	public static native void glutDestroyMenu(int menu);
	public static native int glutGetMenu();
	public static native void glutSetMenu(int menu);
	public static native void glutAddMenuEntry(String label, int value);
	public static native void glutAddSubMenu(String label, int submenu);
	public static native void glutChangeToMenuEntry(int item, String label, int value);
	public static native void glutChangeToSubMenu(int item, String label, int submenu);
	public static native void glutRemoveMenuItem(int item);
	public static native void glutAttachMenu(int button);
	public static native void glutDetachMenu(int button);

	// GLUT window callback sub-API.
	public static native void glutDisplayFunc(DisplayFunc func);
	public static native void glutReshapeFunc(ReshapeFunc func);
	public static native void glutKeyboardFunc(KeyboardFunc func);
	public static native void glutMouseFunc(MouseFunc func);
	public static native void glutMotionFunc(MotionFunc func);
	public static native void glutPassiveMotionFunc(PassiveMotionFunc func);
	public static native void glutEntryFunc(EntryFunc func);
	public static native void glutVisibilityFunc(VisibilityFunc func);
	public static native void glutIdleFunc(IdleFunc func);
	public static native void glutTimerFunc(int millis, TimerFunc func, int value);
	public static void glutTimerFunc(int millis, TimerFunc func)
	{
		glutTimerFunc(millis, func, 0);
	}
	public static native void glutMenuStateFunc(MenuStateFunc func);

	// #if (GLUT_API_VERSION >= 2)
	public static native void glutSpecialFunc(SpecialFunc func);
	public static native void glutSpaceballMotionFunc(SpaceballMotionFunc func);
	public static native void glutSpaceballRotateFunc(SpaceballRotateFunc func);
	public static native void glutSpaceballButtonFunc(SpaceballButtonFunc func);
	/*
	public static native void glutButtonBoxFunc(void (*func)(int button, int state));
	public static native void glutDialsFunc(void (*func)(int dial, int value));
	public static native void glutTabletMotionFunc(void (*func)(int x, int y));
	public static native void glutTabletButtonFunc(void (*func)(int button, int state, int x, int y));
	// # if (GLUT_API_VERSION >= 3)
	public static native void glutMenuStatusFunc(void (*func)(int status, int x, int y));
	public static native void glutOverlayDisplayFunc(void (*func)(void));
	// #  if (GLUT_API_VERSION >= 4 || GLUT_XLIB_IMPLEMENTATION >= 9)
	public static native void glutWindowStatusFunc(void (*func)(int state));
	// #  endif
	// #  if (GLUT_API_VERSION >= 4 || GLUT_XLIB_IMPLEMENTATION >= 13)
	public static native void glutKeyboardUpFunc(void (*func)(char key, int x, int y));
	public static native void glutSpecialUpFunc(void (*func)(int key, int x, int y));
	public static native void glutJoystickFunc(void (*func)(int buttonMask, int x, int y, int z), int pollInterval);
	// #  endif
	// # endif
	// #endif
	*/

	// GLUT color index sub-API.
	public static native void glutSetColor(int cell, float red, float green, float blue);
	public static native float glutGetColor(int ndx, int component);
	public static native void glutCopyColormap(int win);

	// GLUT state retrieval sub-API.
	public static native int glutGet(int type);
	public static native int glutDeviceGet(int type);

	// GLUT extension support sub-API
	// #if (GLUT_API_VERSION >= 2)
	public static native boolean glutExtensionSupported(String name);
	// #endif

	// #if (GLUT_API_VERSION >= 3)
	public static native int glutGetModifiers();
	public static native int glutLayerGet(int type);
	// #endif

	// GLUT font sub-API 
	/*
	public static native void glutBitmapCharacter(void *font, int character);
	public static native int glutBitmapWidth(void *font, int character);
	public static native void glutStrokeCharacter(void *font, int character);
	public static native int glutStrokeWidth(void *font, int character);
	// #if (GLUT_API_VERSION >= 4 || GLUT_XLIB_IMPLEMENTATION >= 9)
	public static native int glutBitmapLength(void *font, char *string);
	public static native int glutStrokeLength(void *font, char *string);
	// #endif
	*/

	// GLUT pre-built models sub-API 
	public static native void glutWireSphere(double radius, int slices, int stacks);
	public static native void glutSolidSphere(double radius, int slices, int stacks);
	public static native void glutWireCone(double base, double height, int slices, int stacks);
	public static native void glutSolidCone(double base, double height, int slices, int stacks);
	public static native void glutWireCube(double size);
	public static native void glutSolidCube(double size);
	public static native void glutWireTorus(double innerRadius, double outerRadius, int sides, int rings);
	public static native void glutSolidTorus(double innerRadius, double outerRadius, int sides, int rings);
	public static native void glutWireDodecahedron();
	public static native void glutSolidDodecahedron();
	public static native void glutWireTeapot(double size);
	public static native void glutSolidTeapot(double size);
	public static native void glutWireOctahedron();
	public static native void glutSolidOctahedron();
	public static native void glutWireTetrahedron();
	public static native void glutSolidTetrahedron();
	public static native void glutWireIcosahedron();
	public static native void glutSolidIcosahedron();

	// GLUT video resize sub-API. 
	public static native int glutVideoResizeGet(int param);
	public static native void glutSetupVideoResizing();
	public static native void glutStopVideoResizing();
	public static native void glutVideoResize(int x, int y, int width, int height);
	public static native void glutVideoPan(int x, int y, int width, int height);

	// GLUT debugging sub-API.
	public static native void glutReportErrors();

	public static native void glutIgnoreKeyRepeat(int ignore);
	public static native void glutSetKeyRepeat(int repeatMode);
	public static native void glutForceJoystickFunc();

	// GLUT game mode sub-API.
	public static native void glutGameModeString(String string);
	public static native int glutEnterGameMode();
	public static native void glutLeaveGameMode();
	public static native int glutGameModeGet(int mode);

}
