#include <gkrellm/gkrellm.h>

#include "bled.xpm"

#if 0
#define _DEBUG
#endif

#define PLUGIN_PLACEMENT	MON_UPTIME
#define	CONFIG_NAME	"GkLauncher"
#define	STYLE_NAME	"gklauncher"
#define CONFIG_KEYWORD  "gklauncher"

static Monitor *monitor;

static gint style_id;
static gint button_state;

static GtkWidget *label_entry, *cmd_entry;
static GtkWidget *gk_clist;
static GtkWidget *main_vbox;
static GList *mon_list;
static gint n_monitors;

static gint selected_row = -1;
static gint list_modified;

typedef struct _Item
{
  gchar   *label;
  gchar   *cmd;
  Panel   *panel;
  Decal   *decal_text, *decal_pix;
}
Item;

static void
cb_selected (GtkWidget *widget, gint row, gint column,
	     GdkEventButton * bevent, gpointer user_data)
{
  gchar   *text;
  gint     i;

  i = 0;
  gtk_clist_get_text (GTK_CLIST (widget), row, i++, &text);
  gtk_entry_set_text (GTK_ENTRY (label_entry), text);
  gtk_clist_get_text (GTK_CLIST (widget), row, i++, &text);
  gtk_entry_set_text (GTK_ENTRY (cmd_entry), text);

  selected_row = row;
}

static void
cb_unselected (GtkWidget *widget, gint row, gint column,
	       GdkEventButton * bevent, gpointer user_data)
{

  gtk_entry_set_text (GTK_ENTRY (label_entry), "");
  gtk_entry_set_text (GTK_ENTRY (cmd_entry), "");
  selected_row = -1;
}

static void
cb_up (GtkWidget *widget, GtkWidget **clist)
{
  gint     row;

  row = selected_row;
  if (row > 0) {
    gtk_clist_row_move (GTK_CLIST (*clist), row, row - 1);
    gtk_clist_select_row (GTK_CLIST (*clist), row - 1, -1);
    if (gtk_clist_row_is_visible (GTK_CLIST (*clist), row - 1)
	!= GTK_VISIBILITY_FULL)
      gtk_clist_moveto (GTK_CLIST (*clist), row - 1, -1, 0.0, 0.0);
    selected_row = row - 1;
    list_modified = TRUE;
  }
}

static void
cb_down (GtkWidget *widget, GtkWidget **clist)
{
  gint     row;

  row = selected_row;
  if (row >= 0 && row < GTK_CLIST (*clist)->rows - 1) {
    gtk_clist_row_move (GTK_CLIST (*clist), row, row + 1);
    gtk_clist_select_row (GTK_CLIST (*clist), row + 1, -1);
    if (gtk_clist_row_is_visible (GTK_CLIST (*clist), row + 1)
	!= GTK_VISIBILITY_FULL)
      gtk_clist_moveto (GTK_CLIST (*clist), row + 1, -1, 1.0, 0.0);
    selected_row = row + 1;
    list_modified = TRUE;
  }
}

static void
cb_enter (GtkWidget *widget, GtkWidget **clist)
{
  gchar   *buf[2];

  buf[0] = gkrellm_entry_get_text (&label_entry);
  buf[1] = gkrellm_entry_get_text (&cmd_entry);
  if ((strcmp (buf[0], "")) == 0 || (strcmp (buf[1], "")) == 0) {
    printf ("err\n");
    return;
  }
  if (selected_row >= 0) {
    return;
  } else {
    gtk_clist_append (GTK_CLIST (*clist), buf);
    list_modified = TRUE;
  }
  gtk_entry_set_text (GTK_ENTRY (label_entry), "");
  gtk_entry_set_text (GTK_ENTRY (cmd_entry), "");
}

static void
cb_update (GtkWidget *widget, GtkWidget **clist)
{
  gchar   *buf[2];

  if (selected_row >= 0) {
    buf[0] = gkrellm_entry_get_text (&label_entry);
    buf[1] = gkrellm_entry_get_text (&cmd_entry);
    if ((strcmp (buf[0], "")) == 0 || (strcmp (buf[1], "")) == 0) {
      printf ("err\n");
      return;
    }
    gtk_clist_set_text (GTK_CLIST (*clist), selected_row, 0, buf[0]);
    gtk_entry_set_text (GTK_ENTRY (label_entry), "");
    gtk_clist_set_text (GTK_CLIST (*clist), selected_row, 1, buf[1]);
    gtk_entry_set_text (GTK_ENTRY (cmd_entry), "");

    selected_row = -1;
    list_modified = TRUE;
  }
}

static void
cb_delate (GtkWidget *widget, GtkWidget **clist)
{
  if (selected_row >= 0) {
    gtk_clist_remove (GTK_CLIST (*clist), selected_row);
    gtk_entry_set_text (GTK_ENTRY (label_entry), "");
    gtk_entry_set_text (GTK_ENTRY (cmd_entry), "");
    selected_row = -1;
    list_modified = TRUE;
  }
}

static gint
panel_button_press (GtkWidget *widget, GdkEventButton * ev, gpointer data)
{
  if (ev->button == 3) {
    gkrellm_open_config_window (monitor);
    return TRUE;
  }
  return TRUE;
}

static void
cb_button (DecalButton * button)
{
  Item    *item;
  gchar   *command;

  command = g_new0 (gchar, 100);
  item = (Item *) button->data;
  sprintf (command, "%s > /dev/null 2>&1 &", item->cmd);
  system (command);
  gkrellm_draw_panel_layers (item->panel);
}

static void
update_plugin ()
{
  Item    *item;
  GList   *list;

  for (list = mon_list; list; list = list->next) {
    item = (Item *) list->data;
    gkrellm_draw_decal_text (item->panel, item->decal_text, item->label, 0);
    gkrellm_draw_panel_layers (item->panel);
  }
}

static void
del_monitor (Item * item)
{
  g_free (item->label);
  g_free (item->cmd);
  gkrellm_panel_destroy (item->panel);
  g_free (item);
  --n_monitors;
}

static gint
panel_expose_event (GtkWidget *widget, GdkEventExpose * ev)
{
  Item    *item;
  GList   *list;

  for (list = mon_list; list; list = list->next) {
    item = (Item *) list->data;
    if (widget == item->panel->drawing_area) {
      gdk_draw_pixmap (widget->window, GK.draw1_GC,
		       item->panel->pixmap, ev->area.x, ev->area.y,
		       ev->area.x, ev->area.y, ev->area.width, ev->area.height);
      break;
    }
  }
  return FALSE;
}

static void
create_monitor (GtkWidget *vbox, Item * item, gint index, gint first_create)
{
  Style   *style;
  TextStyle *ts;
  Panel   *p;
  GdkPixmap *pixmap = NULL;
  GdkBitmap *mask = NULL;
  GdkImlibImage *im = NULL;
  gint     x, w;

  if (first_create)
    item->panel = gkrellm_panel_new0 ();
  p = item->panel;
  ++n_monitors;
  style = gkrellm_meter_style (style_id);
  x = style->margin;
  w = gkrellm_chart_width () -
    ((GdkWindowPrivate *) gkrellm_decal_misc_pixmap ())->width - style->margin;

  ts = gkrellm_meter_textstyle (style_id);
  item->decal_text = gkrellm_create_decal_text (p, "GkLauncher", ts, style, -1, -1, -1);

  gkrellm_load_image ("bled", bled_xpm, &im, STYLE_NAME);
  gkrellm_render_to_pixmap (im, &pixmap, &mask, 14, 10);
  item->decal_pix = gkrellm_create_decal_pixmap (p, pixmap, mask, 1, style, w, -1);

  gkrellm_panel_configure (p, NULL, style);
  gkrellm_panel_create (vbox, monitor, p);

  gkrellm_draw_decal_text (p, item->decal_text, item->label, button_state);
  gkrellm_put_decal_in_meter_button (p, item->decal_text, cb_button, item);
  gkrellm_draw_decal_pixmap (p, item->decal_pix, 0);

  if (first_create) {
    gtk_signal_connect (GTK_OBJECT (p->drawing_area), "expose_event",
			(GtkSignalFunc) panel_expose_event, NULL);
    gtk_signal_connect (GTK_OBJECT (p->drawing_area),
			"button_press_event", GTK_SIGNAL_FUNC (panel_button_press), NULL);
  }
}

void
apply_plugin_config (void)
{
  GList   *new_list, *old_list;
  Item    *item;
  gchar   *s;
  gint     row, need_new_monitor;

  if (!list_modified)
    return;
  new_list = NULL;
  old_list = mon_list;
  for (row = 0; row < GTK_CLIST (gk_clist)->rows; ++row) {
    if (old_list) {
      item = (Item *) old_list->data;
      item->decal_text->value = -1;
      old_list = old_list->next;
      need_new_monitor = FALSE;
    } else {
      item = g_new0 (Item, 1);
      need_new_monitor = TRUE;
    }
    gtk_clist_get_text (GTK_CLIST (gk_clist), row, 0, &s);
    gkrellm_dup_string (&item->label, s);
    gtk_clist_get_text (GTK_CLIST (gk_clist), row, 1, &s);
    gkrellm_dup_string (&item->cmd, s);
    new_list = g_list_append (new_list, item);
    if (need_new_monitor)
      create_monitor (main_vbox, item, n_monitors, TRUE);
  }
  while (old_list) {
    del_monitor ((Item *) old_list->data);
    old_list = old_list->next;
  }
  if (mon_list)
    mon_list = g_list_remove (mon_list, mon_list->data);
  mon_list = new_list;
  list_modified = FALSE;
}

void
save_plugin_config (FILE * f)
{
  GList   *list;
  Item    *item;

  for (list = mon_list; list; list = list->next) {
    item = (Item *) list->data;
    fprintf (f, "%s \"%s\" \"%s\"\n", CONFIG_KEYWORD, item->label, item->cmd);
  }
}

gchar   *
cut_quort_string (gchar * src, gchar ** endptr)
{
  gchar   *s;

  while (*src == ' ' || *src == '\t')
    ++src;

  if (*src == '"') {

    s = strchr (++src, '"');
    if (s == NULL) {
      if (endptr)
	*endptr = src;
      printf (("Unterminated quote\n"));
      return NULL;
    }

    *s = '\0';

    if (endptr)
      *endptr = s + 1;
  } else {
    for (s = src; *s != '\0' && *s != ' ' && *s != '\t'; ++s);
    if (endptr)
      *endptr = *s ? s + 1 : s;
    *s = '\0';
  }

  return src;
}

void
load_plugin_config (gchar * arg)
{
  Item    *item;
  gchar   *label, *command;

  label = (gchar *) cut_quort_string (arg, &arg);
  command = (gchar *) cut_quort_string (arg, &arg);
  item = g_new0 (Item, 1);
  item->label = g_strdup (label);
  item->cmd = g_strdup (command);
  mon_list = g_list_append (mon_list, item);

}

static void
fill_tab (GtkWidget *vbox1, GtkWidget **label_entry, GtkWidget **cmd_entry)
{
  GtkWidget *hbox1, *hbox2, *hbox3;
  GList   *list;
  Item    *item;
  gchar   *buf[2];

#ifdef _DEBUG
  g_print ("fill_tab(start)\n");
#endif
  {
     /****** hbox1 *******/
    hbox1 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox1, FALSE, FALSE, 5);
    gtk_widget_show (hbox1);
    {
      GtkWidget *label1;

      label1 = gtk_label_new ("Krell label : ");
      gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 5);
      gtk_widget_show (label1);
      *label_entry = gtk_entry_new ();
      gtk_entry_set_text (GTK_ENTRY (*label_entry), "");
      gtk_box_pack_start (GTK_BOX (hbox1), *label_entry, TRUE, TRUE, 5);
      gtk_widget_show (*label_entry);
/*        gtk_signal_connect (GTK_OBJECT (*label_entry), "changed", */
/*  			  GTK_SIGNAL_FUNC (*label_entry_changed), */
/*  			  *label_entry); */
    }
  }
     /****** end hbox1 ******/
  {
     /****** hbox2 *******/
    hbox2 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox2, FALSE, FALSE, 5);
    gtk_widget_show (hbox2);
    {
      GtkWidget *label4;

      label4 = gtk_label_new ("Command : ");
      gtk_box_pack_start (GTK_BOX (hbox2), label4, FALSE, FALSE, 5);
      gtk_widget_show (label4);
      *cmd_entry = gtk_entry_new ();
      gtk_entry_set_text (GTK_ENTRY (*cmd_entry), "");
      gtk_box_pack_start (GTK_BOX (hbox2), *cmd_entry, TRUE, TRUE, 5);
      gtk_widget_show (*cmd_entry);
    }
  }
    /****** end hbox2 *******/
  {
   /****** hbox3 *******/
    GtkWidget *button1, *button2, *button3, *button4, *button5;
    GtkWidget *arrow1, *arrow2;

    hbox3 = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox3, FALSE, FALSE, 5);
    gtk_widget_show (hbox3);
    button1 = gtk_button_new ();
    gtk_box_pack_start (GTK_BOX (hbox3), button1, FALSE, FALSE, 5);
    gtk_widget_set_usize (button1, 60, 30);
    gtk_widget_show (button1);
    gtk_signal_connect (GTK_OBJECT (button1), "clicked",
			(GtkSignalFunc) cb_up, &gk_clist);
    arrow1 = gtk_arrow_new (GTK_ARROW_UP, GTK_SHADOW_ETCHED_OUT);
    gtk_container_add (GTK_CONTAINER (button1), arrow1);
    button2 = gtk_button_new ();
    gtk_box_pack_start (GTK_BOX (hbox3), button2, FALSE, FALSE, 5);
    gtk_widget_set_usize (button2, 60, 30);
    gtk_widget_show (button2);
    gtk_signal_connect (GTK_OBJECT (button2), "clicked",
			(GtkSignalFunc) cb_down, &gk_clist);
    arrow2 = gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_ETCHED_OUT);
    gtk_container_add (GTK_CONTAINER (button2), arrow2);
    button3 = gtk_button_new_with_label ("Add");
    gtk_box_pack_start (GTK_BOX (hbox3), button3, FALSE, FALSE, 5);
    gtk_widget_set_usize (button3, 60, 30);
    gtk_widget_show (button3);
    gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			GTK_SIGNAL_FUNC (cb_enter), &gk_clist);
    button4 = gtk_button_new_with_label ("Update");
    gtk_box_pack_start (GTK_BOX (hbox3), button4, FALSE, FALSE, 5);
    gtk_widget_set_usize (button4, 60, 30);
    gtk_widget_show (button4);
    gtk_signal_connect (GTK_OBJECT (button4), "clicked",
			GTK_SIGNAL_FUNC (cb_update), &gk_clist);
    button5 = gtk_button_new_with_label ("Delate");
    gtk_box_pack_start (GTK_BOX (hbox3), button5, FALSE, FALSE, 5);
    gtk_widget_set_usize (button5, 60, 30);
    gtk_widget_show (button5);
    gtk_signal_connect (GTK_OBJECT (button5), "clicked",
			GTK_SIGNAL_FUNC (cb_delate), &gk_clist);
  }
   /****** end hbox3 *******/
  {
    GtkWidget *scrolledwindow1;
    GtkWidget *label2, *label3;

    scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
    gtk_box_pack_start (GTK_BOX (vbox1), scrolledwindow1, TRUE, TRUE, 0);
    gtk_widget_show (scrolledwindow1);
    gk_clist = gtk_clist_new (2);
    gtk_container_add (GTK_CONTAINER (scrolledwindow1), gk_clist);
    gtk_clist_set_column_width (GTK_CLIST (gk_clist), 0, 80);
    gtk_clist_set_column_width (GTK_CLIST (gk_clist), 1, 80);
    gtk_clist_column_titles_show (GTK_CLIST (gk_clist));
    gtk_widget_show (gk_clist);
    gtk_signal_connect (GTK_OBJECT (gk_clist), "select_row",
			GTK_SIGNAL_FUNC (cb_selected), &gk_clist);
    gtk_signal_connect (GTK_OBJECT (gk_clist), "unselect_row",
			GTK_SIGNAL_FUNC (cb_unselected), &gk_clist);
    label2 = gtk_label_new ("label");
    gtk_clist_set_column_widget (GTK_CLIST (gk_clist), 0, label2);
    gtk_widget_show (label2);
    label3 = gtk_label_new ("command");
    gtk_clist_set_column_widget (GTK_CLIST (gk_clist), 1, label3);
    gtk_widget_show (label3);
  }
  for (list = mon_list; list; list = list->next) {
    item = (Item *) list->data;
    buf[0] = item->label;
    buf[1] = item->cmd;
    gtk_clist_append (GTK_CLIST (gk_clist), buf);
  }

}

static void
create_plugin (GtkWidget *vbox, gint first_create)
{
  GList   *list;
  Item    *item;
  gint     i;

  if (main_vbox == NULL) {
    main_vbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), main_vbox, FALSE, FALSE, 0);
    gtk_widget_show (main_vbox);
  }
  n_monitors = 0;
  for (i = 0, list = mon_list; list; ++i, list = list->next) {
    item = (Item *) list->data;
    create_monitor (main_vbox, item, i, first_create);
  }

}

static gchar *plugin_info_text[] = {
  "GkLauncher -- a plugin fot GKrellM -- version 0.0.1\n",
  "\n",
  "<b>How to use GkLauncher\n",
  "  Label box ϼºݤɽʸǤ\n",
  "  Command box  Label 򥯥åȤ˵ư ޥɤǤ\n",
  "\n",
  "<b>ƥɲ\n",
  "  ƥɲäˤ Label box, Command box ŬڤͤϤ Add ܥ򥯥åƤ\n",
  "<b>ƥκ\n",
  "  List box κƥDelate ܥ򥯥åƤ\n",
  "<b>ƥι\n",
  "  List box ιƥƤѹ Update ܥ򥯥åƤ\n",
  "<b>ƥΰư\n",
  "  List box ΰưƥܥǰư"
};

static void
create_plugin_tab (GtkWidget *tab_vbox)
{
  GtkWidget *tabs;
  GtkWidget *vbox1;
  GtkWidget *text;
  gint     i;

  list_modified = FALSE;
  /* Make a couple of tabs.  One for setup and one for info
   */
  tabs = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (tabs), GTK_POS_TOP);
  gtk_box_pack_start (GTK_BOX (tab_vbox), tabs, TRUE, TRUE, 0);
/* --Setup tab */
  vbox1 = gkrellm_create_framed_tab (tabs, "Setup");
  /* Replace this single button with your configuration widgets */

  fill_tab (vbox1, &label_entry, &cmd_entry);
/* --Info tab */
  vbox1 = gkrellm_create_framed_tab (tabs, "Info");
  text = gkrellm_scrolled_text (vbox1, NULL, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  for (i = 0; i < sizeof (plugin_info_text)
       / sizeof (gchar *); ++i)
    gkrellm_add_info_text_string (text, plugin_info_text[i]);
}

/* The monitor structure tells GKrellM how to call the plugin routines.
*/
static Monitor plugin_mon = {
  CONFIG_NAME,		/* Name, for config tab.    */
  0,			/* Id,  0 if a plugin       */
  create_plugin,	/* The create function      */
  update_plugin,	/* The update function      */
  create_plugin_tab,	/* The config tab create function   */
  apply_plugin_config,	/* Apply the config function        */
  save_plugin_config,	/* Save user config                     */
  load_plugin_config,	/* Load user config                     */
  CONFIG_KEYWORD,	/* config keyword                       */
  NULL,			/* Undefined 2  */
  NULL,			/* Undefined 1  */
  NULL,			/* private              */
  PLUGIN_PLACEMENT,	/* Insert plugin before this monitor                    */
  NULL,			/* Handle if a plugin, filled in by GKrellM     */
  NULL			/* path if a plugin, filled in by GKrellM       */
};

	/* All GKrellM plugins must have one global routine named init_plugin()
	   |  which returns a pointer to a filled in monitor structure.
	 */
Monitor *
init_plugin ()
{

  style_id = gkrellm_add_meter_style (&plugin_mon, STYLE_NAME);
  monitor = &plugin_mon;

  return &plugin_mon;
}
