/*
 * Decompiled with CFR 0.152.
 */
package org.ginkgo.gcov.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.ginkgo.gcov.parser.IParser;

public class LineCoverageParser
implements IParser {
    public static final String UNCOVER_MARKER_TYPE = "org.ginkgo.gcov.lineUnCoverMarker";
    public static final String COVER_MARKER_TYPE = "org.ginkgo.gcov.lineCoverMarker";
    public static final String COVERAGE_MARKER_TYPE = "org.ginkgo.gcov.CoverageMarker";
    private String consoleName = "onsole";
    private IFile sourceFile = null;

    private MessageConsole getConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        MessageConsole messageConsole = null;
        IConsole[] iConsoleArray = consoles;
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (console.getName().equals(this.consoleName)) {
                messageConsole = (MessageConsole)console;
                break;
            }
            ++n2;
        }
        if (messageConsole == null) {
            messageConsole = new MessageConsole(this.consoleName, null);
        }
        manager.addConsoles(new IConsole[]{messageConsole});
        return messageConsole;
    }

    @Override
    public void parse(IFile file) {
        String lineNum = null;
        String execCount = null;
        String line = null;
        this.sourceFile = null;
        IProject project = file.getProject();
        String sourceFileName = file.getName().replaceAll("\\.gcov", "");
        try {
            project.accept((IResourceVisitor)new MyResourceVisitor(sourceFileName));
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        System.out.println(this.sourceFile);
        if (this.sourceFile == null) {
            System.out.println("null!!");
            return;
        }
        LineCoverageParser.deleteMarkers(this.sourceFile);
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(file.getContents()));
            while ((line = in.readLine()) != null) {
                HashMap attributes;
                String[] s = line.split(":");
                if (s.length != 3) continue;
                execCount = s[0].trim();
                lineNum = s[1].trim();
                if (execCount.equals("#####")) {
                    attributes = new HashMap();
                    MarkerUtilities.setMessage(attributes, (String)"Not Covered");
                    MarkerUtilities.setLineNumber(attributes, (int)Integer.parseInt(lineNum));
                    MarkerUtilities.createMarker((IResource)this.sourceFile, attributes, (String)UNCOVER_MARKER_TYPE);
                    continue;
                }
                if (execCount.equals("-")) continue;
                attributes = new HashMap();
                MarkerUtilities.setMessage(attributes, (String)execCount);
                MarkerUtilities.setLineNumber(attributes, (int)Integer.parseInt(lineNum));
                MarkerUtilities.createMarker((IResource)this.sourceFile, attributes, (String)COVER_MARKER_TYPE);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void deleteMarkers(IFile file) {
        try {
            file.deleteMarkers(COVER_MARKER_TYPE, true, 0);
            file.deleteMarkers(UNCOVER_MARKER_TYPE, true, 0);
        }
        catch (CoreException coreException) {}
    }

    private class MyResourceVisitor
    implements IResourceVisitor {
        private String sourceFileName;

        private MyResourceVisitor(String FileName) {
            this.sourceFileName = FileName;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getName().equals(this.sourceFileName)) {
                LineCoverageParser.this.sourceFile = (IFile)resource;
                return false;
            }
            return true;
        }
    }
}

