/*
 * Decompiled with CFR 0.152.
 */
package thread;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import mkgethtml.GetHtmlCsMix;
import mkgethtml.GetHtmlCss;
import models.Chapter;
import thread.TAuto;
import utils.CommonValue;

public class MutilDownload
implements Runnable {
    int start;
    int end;
    int type;
    int threadID;
    String fileName;
    String cssChapterTitle = "";
    String cssChapterContent = "";
    String cssRemoveContent = "";
    Boolean isChapterLinkAsolute = true;
    Boolean isEnableChapterSign = false;
    Boolean isForumType = false;
    Boolean isUseHttpURLConnection = true;
    Thread t = null;
    Path pHead;
    Path pContent;
    Path pIndex;
    Path pSingle;
    Path pIndexBak;
    OutputStreamWriter oswHead = null;
    OutputStreamWriter oswContent = null;
    OutputStreamWriter oswSingle = null;
    RandomAccessFile ranIndex = null;
    RandomAccessFile ranIndexBak = null;
    TAuto tAuto;
    final Object lockO = new Object();

    public MutilDownload(int start, int end, int id, String fileName, int type, TAuto tAuto) {
        this.start = start;
        this.end = end;
        this.fileName = fileName;
        this.type = type;
        this.threadID = id;
        this.tAuto = tAuto;
        this.t = new Thread(this);
        this.pHead = Paths.get(tAuto.storyTempFolder, "AH" + this.threadID + fileName);
        this.pContent = Paths.get(tAuto.storyTempFolder, "C" + this.threadID + fileName);
        this.pIndex = Paths.get(tAuto.storyTempFolder, "INDEX" + this.threadID + ".txt");
        this.pIndexBak = Paths.get(tAuto.storyTempFolder, "INDEX" + this.threadID + ".bak.txt");
        try {
            if (!tAuto.isDivideFile.booleanValue()) {
                this.oswHead = new OutputStreamWriter((OutputStream)new FileOutputStream(this.pHead.toString(), true), Charset.forName(tAuto.encoding));
                this.oswContent = new OutputStreamWriter((OutputStream)new FileOutputStream(this.pContent.toString(), true), Charset.forName(tAuto.encoding));
                this.ranIndex = new RandomAccessFile(this.pIndex.toFile(), "rw");
                this.ranIndexBak = new RandomAccessFile(this.pIndexBak.toFile(), "rw");
            } else {
                this.pSingle = Paths.get(tAuto.folderMutilFilePath, new String[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cancel() {
        if (this.t != null) {
            this.t.checkAccess();
            this.t.interrupt();
            this.t = null;
            try {
                if (this.ranIndex != null) {
                    this.ranIndex.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.ranIndexBak != null) {
                    this.ranIndexBak.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.oswHead != null) {
                    this.oswHead.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.oswContent != null) {
                    this.oswContent.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.oswSingle != null) {
                    this.oswSingle.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        this.cssChapterTitle = this.tAuto.p.getCssQueryGetChapterTitle();
        this.cssChapterContent = this.tAuto.p.getCssQueryGetChapterContent();
        this.cssRemoveContent = this.tAuto.p.getCssFilter();
        this.isChapterLinkAsolute = this.tAuto.p.getIsChapterLinkAsolute();
        this.isEnableChapterSign = this.tAuto.p.getIsEnableChapterSign();
        this.isForumType = this.tAuto.p.getIsForumType();
        this.isUseHttpURLConnection = this.tAuto.p.getIsUseJsoupGet();
        String sPageCode = this.tAuto.p.getPageCode().toLowerCase();
        try {
            try {
                int i = this.start;
                while (i < this.end) {
                    Chapter c = new Chapter();
                    if (this.isForumType.booleanValue()) {
                        c = GetHtmlCsMix.getChapterTitleAndContentOfForum(i, this.tAuto.listChapter.get(i), this.cssChapterTitle, this.cssChapterContent, this.cssRemoveContent, this.isEnableChapterSign);
                    } else if (sPageCode.equals("sstruyen.com")) {
                        c = GetHtmlCsMix.getChapterTitleAndContentSSTruyen(i, this.tAuto.listChapter.get(i), this.cssChapterTitle, this.cssChapterContent, this.isEnableChapterSign);
                    } else if (sPageCode.equals("tangthucac.com")) {
                        c = GetHtmlCsMix.getChapterTitleTangThuCacDotCom(this.tAuto.txtUrl, i + 1, this.tAuto.listChapter.get(i), this.cssChapterTitle, this.cssChapterContent, this.cssRemoveContent, this.isEnableChapterSign);
                    } else if (sPageCode.equals("truyencv.com")) {
                        c = GetHtmlCss.getChapterTitleAndContent(i, this.tAuto.listChapter.get(i), this.cssChapterTitle, this.cssChapterContent, this.cssRemoveContent, this.isEnableChapterSign, this.isUseHttpURLConnection);
                        if (c.getIsHasCapchaBlock().booleanValue()) {
                            if (this.tAuto.isDoneCapcha.booleanValue()) {
                                this.tAuto.isDoneCapcha = false;
                                this.tAuto.isShowDoCapchaDiaglog = false;
                            }
                            Chapter check = this.tAuto.checkGoogleRecapcha(c, i, this.cssChapterTitle, this.cssChapterContent, this.cssRemoveContent, this.isEnableChapterSign);
                            Thread.sleep(200L);
                            if (check != null) {
                                c = check;
                            }
                        }
                    } else {
                        c = GetHtmlCss.getChapterTitleAndContent(i, this.tAuto.listChapter.get(i), this.cssChapterTitle, this.cssChapterContent, this.cssRemoveContent, this.isEnableChapterSign, this.isUseHttpURLConnection);
                    }
                    if (!this.tAuto.isDivideFile.booleanValue()) {
                        if (!c.getTitle().isEmpty()) {
                            if (this.isForumType.booleanValue()) {
                                this.oswHead.write(c.getTitle());
                            } else {
                                this.oswHead.write(CommonValue.getAnchorIDandTitle(i, c.getTitle()));
                            }
                        }
                        this.oswContent.write(c.getContent());
                        if (i > -1) {
                            String value = String.valueOf(i);
                            this.ranIndex.setLength(0L);
                            this.ranIndex.writeBytes(value);
                            this.ranIndexBak.setLength(0L);
                            this.ranIndexBak.writeBytes(value);
                        }
                    } else {
                        Path saveSingle = Paths.get(this.tAuto.folderMutilFilePath, String.valueOf(this.tAuto.fileNameWithoutExtension) + "-" + String.valueOf(i + 1) + this.tAuto.extension);
                        if (this.tAuto.extension == ".txt") {
                            c.setTitle(this.tAuto.removeHtmlString(c.getTitle()));
                            c.setContent(this.tAuto.removeHtmlString(c.getContent()));
                        }
                        if (!c.getContent().contains(c.getTitle())) {
                            if (this.tAuto.extension == ".txt") {
                                c.setContent(String.valueOf(c.getTitle()) + TAuto.lineBreak + c.getContent());
                            } else {
                                c.setContent(String.valueOf(c.getTitle()) + "<br/>" + c.getContent());
                            }
                        }
                        this.oswSingle = new OutputStreamWriter((OutputStream)new FileOutputStream(saveSingle.toFile()), Charset.forName(this.tAuto.encoding));
                        if (this.tAuto.extension == ".txt") {
                            this.oswSingle.write(c.getContent());
                        } else {
                            this.oswSingle.write(CommonValue.getHtmlOpenString(String.valueOf(c.getTitle()) + " - " + this.tAuto.storyTitle));
                            this.oswSingle.write(c.getContent());
                            this.oswSingle.write(CommonValue.getHtmlCloseString());
                        }
                        this.oswSingle.close();
                    }
                    this.tAuto.updateUICount(c.getTitle(), this.threadID, i);
                    Thread.sleep(CommonValue.SLEEP_TIME);
                    ++i;
                }
            }
            catch (IOException | InterruptedException e) {
                try {
                    if (this.ranIndex != null) {
                        this.ranIndex.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.ranIndexBak != null) {
                        this.ranIndexBak.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.oswHead != null) {
                        this.oswHead.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.oswContent != null) {
                        this.oswContent.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.oswSingle != null) {
                        this.oswSingle.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                e.printStackTrace();
                this.tAuto.log.append(e.getMessage());
                this.tAuto.log.setCaretPosition(this.tAuto.log.getDocument().getLength());
                try {
                    if (this.ranIndex != null) {
                        this.ranIndex.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.ranIndexBak != null) {
                        this.ranIndexBak.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.oswHead != null) {
                        this.oswHead.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.oswContent != null) {
                        this.oswContent.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (this.oswSingle != null) {
                        this.oswSingle.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.tAuto.checkFinish();
            }
        }
        finally {
            try {
                if (this.ranIndex != null) {
                    this.ranIndex.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.ranIndexBak != null) {
                    this.ranIndexBak.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.oswHead != null) {
                    this.oswHead.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.oswContent != null) {
                    this.oswContent.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                if (this.oswSingle != null) {
                    this.oswSingle.close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.tAuto.checkFinish();
        }
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }
}

