/*
 * Decompiled with CFR 0.152.
 */
package mkbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class SimpleSwingBrowser
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private final JPanel panel = new JPanel(new BorderLayout());
    private final JLabel lblStatus = new JLabel();
    private final JButton btnGo = new JButton("Go");
    private final JTextField txtURL = new JTextField();
    private final JProgressBar progressBar = new JProgressBar();

    public SimpleSwingBrowser() {
        this.initComponents();
    }

    private void initComponents() {
        this.createScene();
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSwingBrowser.this.loadURL(SimpleSwingBrowser.this.txtURL.getText());
            }
        };
        this.btnGo.addActionListener(al);
        this.txtURL.addActionListener(al);
        this.progressBar.setPreferredSize(new Dimension(150, 18));
        this.progressBar.setStringPainted(true);
        JPanel topBar = new JPanel(new BorderLayout(5, 0));
        topBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        topBar.add((Component)this.txtURL, "Center");
        topBar.add((Component)this.btnGo, "East");
        JPanel statusBar = new JPanel(new BorderLayout(5, 0));
        statusBar.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        statusBar.add((Component)this.lblStatus, "Center");
        statusBar.add((Component)this.progressBar, "East");
        this.panel.add((Component)topBar, "North");
        this.panel.add((Component)this.jfxPanel, "Center");
        this.panel.add((Component)statusBar, "South");
        this.getContentPane().add(this.panel);
        this.setPreferredSize(new Dimension(1024, 600));
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                SimpleSwingBrowser.this.engine = view.getEngine();
                SimpleSwingBrowser.this.engine.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> observable, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowser.this.setTitle(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowser.this.engine.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

                    public void handle(final WebEvent<String> event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowser.this.lblStatus.setText((String)event.getData());
                            }
                        });
                    }
                });
                SimpleSwingBrowser.this.engine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> ov, String oldValue, final String newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowser.this.txtURL.setText(newValue);
                            }
                        });
                    }
                });
                SimpleSwingBrowser.this.engine.getLoadWorker().workDoneProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                    public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, final Number newValue) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SimpleSwingBrowser.this.progressBar.setValue(newValue.intValue());
                            }
                        });
                    }
                });
                SimpleSwingBrowser.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, final Throwable value) {
                        if (SimpleSwingBrowser.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(SimpleSwingBrowser.this.panel, value != null ? String.valueOf(SimpleSwingBrowser.this.engine.getLocation()) + "\n" + value.getMessage() : String.valueOf(SimpleSwingBrowser.this.engine.getLocation()) + "\nUnexpected error.", "Loading error...", 0);
                                }
                            });
                        }
                    }
                });
                SimpleSwingBrowser.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String tmp = SimpleSwingBrowser.toURL(url);
                if (tmp == null) {
                    tmp = SimpleSwingBrowser.toURL("http://" + url);
                }
                SimpleSwingBrowser.this.engine.load(tmp);
            }
        });
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleSwingBrowser browser = new SimpleSwingBrowser();
                browser.setVisible(true);
                browser.loadURL("http://oracle.com");
            }
        });
    }
}

