/*
 * Decompiled with CFR 0.152.
 */
package mkbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Locale;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import mkbrowser.MiniBrowserController;
import mkgethtml.Config;
import mkgethtml.Enumeration;

public class MKBrowser
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private final JFXPanel jfxPanel = new JFXPanel();
    private MiniBrowserController controller = null;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MKBrowser frame = new MKBrowser();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MKBrowser() {
        this.setDefaultCloseOperation(2);
        this.initComponent();
    }

    private void initComponent() {
        Locale.setDefault(new Locale(Config.get(Enumeration.EnumConfigKey.LANGUAGE).toString()));
        this.createScene();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(MKBrowser.class.getResource("/resource/box-16.png")));
        this.setBounds(100, 100, 850, 470);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.contentPane.add((Component)this.jfxPanel, "Center");
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FXMLLoader loader = new FXMLLoader(this.getClass().getResource("fxml/mkbrowser.fxml"));
                    Parent root = (Parent)loader.load();
                    Scene scene = new Scene(root, 700.0, 400.0);
                    scene.setUserData((Object)loader);
                    MKBrowser.this.jfxPanel.setScene(scene);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void loadURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FXMLLoader loader;
                MKBrowser.this.jfxPanel.requestFocus();
                if (MKBrowser.this.controller == null && (loader = (FXMLLoader)MKBrowser.this.jfxPanel.getScene().getUserData()) != null) {
                    MKBrowser.this.controller = (MiniBrowserController)loader.getController();
                }
                if (MKBrowser.this.controller != null) {
                    MKBrowser.this.controller.loadAddressOnFirst(url);
                }
            }
        });
    }
}

