/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.eclipse.wb.swing.FocusTraversalOnArray;
import resource.text.Messages;

public class FindAndReplace
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField txtSearch;
    private JTextField txtReplace;
    private JLabel lblStatus;
    private JButton btnCacel;
    private JButton btnReplace;
    private JButton btnReplaceAll;
    private JButton btnFind;
    JTextArea text;
    private JPanel panel;
    private JRadioButton rdbtnSearchUp;
    private JRadioButton rdbtnSearchDown;
    private int currentPos = -1;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FindAndReplace frame = new FindAndReplace();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public FindAndReplace() {
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(2);
        this.init();
    }

    public FindAndReplace(JTextArea text) {
        this.init();
        this.text = text;
        this.setAlwaysOnTop(true);
    }

    void findText() {
        if (this.rdbtnSearchDown.isSelected()) {
            this.currentPos = this.text.getText().indexOf(this.txtSearch.getText(), this.currentPos + 1);
        } else if (this.currentPos > -1) {
            try {
                this.currentPos = this.text.getText(0, this.currentPos).lastIndexOf(this.txtSearch.getText());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            this.currentPos = this.text.getText().lastIndexOf(this.txtSearch.getText());
        }
        if (this.currentPos > -1) {
            if (this.lblStatus.isVisible() && JOptionPane.showConfirmDialog(null, String.valueOf(this.rdbtnSearchDown.isSelected() ? Messages.getString("CopyRightInfo.endOfText") : Messages.getString("CopyRightInfo.startOfText")) + Messages.getString("CopyRightInfo.stringNotFound"), "Search", 0, 3) == 0) {
                this.lblStatus.setVisible(false);
                this.currentPos = -1;
            } else {
                this.lblStatus.setVisible(false);
                this.text.requestFocus();
                this.text.setCaretPosition(this.currentPos);
                this.text.select(this.currentPos, this.currentPos + this.txtSearch.getText().length());
            }
        } else {
            this.lblStatus.setVisible(true);
            this.lblStatus.setText(String.format(Messages.getString("CopyRightInfo.statusNotFound"), this.txtSearch.getText()));
        }
    }

    void init() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        this.setTitle(Messages.getString("FindAndReplace.this.title"));
        this.setResizable(false);
        this.setBounds(100, 100, 453, 166);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        JLabel lblFindWhat = new JLabel(Messages.getString("FindAndReplace.lblFindWhat.text"));
        JLabel lblReplaceWith = new JLabel(Messages.getString("FindAndReplace.lblReplaceWith.text"));
        this.txtSearch = new JTextField();
        this.txtSearch.setText(Messages.getString("FindAndReplace.txtSearch.text"));
        this.txtSearch.setColumns(10);
        this.txtReplace = new JTextField();
        this.txtReplace.setHorizontalAlignment(2);
        this.txtReplace.setText(Messages.getString("FindAndReplace.txtReplace.text"));
        this.txtReplace.setColumns(10);
        this.btnFind = new JButton(Messages.getString("FindAndReplace.btnFind.text"));
        this.btnFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplace.this.findText();
            }
        });
        this.btnReplace = new JButton(Messages.getString("FindAndReplace.btnReplace.text"));
        this.btnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplace.this.replaceText();
            }
        });
        this.btnReplaceAll = new JButton(Messages.getString("FindAndReplace.btnReplaceAll.text"));
        this.btnReplaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplace.this.replaceAllText();
            }
        });
        this.btnCacel = new JButton(Messages.getString("FindAndReplace.btnCacel.text"));
        this.btnCacel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindAndReplace.this.setVisible(false);
                FindAndReplace.this.dispose();
            }
        });
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("2dlu"), ColumnSpec.decode("67px"), ColumnSpec.decode("2dlu"), ColumnSpec.decode("224px:grow"), ColumnSpec.decode("2dlu"), ColumnSpec.decode("115px")}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("top:max(24dlu;min)"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px")}));
        this.lblStatus = new JLabel(Messages.getString("FindAndReplace.lblStatus.text"));
        this.lblStatus.setVisible(false);
        this.panel = new JPanel();
        this.panel.setBorder(new TitledBorder(null, Messages.getString("FindAndReplace.panel.borderTitle"), 1, 2, null, null));
        this.contentPane.add((Component)this.panel, "4, 6, left, top");
        this.rdbtnSearchDown = new JRadioButton(Messages.getString("FindAndReplace.rdbtnSearchDown.text"));
        this.rdbtnSearchDown.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FindAndReplace.this.lblStatus.setVisible(false);
            }
        });
        this.panel.setLayout(new FormLayout(new ColumnSpec[]{FormSpecs.UNRELATED_GAP_COLSPEC, ColumnSpec.decode("89px"), FormSpecs.LABEL_COMPONENT_GAP_COLSPEC, ColumnSpec.decode("75px")}, new RowSpec[]{FormSpecs.MIN_ROWSPEC}));
        this.rdbtnSearchDown.setSelected(true);
        this.panel.add((Component)this.rdbtnSearchDown, "2, 1, left, top");
        this.rdbtnSearchUp = new JRadioButton(Messages.getString("FindAndReplace.rdbtnSearchUp.text"));
        this.rdbtnSearchUp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FindAndReplace.this.lblStatus.setVisible(false);
            }
        });
        this.panel.add((Component)this.rdbtnSearchUp, "4, 1, left, top");
        ButtonGroup searchChoose = new ButtonGroup();
        searchChoose.add(this.rdbtnSearchDown);
        searchChoose.add(this.rdbtnSearchUp);
        this.lblStatus.setForeground(new Color(220, 20, 60));
        this.contentPane.add((Component)this.lblStatus, "2, 8, 3, 1, fill, bottom");
        this.contentPane.add((Component)this.btnCacel, "6, 8, fill, top");
        this.contentPane.add((Component)lblReplaceWith, "2, 4, right, center");
        this.contentPane.add((Component)lblFindWhat, "2, 2, right, center");
        this.contentPane.add((Component)this.txtSearch, "4, 2, fill, center");
        this.contentPane.add((Component)this.txtReplace, "4, 4, fill, fill");
        this.contentPane.add((Component)this.btnFind, "6, 2, fill, top");
        this.contentPane.add((Component)this.btnReplaceAll, "6, 6, fill, top");
        this.contentPane.add((Component)this.btnReplace, "6, 4, fill, top");
        this.contentPane.setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{this.txtReplace, this.txtSearch, this.btnFind, this.btnReplace, this.btnReplaceAll, this.btnCacel}));
    }

    void replaceAllText() {
        this.findText();
        if (!this.lblStatus.isVisible()) {
            this.text.setText(this.text.getText().replaceAll(this.txtSearch.getText(), this.txtReplace.getText()));
        } else {
            this.lblStatus.setVisible(true);
            this.lblStatus.setText(String.format(Messages.getString("CopyRightInfo.statusNotFound"), this.txtSearch.getText()));
        }
    }

    void replaceText() {
        if (!this.lblStatus.isVisible() && this.currentPos > -1) {
            this.text.replaceSelection(this.txtReplace.getText());
            this.btnFind.doClick();
        } else {
            this.lblStatus.setVisible(true);
            this.lblStatus.setText(String.format(Messages.getString("CopyRightInfo.statusNotFound"), this.txtSearch.getText()));
        }
    }
}

