/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpecs;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EtchedBorder;
import main.PreviewHtml;
import mkgethtml.Config;
import mkgethtml.Enumeration;
import org.eclipse.wb.swing.FocusTraversalOnArray;
import resource.text.Messages;
import utils.CommonValue;

public class CopyRightInfo
extends JFrame {
    private static final long serialVersionUID = -4908021877809214828L;
    private JPanel contentPane;
    private JTextField txtEbookCreator;
    private JTextField txtSource;
    private JTextPane txtInfo;
    private JTextPane txtConverter;
    public String ebookInfo;
    private JTextField txtAuthor;
    private JTextField txtName;
    private JTextField txtStatus;
    private JButton btnDownloadInit;
    private PreviewHtml preview;
    private Boolean isShowPreview = false;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CopyRightInfo frame = new CopyRightInfo();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public CopyRightInfo() {
        this.init();
    }

    public CopyRightInfo(JButton btnDownload) {
        this.init();
        this.btnDownloadInit = btnDownload;
        this.ebookInfo = "";
    }

    void init() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e2) {
            e2.printStackTrace();
        }
        Locale.setDefault(new Locale(Config.get(Enumeration.EnumConfigKey.LANGUAGE).toString()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                CopyRightInfo.this.txtEbookCreator.setText(Config.get(Enumeration.EnumConfigKey.EBOOKCREATOR).toString());
                CopyRightInfo.this.txtConverter.setText(Config.get(Enumeration.EnumConfigKey.CONVERTER).toString());
                CopyRightInfo.this.txtSource.setText(Config.get(Enumeration.EnumConfigKey.SOURCE).toString());
                CopyRightInfo.this.txtAuthor.setText(Config.get(Enumeration.EnumConfigKey.AUTHOR).toString());
                CopyRightInfo.this.txtName.setText(Config.get(Enumeration.EnumConfigKey.EBOOKNAME).toString());
                CopyRightInfo.this.txtStatus.setText(Config.get(Enumeration.EnumConfigKey.STATUS).toString());
                String sInfo = Config.get(Enumeration.EnumConfigKey.INFO).toString();
                if (sInfo.isEmpty()) {
                    CopyRightInfo.this.txtInfo.setText(String.format(Messages.getGlobalString("text.ebookIntro"), CommonValue.getAppName()));
                } else {
                    CopyRightInfo.this.txtInfo.setText(sInfo);
                }
                CopyRightInfo.this.txtEbookCreator.setFocusable(true);
            }
        });
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(CopyRightInfo.class.getResource("/resource/box-16.png")));
        this.setTitle(Messages.getString("CopyRightInfo.this.title"));
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 600, 460);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EtchedBorder(1, null, null));
        this.setContentPane(this.contentPane);
        JScrollPane scrollPane = new JScrollPane();
        JLabel lblEbookCreator = new JLabel(Messages.getString("CopyRightInfo.lblEbookCreator.text"));
        JLabel lblConverter = new JLabel(Messages.getString("CopyRightInfo.lblConverter.text"));
        JLabel lblSource = new JLabel(Messages.getString("CopyRightInfo.lblSource.text"));
        this.txtEbookCreator = new JTextField();
        this.txtEbookCreator.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        this.txtEbookCreator.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                CopyRightInfo.this.txtEbookCreator.selectAll();
            }
        });
        this.txtEbookCreator.setColumns(10);
        this.txtSource = new JTextField();
        this.txtSource.setColumns(10);
        this.txtSource.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CopyRightInfo.this.txtSource.selectAll();
            }
        });
        this.txtSource.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        final JButton btnDownload = new JButton(Messages.getString("CopyRightInfo.btnDownload.text"));
        btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyRightInfo.this.getEbookInfo();
                CopyRightInfo.this.setVisible(false);
                if (CopyRightInfo.this.preview != null) {
                    CopyRightInfo.this.preview.setVisible(false);
                    CopyRightInfo.this.preview.dispose();
                    CopyRightInfo.this.preview = null;
                }
                CopyRightInfo.this.btnDownloadInit.doClick();
            }
        });
        JButton btnSave = new JButton(Messages.getString("CopyRightInfo.btnSave.text"));
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Config.put(Enumeration.EnumConfigKey.EBOOKCREATOR, CopyRightInfo.this.txtEbookCreator.getText());
                Config.put(Enumeration.EnumConfigKey.CONVERTER, CopyRightInfo.this.txtConverter.getText());
                Config.put(Enumeration.EnumConfigKey.SOURCE, CopyRightInfo.this.txtSource.getText());
                Config.put(Enumeration.EnumConfigKey.AUTHOR, CopyRightInfo.this.txtAuthor.getText());
                Config.put(Enumeration.EnumConfigKey.EBOOKNAME, CopyRightInfo.this.txtName.getText());
                Config.put(Enumeration.EnumConfigKey.STATUS, CopyRightInfo.this.txtStatus.getText());
                Config.put(Enumeration.EnumConfigKey.INFO, CopyRightInfo.this.txtInfo.getText());
                Config.saveConfig();
                btnDownload.doClick();
            }
        });
        JLabel lblIntro = new JLabel(Messages.getString("CopyRightInfo.lblIntro.text"));
        JLabel lblAuthor = new JLabel(Messages.getString("CopyRightInfo.lblAuthor.text"));
        JLabel lblName = new JLabel(Messages.getString("CopyRightInfo.lblName.text"));
        JLabel lblStatus = new JLabel(Messages.getString("CopyRightInfo.lblStatus.text"));
        this.txtAuthor = new JTextField();
        this.txtAuthor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CopyRightInfo.this.txtAuthor.selectAll();
            }
        });
        this.txtAuthor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        this.txtAuthor.setText("");
        this.txtAuthor.setColumns(10);
        this.txtName = new JTextField();
        this.txtName.setText("");
        this.txtName.setColumns(10);
        this.txtName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CopyRightInfo.this.txtAuthor.selectAll();
            }
        });
        this.txtName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        this.txtStatus = new JTextField();
        this.txtStatus.setText("");
        this.txtStatus.setColumns(10);
        this.txtStatus.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CopyRightInfo.this.txtStatus.selectAll();
            }
        });
        this.txtStatus = new JTextField();
        this.txtStatus.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        JLabel lblcanBeHtml = new JLabel(Messages.getString("CopyRightInfo.lblcanBeHtml.text"));
        lblcanBeHtml.setForeground(SystemColor.textHighlight);
        this.txtInfo = new JTextPane();
        this.txtInfo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CopyRightInfo.this.txtInfo.selectAll();
            }
        });
        this.txtInfo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        scrollPane.setViewportView(this.txtInfo);
        this.contentPane.setLayout(new FormLayout(new ColumnSpec[]{ColumnSpec.decode("2dlu"), ColumnSpec.decode("79px"), ColumnSpec.decode("2dlu"), ColumnSpec.decode("238px:grow"), ColumnSpec.decode("2dlu"), ColumnSpec.decode("135px")}, new RowSpec[]{FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("23px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("90px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("20px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("20px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("20px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("20px"), FormSpecs.LABEL_COMPONENT_GAP_ROWSPEC, RowSpec.decode("14px:grow"), RowSpec.decode("14px")}));
        JButton btnClean = new JButton(Messages.getString("CopyRightInfo.btnClean.text"));
        btnClean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CopyRightInfo.this.txtConverter.setText("");
                CopyRightInfo.this.txtSource.setText("");
                CopyRightInfo.this.txtInfo.setText("");
                CopyRightInfo.this.txtAuthor.setText("");
                CopyRightInfo.this.txtName.setText("");
                CopyRightInfo.this.txtStatus.setText("");
            }
        });
        JScrollPane scrollPane_1 = new JScrollPane();
        this.contentPane.add((Component)scrollPane_1, "4, 4, fill, fill");
        this.txtConverter = new JTextPane();
        this.txtConverter.setText("");
        this.txtConverter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                CopyRightInfo.this.showContentToPreview();
            }
        });
        scrollPane_1.setViewportView(this.txtConverter);
        this.contentPane.add((Component)btnClean, "6, 6, fill, bottom");
        final JButton btnPreview = new JButton(Messages.getString("CopyRightInfo.btnPreview.text"));
        btnPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CopyRightInfo.this.isShowPreview = CopyRightInfo.this.isShowPreview == false;
                if (CopyRightInfo.this.isShowPreview.booleanValue()) {
                    btnPreview.setText(Messages.getString("CopyRightInfo.btnPreview.text.unShow"));
                    CopyRightInfo.this.showContentToPreview();
                } else {
                    btnPreview.setText(Messages.getString("CopyRightInfo.btnPreview.text"));
                    CopyRightInfo.this.preview.setVisible(false);
                    CopyRightInfo.this.preview.dispose();
                    CopyRightInfo.this.preview = null;
                }
            }
        });
        this.contentPane.add((Component)btnPreview, "6, 8, fill, fill");
        this.contentPane.add((Component)lblcanBeHtml, "2, 15, 3, 1, left, top");
        this.contentPane.add((Component)lblEbookCreator, "2, 2, right, center");
        this.contentPane.add((Component)lblConverter, "2, 4, right, center");
        this.contentPane.add((Component)lblSource, "2, 6, right, center");
        this.contentPane.add((Component)lblAuthor, "2, 8, right, center");
        this.contentPane.add((Component)lblStatus, "2, 12, right, center");
        this.contentPane.add((Component)lblName, "2, 10, right, center");
        this.contentPane.add((Component)lblIntro, "2, 14, right, top");
        this.contentPane.add((Component)scrollPane, "4, 14, fill, fill");
        this.contentPane.add((Component)this.txtStatus, "4, 12, fill, top");
        this.contentPane.add((Component)this.txtName, "4, 10, fill, top");
        this.contentPane.add((Component)this.txtAuthor, "4, 8, fill, top");
        this.contentPane.add((Component)this.txtSource, "4, 6, fill, top");
        this.contentPane.add((Component)this.txtEbookCreator, "4, 2, fill, center");
        this.contentPane.add((Component)btnDownload, "6, 2, fill, top");
        this.contentPane.add((Component)btnSave, "6, 4, fill, top");
        this.setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{this.txtEbookCreator, this.txtSource, this.txtAuthor, this.txtName, this.txtStatus, this.txtInfo, btnDownload, btnSave, btnClean}));
    }

    public void getEbookInfo() {
        this.ebookInfo = CommonValue.getEbookInfoOpen();
        if (!this.txtEbookCreator.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookCreatorHTML(this.txtEbookCreator.getText());
        }
        if (!this.txtConverter.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookConverterHTML(this.txtConverter.getText());
        }
        if (!this.txtSource.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookSourceHTML(this.txtSource.getText());
        }
        if (!this.txtAuthor.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookAuthorHTML(this.txtAuthor.getText());
        }
        if (!this.txtName.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookStoryNameHTML(this.txtName.getText());
        }
        if (!this.txtStatus.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookStatusHTML(this.txtStatus.getText());
        }
        if (!this.txtInfo.getText().isEmpty()) {
            this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookDescriptionHTML(this.txtInfo.getText());
        }
        this.ebookInfo = String.valueOf(this.ebookInfo) + CommonValue.getEbookInfoClose();
    }

    public void showContentToPreview() {
        if (this.isShowPreview.booleanValue()) {
            this.getEbookInfo();
            StringBuilder sb = new StringBuilder();
            sb.append(CommonValue.getHtmlOpenString(this.txtName.getText()));
            sb.append(this.ebookInfo);
            sb.append(CommonValue.getHtmlCloseString());
            if (this.preview == null) {
                this.preview = new PreviewHtml();
            }
            this.preview.loadHtmlContent(sb.toString());
            if (!this.preview.isShowing()) {
                this.preview.setBounds(this.getBounds().x + this.getWidth(), this.getBounds().y, 600, 450);
                this.preview.setAlwaysOnTop(true);
                this.preview.setFocusable(false);
                this.preview.setVisible(true);
            }
        }
    }
}

