/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.util.console;

import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import de.uniba.wiai.lspi.util.console.ConsoleThread;
import de.uniba.wiai.lspi.util.console.MemoryOutputStream;
import java.io.PrintStream;

public class ShowOutputCommand
extends Command {
    public static final String COMMAND_NAME = "displaySystemOut";
    public static final String CLEAR_PARAM = "clear";
    private MemoryOutputStream memOut;

    public ShowOutputCommand(Object[] objects, PrintStream out) {
        super(objects, out);
    }

    public void exec() throws ConsoleException {
        if (this.memOut == null) {
            try {
                ConsoleThread console = ConsoleThread.getConsole();
                this.memOut = (MemoryOutputStream)console.getSystemOutputStream();
            }
            catch (ClassCastException e) {
                throw new ConsoleException("Current System.out does not print  to a MemoryOutputStream. " + e.getMessage());
            }
        }
        try {
            this.memOut.printOutputTo(this.out);
            if (this.parameters.containsKey(CLEAR_PARAM)) {
                this.memOut.clearBuffer();
            }
        }
        catch (Throwable t) {
            throw new ConsoleException("Error while printing saved System.out. " + t.getMessage() + " Maybe current OutputStream is no " + "MemoryOutputStream.");
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("The command '");
        buffer.append(this.getCommandName());
        buffer.append("' can be used to print output, that has been ");
        buffer.append("printed to System.out, which has been redirected to ");
        buffer.append("memory with help of a MemoryOutputStream.");
        buffer.append("\n");
        buffer.append("Parameters: ");
        buffer.append("\n");
        buffer.append("-h/-help");
        buffer.append("\t");
        buffer.append("Displays this message.");
        buffer.append("\n");
        buffer.append("-clear");
        buffer.append("\t");
        buffer.append("The output buffer is cleared after output has been displayed.");
        this.out.println(buffer.toString());
    }
}

