/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.Proxy;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.impl.Entries;
import de.uniba.wiai.lspi.chord.service.impl.FingerTable;
import de.uniba.wiai.lspi.chord.service.impl.SuccessorList;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class References {
    private Logger logger;
    private FingerTable fingerTable = null;
    private SuccessorList successorList = null;
    private Node predecessor = null;
    private ID localID = null;
    private URL localURL = null;
    private Entries entries;

    References(ID locID, URL locURL, int numberOfEntriesInSuccessorList, Entries entries) {
        if (locURL == null || locID == null || entries == null) {
            throw new IllegalArgumentException("No parameter of constructor may be null!");
        }
        if (numberOfEntriesInSuccessorList < 1) {
            throw new IllegalArgumentException("Number of entries in successor list cannot be less than 1! " + numberOfEntriesInSuccessorList + " is not a valid value!");
        }
        this.logger = Logger.getLogger(References.class.getName() + "." + locID);
        this.logger.debug("Logger initialized.");
        this.localID = locID;
        this.localURL = locURL;
        this.entries = entries;
        this.fingerTable = new FingerTable(locID, this);
        this.successorList = new SuccessorList(locID, numberOfEntriesInSuccessorList, this, entries);
    }

    final synchronized Node getClosestPrecedingNode(ID key) {
        Node closestNodeSL;
        if (key == null) {
            NullPointerException e = new NullPointerException("ID may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        HashMap<ID, Node> foundNodes = new HashMap<ID, Node>();
        Node closestNodeFT = this.fingerTable.getClosestPrecedingNode(key);
        if (closestNodeFT != null) {
            foundNodes.put(closestNodeFT.getNodeID(), closestNodeFT);
        }
        if ((closestNodeSL = this.successorList.getClosestPrecedingNode(key)) != null) {
            foundNodes.put(closestNodeSL.getNodeID(), closestNodeSL);
        }
        Node predecessorIfAppropriate = null;
        if (this.predecessor != null && key.isInInterval(this.predecessor.getNodeID(), this.localID)) {
            predecessorIfAppropriate = this.predecessor;
            foundNodes.put(this.predecessor.getNodeID(), this.predecessor);
        }
        Node closestNode = null;
        ArrayList orderedIDList = new ArrayList(foundNodes.keySet());
        orderedIDList.add(key);
        int sizeOfList = orderedIDList.size();
        Collections.sort(orderedIDList);
        int keyIndex = orderedIDList.indexOf(key);
        int index = (sizeOfList + (keyIndex - 1)) % sizeOfList;
        ID idOfclosestNode = (ID)orderedIDList.get(index);
        closestNode = (Node)foundNodes.get(idOfclosestNode);
        if (closestNode == null) {
            throw new NullPointerException("closestNode must not be null!");
        }
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("Closest preceding node of ID " + key + " at node " + this.localID.toString() + " is " + closestNode.getNodeID() + " with closestNodeFT=" + (closestNodeFT == null ? "null" : "" + closestNodeFT.getNodeID()) + " and closestNodeSL=" + (closestNodeSL == null ? "null" : "" + closestNodeSL.getNodeID()) + " and predecessor (only if it precedes given ID)=" + (predecessorIfAppropriate == null ? "null" : "" + predecessorIfAppropriate.getNodeID()));
        }
        return closestNode;
    }

    final synchronized void addReference(Node newReference) {
        if (newReference == null) {
            NullPointerException e = new NullPointerException("Node reference to be added must not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
        if (newReference.getNodeID().equals(this.localID)) {
            if (debug) {
                this.logger.debug("Reference on myself was not added");
            }
            return;
        }
        this.checkIfProxy(newReference);
        this.fingerTable.addReference(newReference);
        this.successorList.addSuccessor(newReference);
        if (debug) {
            this.logger.debug("Attempted to add reference " + newReference.getNodeID().toString() + " to finger table and successor list. Whether it fit " + "or not depends on those data structures.");
        }
    }

    final synchronized void removeReference(Node oldReference) {
        if (oldReference == null) {
            NullPointerException e = new NullPointerException("Reference to remove must not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        this.fingerTable.removeReference(oldReference);
        this.successorList.removeReference(oldReference);
        if (oldReference.equals(this.getPredecessor())) {
            this.predecessor = null;
        }
        this.disconnectIfUnreferenced(oldReference);
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("Attempted to remove reference " + oldReference + " from all data structures including predecessor reference.");
        }
    }

    void disconnectIfUnreferenced(Node removedReference) {
        if (removedReference == null) {
            NullPointerException e = new NullPointerException("Reference may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        if (!this.containsReference(removedReference)) {
            if (!(removedReference instanceof Proxy)) {
                this.logger.error("Attempt to disconnect unused reference failed");
                throw new RuntimeException("Reference should be of type Proxy");
            }
            this.logger.debug("Disconnecting unused reference on node " + removedReference);
            removedReference.disconnect();
        }
    }

    final synchronized Node getSuccessor() {
        return this.successorList.getDirectSuccessor();
    }

    public synchronized String toString() {
        StringBuilder result = new StringBuilder("Node: " + this.localID.toString() + ", " + this.localURL + "\n");
        result.append(this.fingerTable.toString());
        result.append(this.successorList.toString());
        result.append("Predecessor: " + (this.predecessor == null ? "null" : "" + this.predecessor.getNodeID() + ", " + this.predecessor.getNodeURL()));
        return result.toString();
    }

    final synchronized Node getPredecessor() {
        return this.predecessor;
    }

    final synchronized void setPredecessor(Node potentialPredecessor) {
        if (potentialPredecessor == null) {
            NullPointerException e = new NullPointerException("Potential predecessor of method setPredecessor may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        this.checkIfProxy(potentialPredecessor);
        boolean info = this.logger.isEnabledFor(Logger.LogLevel.INFO);
        if (!potentialPredecessor.equals(this.predecessor)) {
            Node formerPredecessor = this.predecessor;
            this.predecessor = potentialPredecessor;
            if (formerPredecessor != null) {
                this.disconnectIfUnreferenced(formerPredecessor);
                int sLSize = this.successorList.getSize();
                if (this.successorList.getCapacity() == sLSize) {
                    Node lastSuccessor = this.successorList.getReferences().get(sLSize - 1);
                    try {
                        lastSuccessor.removeReplicas(this.predecessor.getNodeID(), new HashSet<Entry>());
                    }
                    catch (CommunicationException e) {
                        this.logger.warn("Could not remove replicas on last predecessor", e);
                    }
                }
                if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
                    this.logger.debug("Old predecessor " + formerPredecessor + " was replaced by " + potentialPredecessor);
                }
            } else {
                if (info) {
                    this.logger.info("Predecessor reference set to " + potentialPredecessor + "; was null before.");
                }
                Set<Entry> entriesToRep = this.entries.getEntriesInInterval(this.predecessor.getNodeID(), this.localID);
                List<Node> successors = this.successorList.getReferences();
                for (Node successor : successors) {
                    try {
                        successor.insertReplicas(entriesToRep);
                    }
                    catch (CommunicationException e) {
                        this.logger.warn("Damn. Could not replicate to successor " + successor.getNodeID(), e);
                    }
                }
            }
        }
    }

    final synchronized List<Node> getSuccessors() {
        return this.successorList.getReferences();
    }

    final synchronized boolean containsReference(Node newReference) {
        if (newReference == null) {
            NullPointerException e = new NullPointerException("Reference to look up must not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        return this.fingerTable.containsReference(newReference) || this.successorList.containsReference(newReference) || newReference.equals(this.predecessor);
    }

    final String printFingerTable() {
        return this.fingerTable.toString();
    }

    final String printSuccessorList() {
        return this.successorList.toString();
    }

    void addReferenceAsPredecessor(Node potentialPredecessor) {
        this.checkIfProxy(potentialPredecessor);
        if (potentialPredecessor == null) {
            NullPointerException e = new NullPointerException("Reference to potential predecessor may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        if (this.predecessor == null || potentialPredecessor.getNodeID().isInInterval(this.predecessor.getNodeID(), this.localID)) {
            if (this.logger.isEnabledFor(Logger.LogLevel.INFO)) {
                this.logger.info("Setting a new predecessor reference: New reference is " + potentialPredecessor + ", old reference was " + (this.predecessor == null ? "null" : this.predecessor));
            }
            this.setPredecessor(potentialPredecessor);
        }
        this.addReference(potentialPredecessor);
    }

    public List<Node> getFirstFingerTableEntries(int i) {
        return this.fingerTable.getFirstFingerTableEntries(i);
    }

    private void checkIfProxy(Node node) {
        if (!(node instanceof Proxy)) {
            String msg = "Trying to use local node " + node + " with references. This is not possible." + "If you see this Exception contact the developers!";
            RuntimeException e = new RuntimeException(msg);
            this.logger.fatal(msg, e);
            throw e;
        }
    }
}

