/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Endpoint;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.impl.ChordImpl;
import de.uniba.wiai.lspi.chord.service.impl.Entries;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NodeImpl
extends Node {
    private Endpoint myEndpoint = null;
    private ChordImpl impl;
    private Logger logger;
    private References references;
    private Entries entries;
    private Executor asyncExecutor;
    private Lock notifyLock;

    NodeImpl(ChordImpl impl, ID nodeID, URL nodeURL, References references, Entries entries) {
        if (impl == null || nodeID == null || nodeURL == null || references == null || entries == null) {
            throw new IllegalArgumentException("Parameters of the constructor may not have a null value!");
        }
        this.logger = Logger.getLogger(NodeImpl.class.getName() + "." + nodeID.toString());
        this.impl = impl;
        this.asyncExecutor = impl.getAsyncExecutor();
        this.nodeID = nodeID;
        this.nodeURL = nodeURL;
        this.references = references;
        this.entries = entries;
        this.notifyLock = new ReentrantLock(true);
        this.myEndpoint = Endpoint.createEndpoint(this, nodeURL);
        this.myEndpoint.listen();
    }

    final void acceptEntries() {
        this.myEndpoint.acceptEntries();
    }

    @Override
    public final void disconnect() {
        this.myEndpoint.disconnect();
    }

    @Override
    public final Node findSuccessor(ID key) {
        return this.impl.findSuccessor(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final List<Node> notify(Node potentialPredecessor) {
        this.notifyLock.lock();
        try {
            LinkedList<Node> result = new LinkedList<Node>();
            if (this.references.getPredecessor() != null) {
                result.add(this.references.getPredecessor());
            } else {
                result.add(potentialPredecessor);
            }
            result.addAll(this.references.getSuccessors());
            this.references.addReferenceAsPredecessor(potentialPredecessor);
            LinkedList<Node> linkedList = result;
            return linkedList;
        }
        finally {
            this.notifyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final RefsAndEntries notifyAndCopyEntries(Node potentialPredecessor) throws CommunicationException {
        this.notifyLock.lock();
        try {
            Set<Entry> copiedEntries = this.entries.getEntriesInInterval(this.nodeID, potentialPredecessor.getNodeID());
            RefsAndEntries refsAndEntries = new RefsAndEntries(this.notify(potentialPredecessor), copiedEntries);
            return refsAndEntries;
        }
        finally {
            this.notifyLock.unlock();
        }
    }

    @Override
    public final void ping() {
    }

    @Override
    public final void insertEntry(Entry toInsert) throws CommunicationException {
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("Inserting entry with id " + toInsert.getId() + " at node " + this.nodeID);
        }
        if (this.references.getPredecessor() == null || !toInsert.getId().isInInterval(this.references.getPredecessor().getNodeID(), this.nodeID)) {
            this.references.getPredecessor().insertEntry(toInsert);
            return;
        }
        this.entries.add(toInsert);
        HashSet<Entry> newEntries = new HashSet<Entry>();
        newEntries.add(toInsert);
        final HashSet mustBeFinal = new HashSet(newEntries);
        for (final Node successor : this.references.getSuccessors()) {
            this.asyncExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        successor.insertReplicas(mustBeFinal);
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public final void insertReplicas(Set<Entry> replicatesToInsert) {
        this.entries.addAll(replicatesToInsert);
    }

    @Override
    public final void removeEntry(Entry entryToRemove) throws CommunicationException {
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("Removing entry with id " + entryToRemove.getId() + " at node " + this.nodeID);
        }
        if (this.references.getPredecessor() != null && !entryToRemove.getId().isInInterval(this.references.getPredecessor().getNodeID(), this.nodeID)) {
            this.references.getPredecessor().removeEntry(entryToRemove);
            return;
        }
        this.entries.remove(entryToRemove);
        final HashSet<Entry> entriesToRemove = new HashSet<Entry>();
        entriesToRemove.add(entryToRemove);
        List<Node> successors = this.references.getSuccessors();
        final ID id = this.nodeID;
        for (final Node successor : successors) {
            this.asyncExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        successor.removeReplicas(id, entriesToRemove);
                    }
                    catch (CommunicationException communicationException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public final void removeReplicas(ID sendingNodeID, Set<Entry> replicasToRemove) {
        if (replicasToRemove.size() == 0) {
            boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
            if (debug) {
                this.logger.debug("Removing replicas. Current no. of entries: " + this.entries.getNumberOfStoredEntries());
            }
            Set<Entry> allReplicasToRemove = this.entries.getEntriesInInterval(this.nodeID, sendingNodeID);
            if (debug) {
                this.logger.debug("Replicas to remove " + allReplicasToRemove);
                this.logger.debug("Size of replicas to remove " + allReplicasToRemove.size());
            }
            this.entries.removeAll(allReplicasToRemove);
            if (debug) {
                this.logger.debug("Removed replicas??? Current no. of entries: " + this.entries.getNumberOfStoredEntries());
            }
        } else {
            this.entries.removeAll(replicasToRemove);
        }
    }

    @Override
    public final Set<Entry> retrieveEntries(ID id) throws CommunicationException {
        if (this.references.getPredecessor() != null && !id.isInInterval(this.references.getPredecessor().getNodeID(), this.nodeID)) {
            this.logger.fatal("The rare situation has occured at time " + System.currentTimeMillis() + ", id to look up=" + id + ", id of local node=" + this.nodeID + ", id of predecessor=" + this.references.getPredecessor().getNodeID());
            return this.references.getPredecessor().retrieveEntries(id);
        }
        return this.entries.getEntries(id);
    }

    @Override
    public final void leavesNetwork(Node predecessor) {
        if (this.logger.isEnabledFor(Logger.LogLevel.INFO)) {
            this.logger.info("Leaves network invoked; " + this.nodeID + ". Updating references.");
            this.logger.info("New predecessor " + predecessor.getNodeID());
        }
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("References before update: " + this.references.toString());
        }
        this.references.removeReference(this.references.getPredecessor());
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("References after update: " + this.references.toString());
        }
    }

    final Executor getAsyncExecutor() {
        return this.asyncExecutor;
    }
}

