/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class HashFunction {
    private static HashFunction hashFunction = null;
    private MessageDigest messageDigest;

    static HashFunction getHashFunction() {
        if (hashFunction == null) {
            try {
                hashFunction = new HashFunction(MessageDigest.getInstance("SHA-1"));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("No hash function available!", e);
            }
        }
        return hashFunction;
    }

    private HashFunction(MessageDigest digest1) {
        if (digest1 == null) {
            throw new NullPointerException("Parameter may not be null!");
        }
        this.messageDigest = digest1;
    }

    final int getLengthOfIDsInBytes() {
        return this.messageDigest.getDigestLength();
    }

    final ID getHashKey(Key entry) {
        if (entry == null) {
            throw new IllegalArgumentException("Parameter entry must not be null!");
        }
        if (entry.getBytes() == null || entry.getBytes().length == 0) {
            throw new IllegalArgumentException("Byte representation of Parameter must not be null or have length 0!");
        }
        byte[] testBytes = entry.getBytes();
        return this.createID(testBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ID createID(byte[] testBytes) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            this.messageDigest.reset();
            this.messageDigest.update(testBytes);
            return new ID(this.messageDigest.digest());
        }
    }

    final ID createUniqueNodeID(URL incomingURL) {
        if (incomingURL == null) {
            throw new IllegalArgumentException("URL must not be null!");
        }
        String id = incomingURL.toString();
        ID resultKey = this.createID(id.getBytes());
        return resultKey;
    }
}

