/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FingerTable {
    private final ID localID;
    private final Node[] remoteNodes;
    private final References references;
    private Logger logger;

    FingerTable(ID localID, References references) {
        if (localID == null || references == null) {
            throw new NullPointerException("Neither parameter of the constructor may contain a null value!");
        }
        this.logger = Logger.getLogger(FingerTable.class + "." + localID);
        this.logger.debug("Logger initialized.");
        this.references = references;
        this.localID = localID;
        this.remoteNodes = new Node[localID.getLength()];
    }

    private final void setEntry(int index, Node proxy) {
        if (index < 0 || index >= this.remoteNodes.length) {
            ArrayIndexOutOfBoundsException e = new ArrayIndexOutOfBoundsException("setEntry was invoked with an index out of array bounds; index=" + index + ", length of array=" + this.remoteNodes.length);
            this.logger.error("Out of bounds!", e);
            throw e;
        }
        if (proxy == null) {
            NullPointerException e = new NullPointerException("Reference to proxy may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        this.remoteNodes[index] = proxy;
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            this.logger.debug("Entry " + index + " set to " + proxy.toString());
        }
    }

    private final Node getEntry(int index) {
        if (index < 0 || index >= this.remoteNodes.length) {
            ArrayIndexOutOfBoundsException e = new ArrayIndexOutOfBoundsException("getEntry was invoked with an index out of array bounds; index=" + index + ", length of array=" + this.remoteNodes.length);
            this.logger.error("Out of bounds!", e);
            throw e;
        }
        return this.remoteNodes[index];
    }

    private final void unsetEntry(int index) {
        if (index < 0 || index >= this.remoteNodes.length) {
            ArrayIndexOutOfBoundsException e = new ArrayIndexOutOfBoundsException("unsetEntry was invoked with an index out of array bounds; index=" + index + ", length of array=" + this.remoteNodes.length);
            this.logger.error("Out of bounds!", e);
            throw e;
        }
        Node overwrittenNode = this.getEntry(index);
        this.remoteNodes[index] = null;
        if (overwrittenNode == null) {
            this.logger.debug("unsetEntry did not change anything, because entry was null before.");
        } else {
            this.references.disconnectIfUnreferenced(overwrittenNode);
            if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
                this.logger.debug("Entry set to null: index=" + index + ", overwritten node=" + overwrittenNode.toString());
            }
        }
    }

    final void addReference(Node proxy) {
        ID startOfInterval;
        if (proxy == null) {
            NullPointerException e = new NullPointerException("Reference to add may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        int lowestWrittenIndex = -1;
        int highestWrittenIndex = -1;
        for (int i = 0; i < this.remoteNodes.length && (startOfInterval = this.localID.addPowerOfTwo(i)).isInInterval(this.localID, proxy.getNodeID()); ++i) {
            if (lowestWrittenIndex == -1) {
                lowestWrittenIndex = i;
            }
            highestWrittenIndex = i;
            if (this.getEntry(i) == null) {
                this.setEntry(i, proxy);
                continue;
            }
            if (!proxy.getNodeID().isInInterval(this.localID, this.getEntry(i).getNodeID())) continue;
            Node oldEntry = this.getEntry(i);
            this.setEntry(i, proxy);
            this.references.disconnectIfUnreferenced(oldEntry);
        }
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG) && highestWrittenIndex == -1) {
            this.logger.debug("addReference did not add the given reference, because it did not fit anywhere!");
        }
        if (this.logger.isEnabledFor(Logger.LogLevel.INFO)) {
            if (highestWrittenIndex == lowestWrittenIndex) {
                this.logger.info("Added reference to finger table entry " + highestWrittenIndex);
            } else {
                this.logger.info("Added reference to finger table entries " + lowestWrittenIndex + " to " + highestWrittenIndex);
            }
        }
    }

    final Node[] getCopyOfReferences() {
        this.logger.debug("Returning copy of references.");
        Node[] copy = new Node[this.remoteNodes.length];
        System.arraycopy(this.remoteNodes, 0, copy, 0, this.remoteNodes.length);
        return copy;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("Finger table:\n");
        int lastIndex = -1;
        ID lastNodeID = null;
        URL lastNodeURL = null;
        for (int i = 0; i < this.remoteNodes.length; ++i) {
            Node next = this.remoteNodes[i];
            if (next == null) {
                if (lastIndex == -1 || lastNodeID == null) continue;
                result.append("  " + lastNodeID + ", " + lastNodeURL + " " + (i - 1 - lastIndex > 0 ? "(" + lastIndex + "-" + (i - 1) + ")" : "(" + (i - 1) + ")") + "\n");
                lastIndex = -1;
                lastNodeID = null;
                lastNodeURL = null;
                continue;
            }
            if (lastNodeID == null) {
                lastIndex = i;
                lastNodeID = next.getNodeID();
                lastNodeURL = next.getNodeURL();
                continue;
            }
            if (lastNodeID.equals(next.getNodeID())) continue;
            result.append("  " + lastNodeID + ", " + lastNodeURL + " " + (i - 1 - lastIndex > 0 ? "(" + lastIndex + "-" + (i - 1) + ")" : "(" + (i - 1) + ")") + "\n");
            lastNodeID = next.getNodeID();
            lastNodeURL = next.getNodeURL();
            lastIndex = i;
        }
        if (lastNodeID != null && lastIndex != -1) {
            result.append("  " + lastNodeID + ", " + lastNodeURL + " " + (this.remoteNodes.length - 1 - lastIndex > 0 ? "(" + lastIndex + "-" + (this.remoteNodes.length - 1) + ")" : "(" + (this.remoteNodes.length - 1) + ")") + "\n");
            lastNodeID = null;
        }
        return result.toString();
    }

    final void removeReference(Node node1) {
        Node n;
        int i;
        if (node1 == null) {
            NullPointerException e = new NullPointerException("removeReference cannot be invoked with value null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        int lowestWrittenIndex = -1;
        int highestWrittenIndex = -1;
        Node referenceForReplacement = null;
        for (i = this.localID.getLength() - 1; i >= 0 && !node1.equals(n = this.getEntry(i)); --i) {
            if (n == null) continue;
            referenceForReplacement = n;
        }
        for (i = 0; i < this.remoteNodes.length; ++i) {
            if (!node1.equals(this.remoteNodes[i])) continue;
            if (lowestWrittenIndex == -1) {
                lowestWrittenIndex = i;
            }
            highestWrittenIndex = i;
            if (referenceForReplacement == null) {
                this.unsetEntry(i);
                continue;
            }
            this.setEntry(i, referenceForReplacement);
        }
        ArrayList<Node> referencesOfSuccessorList = new ArrayList<Node>(this.references.getSuccessors());
        referencesOfSuccessorList.remove(node1);
        for (Node referenceToAdd : referencesOfSuccessorList) {
            this.addReference(referenceToAdd);
        }
        if (this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) {
            if (highestWrittenIndex == -1) {
                this.logger.debug("removeReference did not remove the given reference, because it did not exist in finger table anywhere!");
            } else if (highestWrittenIndex == lowestWrittenIndex) {
                this.logger.debug("Removed reference from finger table entry " + highestWrittenIndex);
            } else {
                this.logger.debug("Removed reference from finger table entries " + lowestWrittenIndex + " to " + highestWrittenIndex);
            }
        }
    }

    final Node getClosestPrecedingNode(ID key) {
        if (key == null) {
            NullPointerException e = new NullPointerException("ID to determine the closest preceding node may not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
        for (int i = this.remoteNodes.length - 1; i >= 0; --i) {
            if (this.remoteNodes[i] == null || !this.remoteNodes[i].getNodeID().isInInterval(this.localID, key)) continue;
            if (debug) {
                this.logger.debug("Closest preceding node for ID " + key + " is " + this.remoteNodes[i].toString());
            }
            return this.remoteNodes[i];
        }
        if (debug) {
            this.logger.debug("There is no closest preceding node for ID " + key + " -- returning null!");
        }
        return null;
    }

    final boolean containsReference(Node newReference) {
        if (newReference == null) {
            NullPointerException e = new NullPointerException("Reference to check must not be null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        for (int i = 0; i < this.remoteNodes.length; ++i) {
            if (!newReference.equals(this.remoteNodes[i])) continue;
            return true;
        }
        return false;
    }

    final List<Node> getFirstFingerTableEntries(int i) {
        HashSet<Node> result = new HashSet<Node>();
        for (int j = 0; j < this.remoteNodes.length; ++j) {
            if (this.getEntry(j) != null) {
                result.add(this.getEntry(j));
            }
            if (result.size() >= i) break;
        }
        return new ArrayList<Node>(result);
    }
}

