/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service.impl;

import de.uniba.wiai.lspi.chord.com.CommunicationException;
import de.uniba.wiai.lspi.chord.com.Entry;
import de.uniba.wiai.lspi.chord.com.Node;
import de.uniba.wiai.lspi.chord.com.Proxy;
import de.uniba.wiai.lspi.chord.com.RefsAndEntries;
import de.uniba.wiai.lspi.chord.data.ID;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.chord.service.AsynChord;
import de.uniba.wiai.lspi.chord.service.Chord;
import de.uniba.wiai.lspi.chord.service.ChordCallback;
import de.uniba.wiai.lspi.chord.service.ChordFuture;
import de.uniba.wiai.lspi.chord.service.ChordRetrievalFuture;
import de.uniba.wiai.lspi.chord.service.Key;
import de.uniba.wiai.lspi.chord.service.Report;
import de.uniba.wiai.lspi.chord.service.ServiceException;
import de.uniba.wiai.lspi.chord.service.impl.CheckPredecessorTask;
import de.uniba.wiai.lspi.chord.service.impl.ChordInsertFuture;
import de.uniba.wiai.lspi.chord.service.impl.ChordRemoveFuture;
import de.uniba.wiai.lspi.chord.service.impl.ChordRetrievalFutureImpl;
import de.uniba.wiai.lspi.chord.service.impl.Entries;
import de.uniba.wiai.lspi.chord.service.impl.FixFingerTask;
import de.uniba.wiai.lspi.chord.service.impl.HashFunction;
import de.uniba.wiai.lspi.chord.service.impl.NodeImpl;
import de.uniba.wiai.lspi.chord.service.impl.References;
import de.uniba.wiai.lspi.chord.service.impl.StabilizeTask;
import de.uniba.wiai.lspi.util.logging.Logger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChordImpl
implements Chord,
Report,
AsynChord {
    private static final int ASYNC_CALL_THREADS = Integer.parseInt(System.getProperty(ChordImpl.class.getName() + ".AsyncThread.no"));
    private static final int STABILIZE_TASK_START = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.StabilizeTask.start"));
    private static final int STABILIZE_TASK_INTERVAL = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.StabilizeTask.interval"));
    private static final int FIX_FINGER_TASK_START = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.FixFingerTask.start"));
    private static final int FIX_FINGER_TASK_INTERVAL = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.FixFingerTask.interval"));
    private static final int CHECK_PREDECESSOR_TASK_START = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.CheckPredecessorTask.start"));
    private static final int CHECK_PREDECESSOR_TASK_INTERVAL = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.CheckPredecessorTask.interval"));
    private static final int NUMBER_OF_SUCCESSORS = Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.successors")) < 1 ? 1 : Integer.parseInt(System.getProperty("de.uniba.wiai.lspi.chord.service.impl.ChordImpl.successors"));
    protected Logger logger = Logger.getLogger(ChordImpl.class.getName() + ".unidentified");
    private NodeImpl localNode;
    private Entries entries;
    private ScheduledExecutorService maintenanceTasks;
    private ExecutorService asyncExecutor;
    protected References references;
    private HashFunction hashFunction;
    private URL localURL;
    private ID localID;

    public ChordImpl() {
        this.logger.debug("Logger initialized.");
        this.maintenanceTasks = new ScheduledThreadPoolExecutor(3, new ChordThreadFactory("MaintenanceTaskExecution"));
        this.asyncExecutor = Executors.newFixedThreadPool(ASYNC_CALL_THREADS, new ChordThreadFactory("AsynchronousExecution"));
        this.hashFunction = HashFunction.getHashFunction();
        this.logger.info("ChordImpl initialized!");
    }

    final Executor getAsyncExecutor() {
        if (this.asyncExecutor == null) {
            throw new NullPointerException("ChordImpl.asyncExecutor is null!");
        }
        return this.asyncExecutor;
    }

    @Override
    public final URL getURL() {
        return this.localURL;
    }

    @Override
    public final void setURL(URL nodeURL) {
        if (nodeURL == null) {
            NullPointerException e = new NullPointerException("Cannot set URL to null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        if (this.localNode != null) {
            IllegalStateException e = new IllegalStateException("URL cannot be set after creating or joining a network!");
            this.logger.error("Illegal state.", e);
            throw e;
        }
        this.localURL = nodeURL;
        this.logger.info("URL was set to " + nodeURL);
    }

    @Override
    public final ID getID() {
        return this.localID;
    }

    @Override
    public final void setID(ID nodeID) {
        if (nodeID == null) {
            NullPointerException e = new NullPointerException("Cannot set ID to null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        if (this.localNode != null) {
            IllegalStateException e = new IllegalStateException("ID cannot be set after creating or joining a network!");
            this.logger.error("Illegal state.", e);
            throw e;
        }
        this.localID = nodeID;
        this.logger = Logger.getLogger(ChordImpl.class.getName() + "." + this.localID);
    }

    @Override
    public final void create() throws ServiceException {
        if (this.localNode != null) {
            throw new ServiceException("Cannot create network; node is already connected!");
        }
        if (this.localURL == null) {
            throw new ServiceException("Node URL is not set yet!");
        }
        if (this.getID() == null) {
            this.setID(this.hashFunction.createUniqueNodeID(this.localURL));
        }
        this.createHelp();
    }

    @Override
    public final void create(URL localURL1) throws ServiceException {
        if (localURL1 == null) {
            throw new NullPointerException("At least one parameter is null which is not permitted!");
        }
        if (this.localNode != null) {
            throw new ServiceException("Cannot create network; node is already connected!");
        }
        this.localURL = localURL1;
        if (this.getID() == null) {
            this.setID(this.hashFunction.createUniqueNodeID(this.localURL));
        }
        this.createHelp();
    }

    @Override
    public final void create(URL localURL1, ID localID1) throws ServiceException {
        if (localURL1 == null || localID1 == null) {
            throw new IllegalArgumentException("At least one parameter is null which is not permitted!");
        }
        if (this.localNode != null) {
            throw new ServiceException("Cannot create network; node is already connected!");
        }
        this.localURL = localURL1;
        this.setID(localID1);
        this.createHelp();
    }

    private final void createHelp() {
        this.logger.debug("Help method for creating a new Chord ring invoked.");
        this.entries = new Entries();
        if (NUMBER_OF_SUCCESSORS < 1) {
            throw new RuntimeException("NUMBER_OF_SUCCESSORS intialized with wrong value! " + NUMBER_OF_SUCCESSORS);
        }
        this.references = new References(this.getID(), this.getURL(), NUMBER_OF_SUCCESSORS, this.entries);
        this.localNode = new NodeImpl(this, this.getID(), this.localURL, this.references, this.entries);
        this.createTasks();
        this.localNode.acceptEntries();
    }

    private final void createTasks() {
        this.maintenanceTasks.scheduleWithFixedDelay(new StabilizeTask(this.localNode, this.references, this.entries), STABILIZE_TASK_START, STABILIZE_TASK_INTERVAL, TimeUnit.SECONDS);
        this.maintenanceTasks.scheduleWithFixedDelay(new FixFingerTask(this.localNode, this.getID(), this.references), FIX_FINGER_TASK_START, FIX_FINGER_TASK_INTERVAL, TimeUnit.SECONDS);
        this.maintenanceTasks.scheduleWithFixedDelay(new CheckPredecessorTask(this.references), CHECK_PREDECESSOR_TASK_START, CHECK_PREDECESSOR_TASK_INTERVAL, TimeUnit.SECONDS);
    }

    @Override
    public final void join(URL bootstrapURL) throws ServiceException {
        if (bootstrapURL == null) {
            throw new NullPointerException("At least one parameter is null which is not permitted!");
        }
        if (this.localNode != null) {
            throw new ServiceException("Cannot join network; node is already connected!");
        }
        if (this.localURL == null) {
            throw new ServiceException("Node URL is not set yet! Please set URL with help of setURL(URL) before invoking join(URL)!");
        }
        if (this.getID() == null) {
            this.setID(this.hashFunction.createUniqueNodeID(this.localURL));
        }
        this.joinHelp(bootstrapURL);
    }

    @Override
    public final void join(URL localURL1, URL bootstrapURL) throws ServiceException {
        if (localURL1 == null || bootstrapURL == null) {
            throw new NullPointerException("At least one parameter is null which is not permitted!");
        }
        if (this.localNode != null) {
            throw new ServiceException("Cannot join network; node is already connected!");
        }
        this.localURL = localURL1;
        if (this.getID() == null) {
            this.setID(this.hashFunction.createUniqueNodeID(this.localURL));
        }
        this.joinHelp(bootstrapURL);
    }

    @Override
    public final void join(URL localURL1, ID localID1, URL bootstrapURL) throws ServiceException {
        if (localURL1 == null || localID1 == null || bootstrapURL == null) {
            throw new NullPointerException("At least one parameter is null which is not permitted!");
        }
        if (this.localNode != null) {
            throw new ServiceException("Cannot join network; node is already connected!");
        }
        this.localURL = localURL1;
        this.setID(localID1);
        this.joinHelp(bootstrapURL);
    }

    private final void joinHelp(URL bootstrapURL) throws ServiceException {
        RefsAndEntries copyOfRefsAndEntries;
        Node mySuccessor;
        Node bootstrapNode;
        this.entries = new Entries();
        if (NUMBER_OF_SUCCESSORS < 1) {
            throw new RuntimeException("NUMBER_OF_SUCCESSORS intialized with wrong value! " + NUMBER_OF_SUCCESSORS);
        }
        this.references = new References(this.getID(), this.getURL(), NUMBER_OF_SUCCESSORS, this.entries);
        this.localNode = new NodeImpl(this, this.getID(), this.localURL, this.references, this.entries);
        try {
            bootstrapNode = Proxy.createConnection(this.localURL, bootstrapURL);
        }
        catch (CommunicationException e) {
            throw new ServiceException("An error occured when creating a proxy for outgoing connection to bootstrap node! Join operationfailed!", e);
        }
        this.references.addReference(bootstrapNode);
        try {
            mySuccessor = bootstrapNode.findSuccessor(this.getID());
        }
        catch (CommunicationException e1) {
            throw new ServiceException("An error occured when trying to find the successor of this node using bootstrap node with url " + bootstrapURL.toString() + "! Join " + "operation failed!", e1);
        }
        this.logger.info(this.localURL + " has successor " + mySuccessor.getNodeURL());
        this.references.addReference(mySuccessor);
        try {
            copyOfRefsAndEntries = mySuccessor.notifyAndCopyEntries(this.localNode);
        }
        catch (CommunicationException e2) {
            throw new ServiceException("An error occured when contacting the successor of this node in order to obtain its references and entries! Join operation failed!", e2);
        }
        List<Node> refs = copyOfRefsAndEntries.getRefs();
        boolean predecessorSet = false;
        boolean count = false;
        while (!predecessorSet) {
            this.logger.debug("Size of refs: " + refs.size());
            if (refs.size() == 1) {
                this.logger.info("Adding successor as predecessor as there are only two peers! " + mySuccessor);
                this.references.addReferenceAsPredecessor(mySuccessor);
                predecessorSet = true;
                this.logger.debug("Actual predecessor: " + this.references.getPredecessor());
                continue;
            }
            if (this.getID().isInInterval(refs.get(0).getNodeID(), mySuccessor.getNodeID())) {
                this.references.addReferenceAsPredecessor(refs.get(0));
                predecessorSet = true;
                continue;
            }
            this.logger.info("Wrong successor found. Going backwards!!!");
            this.references.addReference(refs.get(0));
            try {
                copyOfRefsAndEntries = refs.get(0).notifyAndCopyEntries(this.localNode);
                refs = copyOfRefsAndEntries.getRefs();
            }
            catch (CommunicationException e) {
                throw new ServiceException("An error occured when contacting the successor of this node in order to obtain its references and entries! Join operation failed!", e);
            }
        }
        for (Node newReference : copyOfRefsAndEntries.getRefs()) {
            if (newReference == null || newReference.equals(this.localNode) || this.references.containsReference(newReference)) continue;
            this.references.addReference(newReference);
            if (!this.logger.isEnabledFor(Logger.LogLevel.DEBUG)) continue;
            this.logger.debug("Added reference on " + newReference.getNodeID() + " which responded to " + "ping request");
        }
        this.entries.addAll(copyOfRefsAndEntries.getEntries());
        this.localNode.acceptEntries();
        this.createTasks();
    }

    @Override
    public final void leave() {
        if (this.localNode == null) {
            return;
        }
        this.maintenanceTasks.shutdownNow();
        try {
            Node successor = this.references.getSuccessor();
            if (successor != null && this.references.getPredecessor() != null) {
                successor.leavesNetwork(this.references.getPredecessor());
            }
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
        this.localNode.disconnect();
        this.asyncExecutor.shutdownNow();
        this.localNode = null;
    }

    @Override
    public final void insert(Key key, Serializable s) {
        if (key == null || s == null) {
            throw new NullPointerException("Neither parameter may have value null!");
        }
        ID id = this.hashFunction.getHashKey(key);
        Entry entryToInsert = new Entry(id, s);
        boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
        if (debug) {
            this.logger.debug("Inserting new entry with id " + id);
        }
        boolean inserted = false;
        while (!inserted) {
            Node responsibleNode = this.findSuccessor(id);
            if (debug) {
                this.logger.debug("Invoking insertEntry method on node " + responsibleNode.getNodeID());
            }
            try {
                responsibleNode.insertEntry(entryToInsert);
                inserted = true;
            }
            catch (CommunicationException e1) {
                if (!debug) continue;
                this.logger.debug("An error occured while invoking the insertEntry method  on the appropriate node! Insert operation failed!", e1);
            }
        }
        this.logger.debug("New entry was inserted!");
    }

    @Override
    public final Set<Serializable> retrieve(Key key) {
        if (key == null) {
            NullPointerException e = new NullPointerException("Key must not have value null!");
            this.logger.error("Null pointer", e);
            throw e;
        }
        ID id = this.hashFunction.getHashKey(key);
        boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
        if (debug) {
            this.logger.debug("Retrieving entries with id " + id);
        }
        Set<Entry> result = null;
        boolean retrieved = false;
        while (!retrieved) {
            Node responsibleNode = null;
            responsibleNode = this.findSuccessor(id);
            try {
                result = responsibleNode.retrieveEntries(id);
                retrieved = true;
            }
            catch (CommunicationException e1) {
                if (!debug) continue;
                this.logger.debug("An error occured while invoking the retrieveEntry method  on the appropriate node! Retrieve operation failed!", e1);
            }
        }
        HashSet<Serializable> values = new HashSet<Serializable>();
        if (result != null) {
            for (Entry entry : result) {
                values.add(entry.getValue());
            }
        }
        this.logger.debug("Entries were retrieved!");
        return values;
    }

    @Override
    public final void remove(Key key, Serializable s) {
        if (key == null || s == null) {
            throw new NullPointerException("Neither parameter may have value null!");
        }
        ID id = this.hashFunction.getHashKey(key);
        Entry entryToRemove = new Entry(id, s);
        boolean removed = false;
        while (!removed) {
            boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
            if (debug) {
                this.logger.debug("Removing entry with id " + id + " and value " + s);
            }
            Node responsibleNode = this.findSuccessor(id);
            if (debug) {
                this.logger.debug("Invoking removeEntry method on node " + responsibleNode.getNodeID());
            }
            try {
                responsibleNode.removeEntry(entryToRemove);
                removed = true;
            }
            catch (CommunicationException e1) {
                if (!debug) continue;
                this.logger.debug("An error occured while invoking the removeEntry method  on the appropriate node! Remove operation failed!", e1);
            }
        }
        this.logger.debug("Entry was removed!");
    }

    public final String toString() {
        return "Chord node: id = " + (this.localID == null ? "null" : this.localID.toString()) + ", url = " + (this.localURL == null ? "null" : this.localURL.toString() + "\n");
    }

    final Node findSuccessor(ID key) {
        if (key == null) {
            NullPointerException e = new NullPointerException("ID to find successor for may not be null!");
            this.logger.error("Null pointer.", e);
            throw e;
        }
        boolean debug = this.logger.isEnabledFor(Logger.LogLevel.DEBUG);
        Node successor = this.references.getSuccessor();
        if (successor == null) {
            if (this.logger.isEnabledFor(Logger.LogLevel.INFO)) {
                this.logger.info("I appear to be the only node in the network, so I am my own successor; return reference on me: " + this.getID());
            }
            return this.localNode;
        }
        if (key.isInInterval(this.getID(), successor.getNodeID()) || key.equals(successor.getNodeID())) {
            if (debug) {
                this.logger.debug("The requested key lies between my own and my successor's node id; therefore return my successor.");
            }
            try {
                if (debug) {
                    this.logger.debug("Returning my successor " + successor.getNodeID() + " of type " + successor.getClass());
                }
                return successor;
            }
            catch (Exception e) {
                this.logger.warn("Successor did not respond! Removing it from all lists and retrying...");
                this.references.removeReference(successor);
                return this.findSuccessor(key);
            }
        }
        Node closestPrecedingNode = this.references.getClosestPrecedingNode(key);
        try {
            if (debug) {
                this.logger.debug("Asking closest preceding node known to this node for closest preceding node " + closestPrecedingNode.getNodeID() + " concerning key " + key + " to look up");
            }
            return closestPrecedingNode.findSuccessor(key);
        }
        catch (CommunicationException e) {
            this.logger.error("Communication failure while requesting successor for key " + key + " from node " + closestPrecedingNode.toString() + " - looking up successor for failed node " + closestPrecedingNode.toString());
            this.references.removeReference(closestPrecedingNode);
            return this.findSuccessor(key);
        }
    }

    @Override
    public final String printEntries() {
        return this.entries.toString();
    }

    @Override
    public final String printFingerTable() {
        return this.references.printFingerTable();
    }

    @Override
    public final String printSuccessorList() {
        return this.references.printSuccessorList();
    }

    @Override
    public final String printReferences() {
        return this.references.toString();
    }

    @Override
    public final String printPredecessor() {
        Node pre = this.references.getPredecessor();
        if (pre == null) {
            return "Predecessor: null";
        }
        return "Predecessor: " + pre.toString();
    }

    @Override
    public void retrieve(final Key key, final ChordCallback callback) {
        final ChordImpl chord = this;
        this.asyncExecutor.execute(new Runnable(){

            public void run() {
                Throwable t = null;
                Set<Serializable> result = null;
                try {
                    result = chord.retrieve(key);
                }
                catch (ServiceException e) {
                    t = e;
                }
                catch (Throwable th) {
                    t = th;
                }
                callback.retrieved(key, result, t);
            }
        });
    }

    @Override
    public void insert(final Key key, final Serializable entry, final ChordCallback callback) {
        final ChordImpl chord = this;
        this.asyncExecutor.execute(new Runnable(){

            public void run() {
                Throwable t = null;
                try {
                    chord.insert(key, entry);
                }
                catch (ServiceException e) {
                    t = e;
                }
                catch (Throwable th) {
                    t = th;
                }
                callback.inserted(key, entry, t);
            }
        });
    }

    @Override
    public void remove(final Key key, final Serializable entry, final ChordCallback callback) {
        final ChordImpl chord = this;
        this.asyncExecutor.execute(new Runnable(){

            public void run() {
                Throwable t = null;
                try {
                    chord.remove(key, entry);
                }
                catch (ServiceException e) {
                    t = e;
                }
                catch (Throwable th) {
                    t = th;
                }
                callback.removed(key, entry, t);
            }
        });
    }

    @Override
    public ChordRetrievalFuture retrieveAsync(Key key) {
        return ChordRetrievalFutureImpl.create(this.asyncExecutor, this, key);
    }

    @Override
    public ChordFuture insertAsync(Key key, Serializable entry) {
        return ChordInsertFuture.create(this.asyncExecutor, this, key, entry);
    }

    @Override
    public ChordFuture removeAsync(Key key, Serializable entry) {
        return ChordRemoveFuture.create(this.asyncExecutor, this, key, entry);
    }

    private static class ChordThreadFactory
    implements ThreadFactory {
        private String executorName;

        ChordThreadFactory(String executorName) {
            this.executorName = executorName;
        }

        public Thread newThread(Runnable r) {
            Thread newThread = new Thread(r);
            newThread.setName(this.executorName + "-" + newThread.getName());
            return newThread;
        }
    }
}

