/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.service;

import java.io.IOException;
import java.util.Properties;

public final class PropertiesLoader {
    private static boolean loaded = false;
    public static final String PROPERTY_WHERE_TO_FIND_PROPERTY_FILE = "chord.properties.file";
    public static final String STANDARD_PROPERTY_FILE = "chord.properties";

    private PropertiesLoader() {
    }

    public static void loadPropertyFile() {
        if (loaded) {
            throw new IllegalStateException("Properties have already been loaded!");
        }
        loaded = true;
        String file = STANDARD_PROPERTY_FILE;
        if (System.getProperty(PROPERTY_WHERE_TO_FIND_PROPERTY_FILE) != null && System.getProperty(PROPERTY_WHERE_TO_FIND_PROPERTY_FILE).length() != 0) {
            file = System.getProperty(PROPERTY_WHERE_TO_FIND_PROPERTY_FILE);
        }
        try {
            Properties props = System.getProperties();
            props.load(ClassLoader.getSystemResourceAsStream(file));
            System.setProperties(props);
        }
        catch (IOException e) {
            throw new RuntimeException("Property file was not found: " + file + "! It must be located in the CLASSPATH and " + "either be named 'chord.properties' or its name " + "be specified by -Dchord.properties.file='filename'", e);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("Property file was not found: " + file + "! It must be located in the CLASSPATH and " + "either be named 'chord.properties' or its name " + "be specified by -Dchord.properties.file='filename'", e);
        }
    }
}

