/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.data;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ID
implements Comparable<ID>,
Serializable {
    private static final long serialVersionUID = 6860626236168125168L;
    private static final int HEX = 2;
    private static final int DEC = 1;
    private static final int BIN = 0;
    private static int displayedRepresentation = 2;
    private static int numberOfDisplayedBytes;
    private final byte[] id;
    private transient String stringRepresentation = null;

    public ID(byte[] id1) {
        this.id = new byte[id1.length];
        System.arraycopy(id1, 0, this.id, 0, id1.length);
    }

    public final String toString() {
        if (this.stringRepresentation == null) {
            int rep = displayedRepresentation;
            switch (rep) {
                case 0: {
                    this.stringRepresentation = this.toBinaryString(numberOfDisplayedBytes);
                    break;
                }
                case 1: {
                    this.stringRepresentation = this.toDecimalString(numberOfDisplayedBytes);
                    break;
                }
                default: {
                    this.stringRepresentation = this.toHexString(numberOfDisplayedBytes);
                }
            }
        }
        return this.stringRepresentation;
    }

    public final String toHexString(int numberOfBytes) {
        int displayBytes = Math.max(1, Math.min(numberOfBytes, this.id.length));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < displayBytes; ++i) {
            String block = Integer.toHexString(this.id[i] & 0xFF).toUpperCase();
            if (block.length() < 2) {
                block = "0" + block;
            }
            result.append(block + " ");
        }
        return result.toString();
    }

    public final String toHexString() {
        return this.toHexString(this.id.length);
    }

    public final String toDecimalString(int numberOfBytes) {
        int displayBytes = Math.max(1, Math.min(numberOfBytes, this.id.length));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < displayBytes; ++i) {
            String block = Integer.toString(this.id[i] & 0xFF);
            result.append(block + " ");
        }
        return result.toString();
    }

    public final String toDecimalString() {
        return this.toDecimalString(this.id.length);
    }

    public final String toBinaryString(int numberOfBytes) {
        int displayBytes = Math.max(1, Math.min(numberOfBytes, this.id.length));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < displayBytes; ++i) {
            String block = Integer.toBinaryString(this.id[i] & 0xFF);
            while (block.length() < 8) {
                block = "0" + block;
            }
            result.append(block + " ");
        }
        return result.toString();
    }

    public final String toBinaryString() {
        return this.toBinaryString(this.id.length);
    }

    public final int getLength() {
        return this.id.length * 8;
    }

    public final ID addPowerOfTwo(int powerOfTwo) {
        byte oldValue;
        if (powerOfTwo < 0 || powerOfTwo >= this.id.length * 8) {
            throw new IllegalArgumentException("The power of two is out of range! It must be in the interval [0, length-1]");
        }
        byte[] copy = new byte[this.id.length];
        System.arraycopy(this.id, 0, copy, 0, this.id.length);
        int indexOfByte = this.id.length - 1 - powerOfTwo / 8;
        byte[] toAdd = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
        byte valueToAdd = toAdd[powerOfTwo % 8];
        do {
            oldValue = copy[indexOfByte];
            int n = indexOfByte;
            copy[n] = (byte)(copy[n] + valueToAdd);
            valueToAdd = 1;
        } while (oldValue < 0 && copy[indexOfByte] >= 0 && indexOfByte-- > 0);
        return new ID(copy);
    }

    public final boolean equals(Object equalsTo) {
        if (equalsTo == null || !(equalsTo instanceof ID)) {
            return false;
        }
        return this.compareTo((ID)equalsTo) == 0;
    }

    @Override
    public final int compareTo(ID otherKey) throws ClassCastException {
        if (this.getLength() != otherKey.getLength()) {
            throw new ClassCastException("Only ID objects with same length can be compared! This ID is " + this.id.length + " bits long while the other ID is " + otherKey.getLength() + " bits long.");
        }
        byte[] otherBytes = new byte[this.id.length];
        System.arraycopy(otherKey.id, 0, otherBytes, 0, this.id.length);
        for (int i = 0; i < this.id.length; ++i) {
            if ((byte)(this.id[i] - 128) < (byte)(otherBytes[i] - 128)) {
                return -1;
            }
            if ((byte)(this.id[i] - 128) <= (byte)(otherBytes[i] - 128)) continue;
            return 1;
        }
        return 0;
    }

    public final int hashCode() {
        int result = 19;
        for (int i = 0; i < this.id.length; ++i) {
            result = 13 * result + this.id[i];
        }
        return result;
    }

    public final boolean isInInterval(ID fromID, ID toID) {
        if (fromID.equals(toID)) {
            return !this.equals(fromID);
        }
        if (fromID.compareTo(toID) < 0) {
            return this.compareTo(fromID) > 0 && this.compareTo(toID) < 0;
        }
        byte[] minIDBytes = new byte[this.id.length];
        ID minID = new ID(minIDBytes);
        byte[] maxIDBytes = new byte[this.id.length];
        for (int i = 0; i < maxIDBytes.length; ++i) {
            maxIDBytes[i] = -1;
        }
        ID maxID = new ID(maxIDBytes);
        return !fromID.equals(maxID) && this.compareTo(fromID) > 0 && this.compareTo(maxID) <= 0 || !minID.equals(toID) && this.compareTo(minID) >= 0 && this.compareTo(toID) < 0;
    }

    static {
        String property = System.getProperty(ID.class.getName() + ".displayed.representation");
        if (property != null && property.length() > 0) {
            displayedRepresentation = Integer.parseInt(property);
        }
        numberOfDisplayedBytes = Integer.MAX_VALUE;
        String numberProperty = System.getProperty(ID.class.getName() + ".number.of.displayed.bytes");
        if (numberProperty != null && numberProperty.length() > 0) {
            numberOfDisplayedBytes = Integer.parseInt(numberProperty);
        }
    }
}

