/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.ChordImplAccess;
import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.net.MalformedURLException;

public class ShowEntries
extends Command {
    public static final String COMMAND_NAME = "entries";
    public static final String NODE_PARAM = "node";

    public ShowEntries(Object[] toCommand1, PrintStream out1) {
        super(toCommand1, out1);
    }

    public void exec() throws ConsoleException {
        String nodeName = (String)this.parameters.get(NODE_PARAM);
        Registry reg = (Registry)this.toCommand[0];
        if (nodeName == null || nodeName.length() == 0) {
            for (ThreadEndpoint ep : reg.lookupAll().values()) {
                this.out.print("Node " + ep.getURL().getHost() + ": ");
                this.out.println(ChordImplAccess.fetchChordImplOfNode(ep.getNode()).printEntries());
            }
        } else {
            URL url = null;
            try {
                url = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + nodeName + "/");
            }
            catch (MalformedURLException e1) {
                throw new ConsoleException(e1.getMessage());
            }
            this.out.println("Retrieving node " + nodeName);
            ThreadEndpoint ep = reg.lookup(url);
            if (ep != null) {
                this.out.println(ChordImplAccess.fetchChordImplOfNode(ep.getNode()).printEntries());
            } else {
                this.out.println("Could not find node with name " + nodeName);
            }
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("This command displays the entries of a node. The name \n of the node must be provided with help of parameter 'node'");
    }
}

