/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.wiai.lspi.chord.console.command;

import de.uniba.wiai.lspi.chord.com.local.ChordImplAccess;
import de.uniba.wiai.lspi.chord.com.local.Registry;
import de.uniba.wiai.lspi.chord.com.local.ThreadEndpoint;
import de.uniba.wiai.lspi.chord.console.command.entry.Key;
import de.uniba.wiai.lspi.chord.data.URL;
import de.uniba.wiai.lspi.util.console.Command;
import de.uniba.wiai.lspi.util.console.ConsoleException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Set;

public class Retrieve
extends Command {
    public static final String COMMAND_NAME = "retrieve";
    protected static final String NODE_PARAM = "node";
    protected static final String KEY_PARAM = "key";

    public Retrieve(Object[] toCommand1, PrintStream out11) {
        super(toCommand1, out11);
    }

    public void exec() throws ConsoleException {
        String node = (String)this.parameters.get(NODE_PARAM);
        String key = (String)this.parameters.get(KEY_PARAM);
        if (node == null || node.length() == 0) {
            throw new ConsoleException("Not enough parameters! node is missing.");
        }
        if (key == null || key.length() == 0) {
            throw new ConsoleException("Not enough parameters! key is missing.");
        }
        URL url = null;
        try {
            url = new URL(URL.KNOWN_PROTOCOLS.get(1) + "://" + node + "/");
        }
        catch (MalformedURLException e1) {
            throw new ConsoleException(e1.getMessage());
        }
        Key keyObject = new Key(key);
        ThreadEndpoint ep = Registry.getRegistryInstance().lookup(url);
        if (ep == null) {
            this.out.println("Node '" + node + "' does not exist!");
            return;
        }
        try {
            Set<Serializable> vs = ChordImplAccess.fetchChordImplOfNode(ep.getNode()).retrieve(keyObject);
            Object[] values = vs.toArray(new Object[vs.size()]);
            this.out.println("Values associated with key '" + key + "': ");
            for (int i = 0; i < values.length; ++i) {
                this.out.print(values[i]);
                if (i != values.length - 1) {
                    this.out.print(",");
                }
                this.out.print(" ");
            }
            this.out.println();
            this.out.println("Values retrieved from node '" + node + "'");
        }
        catch (Throwable t) {
            ConsoleException e = new ConsoleException("Exception during execution of command. " + t.getMessage());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    public String getCommandName() {
        return COMMAND_NAME;
    }

    public void printOutHelp() {
        this.out.println("This command retrieves and displays the values stored for a provided key in the chord network.");
        this.out.println("The search is initiated by the node provided as parameter.");
        this.out.println("Required parameters: ");
        this.out.println("\tnode: The name of the node, by that the search is initiated.");
        this.out.println("\tkey: The key for the values.");
        this.out.println();
    }
}

